/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import uk.ac.sanger.artemis.io.BlastStreamFeature;
import uk.ac.sanger.artemis.io.EMBLObject;
import uk.ac.sanger.artemis.io.EmblMisc;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.FeatureHeader;
import uk.ac.sanger.artemis.io.GFFMisc;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.GenbankMisc;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.MSPcrunchStreamFeature;
import uk.ac.sanger.artemis.io.ReadFormatException;
import uk.ac.sanger.artemis.io.StreamSequenceFactory;
import uk.ac.sanger.artemis.util.LinePushBackReader;

abstract class LineGroup
extends EMBLObject {
    private static final int UNKNOWN = 0;
    static final int END_OF_ENTRY = 1;
    static final String END_OF_ENTRY_STRING = "//";
    static final int SEQUENCE = 2;
    static final String EMBL_SEQUENCE_STRING = "SQ";
    static final int EMBL_FEATURE = 3;
    static final String EMBL_FEATURE_STRING = "FT";
    static final int EMBL_FEATURE_HEADER = 4;
    static final String EMBL_FEATURE_HEADER_STRING = "FH";
    static final int GENBANK_FEATURE = 5;
    static final int EMBL_MISC = 6;
    static final int GENBANK_MISC = 7;
    static final int GFF_MISC = 8;
    static final int GFF_FEATURE = 9;
    static final int MSPCRUNCH_FEATURE = 10;
    static final int BLAST_FEATURE = 11;
    static final int BINARY_CHARACTERS = 12;
    static final int BSML_XML = 13;
    static final int AGAVE_XML = 14;
    static final int GAME_XML = 15;
    private static Hashtable genbank_hash = null;

    static {
        genbank_hash = new Hashtable();
        genbank_hash.put("LOCUS", "LOCUS");
        genbank_hash.put("DEFINITION", "DEFINITION");
        genbank_hash.put("ACCESSION", "ACCESSION");
        genbank_hash.put("NID", "NID");
        genbank_hash.put("VERSION", "VERSION");
        genbank_hash.put("KEYWORDS", "KEYWORDS");
        genbank_hash.put("SOURCE", "SOURCE");
        genbank_hash.put("REFERENCE", "REFERENCE");
        genbank_hash.put("COMMENT", "COMMENT");
        genbank_hash.put("FEATURES", "FEATURES");
        genbank_hash.put("SEGMENT", "SEGMENT");
    }

    LineGroup() {
    }

    public static LineGroup readNextLineGroup(LinePushBackReader reader) throws IOException, InvalidRelationException {
        String line;
        block14: while (true) {
            if ((line = reader.readLine()) == null) {
                return null;
            }
            int i = 0;
            while (true) {
                if (i >= line.length()) continue block14;
                char letter = line.charAt(i);
                if (letter != ' ' && letter != '\t') break block14;
                ++i;
            }
            break;
        }
        int line_type = LineGroup.getLineType(line);
        reader.pushBack(line);
        switch (line_type) {
            case 2: {
                return StreamSequenceFactory.makeStreamSequence(reader);
            }
            case 3: {
                return EmblStreamFeature.readFromStream(reader);
            }
            case 4: {
                return new FeatureHeader(reader);
            }
            case 5: {
                return GenbankStreamFeature.readFromStream(reader);
            }
            case 9: {
                return GFFStreamFeature.readFromStream(reader);
            }
            case 11: {
                return BlastStreamFeature.readFromStream(reader);
            }
            case 10: {
                return MSPcrunchStreamFeature.readFromStream(reader);
            }
            case 1: {
                reader.readLine();
                return null;
            }
            case 6: {
                return new EmblMisc(reader);
            }
            case 7: {
                return new GenbankMisc(reader);
            }
            case 8: {
                return new GFFMisc(reader);
            }
            case 12: {
                throw new ReadFormatException("cannot recognise format of binary file");
            }
        }
        throw new ReadFormatException("reader got confused - unknown line type", reader.getLineNumber());
    }

    public static int getLineType(String line) {
        if (line.startsWith("<?xml")) {
            return 15;
        }
        if (line.startsWith("#")) {
            return 8;
        }
        if (line.length() >= 2 && (line.charAt(0) == '/' || Character.isLetter(line.charAt(0))) && (line.charAt(1) == '/' || Character.isLetter(line.charAt(1))) && (line.length() == 2 || line.length() == 3 && line.endsWith(" ") || line.length() == 4 && line.endsWith("  ") || line.length() >= 5 && line.substring(2, 5).equals("   ") || line.startsWith("HD * confidential"))) {
            if (line.startsWith(EMBL_FEATURE_STRING)) {
                return 3;
            }
            if (line.startsWith(END_OF_ENTRY_STRING)) {
                return 1;
            }
            if (line.startsWith(EMBL_SEQUENCE_STRING)) {
                return 2;
            }
            if (line.startsWith(EMBL_FEATURE_HEADER_STRING)) {
                return 4;
            }
            return 6;
        }
        if (line.length() > 21 && (line.startsWith("     ") && (Character.isLetter(line.charAt(5)) || Character.isDigit(line.charAt(5)) || line.charAt(5) == '-') && line.charAt(20) == ' ' || line.startsWith("                    ") && line.trim().length() > 0)) {
            return 5;
        }
        int genbank_type = LineGroup.getGenbankType(line);
        if (genbank_type != 0) {
            return 7;
        }
        if (LineGroup.isMSPcrunchLine(line)) {
            return 10;
        }
        if (LineGroup.isBlastLine(line)) {
            return 11;
        }
        if (LineGroup.isGFFLine(line)) {
            return 9;
        }
        if (LineGroup.looksLikeBinary(line)) {
            return 12;
        }
        return 2;
    }

    private static boolean looksLikeBinary(String line) {
        int count = 0;
        if (line.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < line.length()) {
            char this_char = line.charAt(i);
            if (Character.isISOControl(this_char) && this_char != '\t' && this_char != ' ' && this_char != '\r' && this_char != '\n' || this_char >= '\u0080') {
                ++count;
            }
            ++i;
        }
        return count * 100 / line.length() >= 30;
    }

    private static boolean isMSPcrunchLine(String line) {
        String trim_line = line.trim();
        return trim_line.length() > 0 && Character.isDigit(trim_line.charAt(0)) && trim_line.indexOf(32) != -1;
    }

    private static boolean isBlastLine(String line) {
        return line.length() > 0 && LineGroup.countChars(line, '\t') == 11;
    }

    private static boolean isGFFLine(String line) {
        int tab_count;
        return line.length() > 0 && ((tab_count = LineGroup.countChars(line.trim(), '\t')) == 7 || tab_count == 8 || tab_count == 9 || tab_count == 10);
    }

    private static int countChars(String s, char c) {
        int count = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static int getGenbankType(String line) {
        String first_word;
        int first_space;
        if (line.length() > 0 && Character.isLetter(line.charAt(0)) && ((first_space = line.indexOf(32)) == -1 ? genbank_hash.get(line) != null : genbank_hash.get(first_word = line.substring(0, first_space)) != null)) {
            return 7;
        }
        return 0;
    }

    public static String getRestOfLine(String line) {
        if (line.length() > 5) {
            return line.substring(5);
        }
        return "";
    }

    public static void writeEndOfEMBLEntry(Writer writer) throws IOException {
        writer.write("//\n");
    }

    public abstract void writeToStream(Writer var1) throws IOException;
}

