/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import uk.ac.sanger.artemis.util.StringVector;

public class Qualifier {
    private String name;
    private StringVector values;

    public Qualifier(String name, StringVector values) {
        this.initialise(name, values);
    }

    public Qualifier(String name, String value) {
        this.initialise(name, new StringVector(value));
    }

    public Qualifier(String name) {
        this.initialise(name, null);
    }

    private void initialise(String name, StringVector values) {
        this.name = name;
        if (values == null) {
            this.values = null;
        } else {
            if (values.size() == 0) {
                throw new Error("internal error - zero length values vector");
            }
            this.values = values.copy();
        }
    }

    private boolean allValuesNull() {
        if (this.values == null) {
            return true;
        }
        int i = 0;
        while (i < this.values.size()) {
            if (this.values.elementAt(i) != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean allValuesNotNull() {
        if (this.values == null) {
            return false;
        }
        int i = 0;
        while (i < this.values.size()) {
            if (this.values.elementAt(i) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public StringVector getValues() {
        if (this.values == null) {
            return null;
        }
        return this.values.copy();
    }

    public void addValues(StringVector new_values) {
        if (this.values == null) {
            this.values = new StringVector();
            this.values.add((String)null);
        }
        if (new_values == null) {
            this.values.add((String)null);
        } else {
            int i = 0;
            while (i < new_values.size()) {
                this.values.add(new_values.elementAt(i));
                ++i;
            }
        }
    }

    public void addValue(String new_value) {
        if (this.values == null) {
            this.values = new StringVector();
        }
        this.values.add(new_value);
    }

    public void removeValue(String value) {
        this.values.remove(value);
        if (this.values.size() == 0) {
            this.values = null;
        }
    }

    public Qualifier copy() {
        return new Qualifier(this.getName(), this.getValues());
    }

    public boolean equals(Object object) {
        if (object instanceof Qualifier) {
            Qualifier comp_qualifier = (Qualifier)object;
            if (comp_qualifier.getName().equals(this.getName())) {
                if (comp_qualifier.values == null && this.values == null) {
                    return true;
                }
                if (comp_qualifier.values == null || this.values == null) {
                    return false;
                }
                if (comp_qualifier.values.size() != this.values.size()) {
                    return false;
                }
                StringVector this_string_vector = this.values.copy();
                StringVector comp_string_vector = comp_qualifier.values.copy();
                this_string_vector.sort();
                comp_string_vector.sort();
                int i = 0;
                while (i < this.values.size()) {
                    String this_string = this_string_vector.elementAt(i);
                    if (this_string != null && !this_string.equals(comp_string_vector.elementAt(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

