/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.InvalidKeyException;
import uk.ac.sanger.artemis.io.InvalidQualifierException;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierInfo;
import uk.ac.sanger.artemis.io.QualifierInfoException;
import uk.ac.sanger.artemis.io.QualifierInfoHash;
import uk.ac.sanger.artemis.util.StringVector;

public class SimpleEntryInformation
implements EntryInformation {
    private QualifierInfoHash qualifier_info_hash = null;
    private KeyVector valid_keys = null;
    private KeyVector user_keys = null;
    private boolean use_embl_format = false;

    public SimpleEntryInformation() {
    }

    public SimpleEntryInformation(EntryInformation new_info) {
        if (new_info.getAllQualifierInfo() != null) {
            this.qualifier_info_hash = new_info.getAllQualifierInfo();
        }
        if (new_info.getValidKeys() != null) {
            this.valid_keys = new_info.getValidKeys();
        }
        if (new_info.getUserKeys() != null) {
            this.user_keys = new_info.getUserKeys().copy();
        }
        this.use_embl_format = new_info.useEMBLFormat();
    }

    public void addKey(Key key) {
        if (this.user_keys != null && this.user_keys.contains(key)) {
            return;
        }
        if (this.user_keys == null) {
            this.user_keys = new KeyVector();
        }
        this.user_keys.add(key);
    }

    public void addQualifierInfo(QualifierInfo qualifier_info) throws QualifierInfoException {
        KeyVector qualifier_valid_keys;
        QualifierInfo current_qualifier_info;
        if (this.qualifier_info_hash == null) {
            this.qualifier_info_hash = new QualifierInfoHash();
        }
        if ((current_qualifier_info = this.getQualifierInfo(qualifier_info.getName())) != null) {
            if (qualifier_info.getType() != 0 && current_qualifier_info.getType() != qualifier_info.getType()) {
                String message = "qualifier " + qualifier_info.getName() + " used with " + "conflicting types";
                throw new QualifierInfoException(message);
            }
            if (qualifier_info.getValidKeys() == null || qualifier_info.getRequiredKeys() == null) {
                this.qualifier_info_hash.put(qualifier_info);
            }
        } else {
            this.qualifier_info_hash.put(qualifier_info);
        }
        if ((qualifier_valid_keys = qualifier_info.getValidKeys()) != null) {
            int i = 0;
            while (i < qualifier_valid_keys.size()) {
                Key this_key = qualifier_valid_keys.elementAt(i);
                if (this.valid_keys == null || !this.valid_keys.contains(this_key)) {
                    if (this.valid_keys == null) {
                        this.valid_keys = new KeyVector();
                    }
                    this.valid_keys.add(this_key);
                }
                ++i;
            }
        }
    }

    public KeyVector getValidKeys() {
        if (this.valid_keys == null) {
            if (this.user_keys == null) {
                return null;
            }
            return this.user_keys.copy();
        }
        KeyVector return_keys = this.valid_keys.copy();
        if (this.user_keys != null) {
            int i = 0;
            while (i < this.user_keys.size()) {
                if (!return_keys.contains(this.user_keys.elementAt(i))) {
                    return_keys.add(this.user_keys.elementAt(i));
                }
                ++i;
            }
        }
        return return_keys;
    }

    public KeyVector getSortedValidKeys() {
        KeyVector return_vector = this.getValidKeys();
        if (return_vector == null) {
            return null;
        }
        return_vector.sort();
        return return_vector;
    }

    public Key getDefaultKey() {
        Key misc_feature_key = new Key("misc_feature");
        if (this.isValidKey(misc_feature_key)) {
            return misc_feature_key;
        }
        return this.getValidKeys().elementAt(0);
    }

    public StringVector getValidQualifierNames(Key key) {
        if (this.getQualifierInfoHash() == null) {
            return null;
        }
        StringVector all_names = this.getQualifierInfoHash().names();
        StringVector return_names = new StringVector();
        int i = 0;
        while (i < all_names.size()) {
            QualifierInfo this_qualifier_info = this.getQualifierInfoHash().get(all_names.elementAt(i));
            if (this_qualifier_info.isValidFor(key)) {
                return_names.add(this_qualifier_info.getName());
            }
            ++i;
        }
        if (return_names.size() == 0) {
            return null;
        }
        return_names.sort();
        return return_names;
    }

    public StringVector getRequiredQualifiers(Key key) {
        if (this.getQualifierInfoHash() == null) {
            return null;
        }
        StringVector all_names = this.getQualifierInfoHash().names();
        StringVector return_names = new StringVector();
        int i = 0;
        while (i < all_names.size()) {
            QualifierInfo this_qualifier_info = this.getQualifierInfoHash().get(all_names.elementAt(i));
            if (this_qualifier_info.isRequiredFor(key)) {
                return_names.add(this_qualifier_info.getName());
            }
            ++i;
        }
        if (return_names.size() == 0) {
            return null;
        }
        return_names.sort();
        return return_names;
    }

    public boolean isValidQualifier(String name) {
        if (this.getQualifierInfoHash() == null) {
            return true;
        }
        return this.getQualifierInfoHash().get(name) != null;
    }

    public boolean isValidQualifier(Key key, String qualifier_name) {
        if (this.getUserKeys() != null && this.getUserKeys().contains(key)) {
            return true;
        }
        if (this.getQualifierInfoHash() == null) {
            return true;
        }
        QualifierInfo qualifier_info = this.getQualifierInfoHash().get(qualifier_name);
        if (qualifier_info == null) {
            return false;
        }
        return qualifier_info.isValidFor(key);
    }

    public boolean isRequiredQualifier(Key key, String qualifier_name) {
        if (this.getUserKeys() != null && this.getUserKeys().contains(key)) {
            return false;
        }
        if (this.getQualifierInfoHash() == null) {
            return false;
        }
        QualifierInfo qualifier_info = this.getQualifierInfoHash().get(qualifier_name);
        if (qualifier_info == null) {
            return false;
        }
        return qualifier_info.isRequiredFor(key);
    }

    public boolean isValidKey(Key key) {
        if (this.valid_keys == null) {
            return true;
        }
        if (this.valid_keys.contains(key)) {
            return true;
        }
        return this.getUserKeys() != null && this.getUserKeys().contains(key);
    }

    public QualifierInfo getQualifierInfo(String qualifier_name) {
        if (this.getQualifierInfoHash() == null) {
            return null;
        }
        return this.getQualifierInfoHash().get(qualifier_name);
    }

    public static EntryInformation getDefaultEntryInformation() {
        return new SimpleEntryInformation();
    }

    public boolean useEMBLFormat() {
        return this.use_embl_format;
    }

    public void setEMBLFormat(boolean use_embl_format) {
        this.use_embl_format = use_embl_format;
    }

    public QualifierInfoHash getAllQualifierInfo() {
        if (this.getQualifierInfoHash() == null) {
            return null;
        }
        return this.getQualifierInfoHash().copy();
    }

    public void fixException(EntryInformationException exception) {
        if (exception instanceof InvalidKeyException) {
            InvalidKeyException key_exception = (InvalidKeyException)exception;
            this.addKey(key_exception.getKey());
        }
        if (exception instanceof InvalidRelationException) {
            InvalidRelationException relation_exception = (InvalidRelationException)exception;
            if (relation_exception.getQualifier() == null) {
                Key key_to_add = relation_exception.getKey();
                this.addKey(key_to_add);
            } else {
                Qualifier qualifier = relation_exception.getQualifier();
                QualifierInfo qualifier_info = this.getQualifierInfo(qualifier.getName());
                QualifierInfo new_qualifier_info = qualifier_info == null ? new QualifierInfo(qualifier.getName(), 1, null, null, false) : new QualifierInfo(qualifier_info.getName(), qualifier_info.getType(), null, null, false);
                try {
                    this.addQualifierInfo(new_qualifier_info);
                }
                catch (QualifierInfoException e) {
                    throw new Error("internal error - unexpected exception: " + e);
                }
            }
        }
        if (exception instanceof InvalidQualifierException) {
            String exception_qualifier_name = ((InvalidQualifierException)exception).getQualifier().getName();
            QualifierInfo new_info = new QualifierInfo(exception_qualifier_name, 0, null, null, false);
            try {
                this.addQualifierInfo(new_info);
            }
            catch (QualifierInfoException e) {
                throw new Error("internal error - unexpected exception: " + e);
            }
        }
    }

    public KeyVector getUserKeys() {
        return this.user_keys;
    }

    private QualifierInfoHash getQualifierInfoHash() {
        return this.qualifier_info_hash;
    }

    private KeyVector getKeys() {
        return this.valid_keys;
    }
}

