/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.sequence;

import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.StringVector;

public class AminoAcidSequence {
    public static final char[] codon_translation_array = new char[]{'f', 'f', 'l', 'l', 's', 's', 's', 's', 'y', 'y', '#', '+', 'c', 'c', '*', 'w', 'l', 'l', 'l', 'l', 'p', 'p', 'p', 'p', 'h', 'h', 'q', 'q', 'r', 'r', 'r', 'r', 'i', 'i', 'i', 'm', 't', 't', 't', 't', 'n', 'n', 'k', 'k', 's', 's', 'r', 'r', 'v', 'v', 'v', 'v', 'a', 'a', 'a', 'a', 'd', 'd', 'e', 'e', 'g', 'g', 'g', 'g'};
    public static final int POLAR_UNCHARGED_AA = 0;
    public static final int POSITIVELY_CHARGED_AA = 1;
    public static final int NEGATIVELY_CHARGED_AA = 2;
    public static final int HYDROPHOBIC_AA = 3;
    public static final int SPECIAL_AA = 4;
    public static final int STOP_AA = 5;
    public static final int UNKNOWN_AA = 6;
    public static final int ILLEGAL_AA = 7;
    private String amino_acid_string = null;
    private static final String[] amino_acid_abbreviated_names = new String[]{"Ala", "Arg", "Asn", "Asp", "Cys", "Gln", "Glu", "Gly", "His", "Ile", "Leu", "Lys", "Met", "Phe", "Pro", "Ser", "Thr", "Trp", "Tyr", "Val", "Opl", "Ocr", "Amb", "---", "Sel"};
    private static final char[] amino_acid_one_letter_names = new char[]{'a', 'r', 'n', 'd', 'c', 'q', 'e', 'g', 'h', 'i', 'l', 'k', 'm', 'f', 'p', 's', 't', 'w', 'y', 'v', '*', '#', '+', '.', 'u'};
    private static final float[] molecular_weights = new float[]{89.09f, 174.21f, 132.12f, 133.1f, 121.15f, 146.15f, 147.13f, 75.07f, 155.16f, 131.18f, 131.18f, 146.19f, 149.22f, 165.19f, 115.13f, 105.09f, 119.12f, 204.22f, 181.19f, 117.15f, 0.0f, 0.0f, 0.0f, 0.0f, 334.1f};
    private static final float average_molecular_weight = 136.9f;
    private static final float molecular_weight_of_water = 18.015f;
    public static final int symbol_count = amino_acid_abbreviated_names.length;
    public static final int amino_acid_symbol_count = 20;

    static {
        StringVector options_file_table = Options.getOptions().getOptionValues("translation_table");
        if (options_file_table != null && options_file_table.size() == 64) {
            int i = 0;
            while (i < 64) {
                int new_table_char = options_file_table.elementAt(i).charAt(0);
                AminoAcidSequence.codon_translation_array[i] = AminoAcidSequence.isLegalCodon((char)new_table_char) ? new_table_char : 46;
                ++i;
            }
        }
    }

    public AminoAcidSequence(String amino_acid_string) {
        this.amino_acid_string = amino_acid_string.toLowerCase();
    }

    public static AminoAcidSequence getTranslation(String bases, boolean unknown_is_x) {
        StringBuffer aa_buffer = new StringBuffer();
        int number_of_codons = bases.length() / 3;
        int i = 0;
        while (i < number_of_codons * 3) {
            char aa = AminoAcidSequence.getCodonTranslation(bases.charAt(i), bases.charAt(i + 1), bases.charAt(i + 2));
            if (aa == '.' && unknown_is_x) {
                aa_buffer.append('x');
            } else {
                aa_buffer.append(aa);
            }
            i += 3;
        }
        return new AminoAcidSequence(aa_buffer.toString());
    }

    public static char getCodonTranslation(String codon_string) {
        if (codon_string.length() < 3) {
            return '.';
        }
        return AminoAcidSequence.getCodonTranslation(codon_string.charAt(0), codon_string.charAt(1), codon_string.charAt(2));
    }

    public static char getCodonTranslation(char first_letter, char second_letter, char third_letter) {
        int first_index = Bases.getIndexOfBase(first_letter);
        if (first_index >= 4) {
            return '.';
        }
        int second_index = Bases.getIndexOfBase(second_letter);
        if (second_index >= 4) {
            return '.';
        }
        int third_index = Bases.getIndexOfBase(third_letter);
        if (third_index >= 4) {
            return '.';
        }
        int codon_index = first_index * 16 + second_index * 4 + third_index;
        return codon_translation_array[codon_index];
    }

    public int length() {
        return this.amino_acid_string.length();
    }

    public char elementAt(int index) {
        return this.amino_acid_string.charAt(index);
    }

    public float getMolecularWeight() {
        float return_weight = 0.0f;
        int i = 0;
        while (i < this.amino_acid_string.length()) {
            char this_char = this.amino_acid_string.charAt(i);
            return_weight += molecular_weights[AminoAcidSequence.getSymbolIndex(this_char)];
            ++i;
        }
        if (this.amino_acid_string.length() > 1) {
            return return_weight - 18.015f * (float)(this.amino_acid_string.length() - 1);
        }
        return return_weight;
    }

    public String toString() {
        return this.amino_acid_string;
    }

    public boolean checkForMatch(AminoAcidSequence subject_sequence) {
        String subject_sequence_string = subject_sequence.toString();
        int subject_index = 0;
        while (subject_index < subject_sequence_string.length() - this.toString().length() + 1) {
            int query_index = 0;
            while (query_index < this.toString().length()) {
                char this_query_char = this.toString().charAt(query_index);
                char this_subject_char = subject_sequence_string.charAt(subject_index + query_index);
                if (!AminoAcidSequence.aminoAcidMatches(this_subject_char, this_query_char)) break;
                ++query_index;
            }
            if (query_index == this.toString().length()) {
                return true;
            }
            ++subject_index;
        }
        return false;
    }

    private static boolean aminoAcidMatches(char aa_char1, char aa_char2) {
        if (aa_char1 == aa_char2) {
            return true;
        }
        return aa_char1 == 'x' || aa_char2 == 'x';
    }

    public MarkerRange findMatch(Bases bases, Marker search_start_marker, boolean search_backwards) {
        Strand match_strand;
        int match_last_base;
        int match_first_base;
        int complement_search_start_index;
        int forward_search_start_index;
        String bases_string = bases.toString();
        if (search_backwards) {
            if (search_start_marker == null) {
                forward_search_start_index = bases.getLength() - 1;
                complement_search_start_index = bases.getLength() - 1;
            } else {
                complement_search_start_index = search_start_marker.getRawPosition() - 2;
                forward_search_start_index = search_start_marker.getStrand().isForwardStrand() ? search_start_marker.getRawPosition() - 2 : search_start_marker.getRawPosition() - 1;
            }
        } else if (search_start_marker == null) {
            forward_search_start_index = 0;
            complement_search_start_index = 0;
        } else {
            forward_search_start_index = search_start_marker.getRawPosition();
            complement_search_start_index = search_start_marker.getStrand().isForwardStrand() ? search_start_marker.getRawPosition() - 1 : search_start_marker.getRawPosition();
        }
        int forward_search_result = this.searchFor(bases_string, forward_search_start_index, search_backwards);
        int complement_search_result = this.reverseComplementSearchFor(bases_string, complement_search_start_index, search_backwards);
        if (forward_search_result == -1 && complement_search_result == -1) {
            return null;
        }
        if (search_backwards) {
            if (complement_search_result != -1 && (forward_search_result == -1 || complement_search_result >= forward_search_result)) {
                match_first_base = bases.getComplementPosition(complement_search_result + 1);
                match_last_base = match_first_base - (this.length() * 3 - 1);
                match_strand = bases.getReverseStrand();
            } else {
                match_first_base = forward_search_result + 1;
                match_last_base = match_first_base + this.length() * 3 - 1;
                match_strand = bases.getForwardStrand();
            }
        } else if (forward_search_result != -1 && (complement_search_result == -1 || forward_search_result <= complement_search_result)) {
            match_first_base = forward_search_result + 1;
            match_last_base = match_first_base + this.length() * 3 - 1;
            match_strand = bases.getForwardStrand();
        } else {
            match_first_base = bases.getComplementPosition(complement_search_result + 1);
            match_last_base = match_first_base - (this.length() * 3 - 1);
            match_strand = bases.getReverseStrand();
        }
        try {
            return new MarkerRange(match_strand, match_first_base, match_last_base);
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
    }

    public int searchFor(String bases_string, int start_index, boolean search_backwards) {
        if (search_backwards) {
            return this.searchBackwardFor(bases_string, start_index);
        }
        return this.searchForwardFor(bases_string, start_index);
    }

    public int searchForwardFor(String bases_string, int start_index) {
        int pattern_base_length = this.length() * 3;
        int base_index = start_index;
        while (base_index <= bases_string.length() - pattern_base_length) {
            boolean matched = true;
            int offset = 0;
            while (offset < this.length()) {
                char base3;
                char base2;
                char base1;
                char search_aa = this.amino_acid_string.charAt(offset);
                if (search_aa != 'x' && AminoAcidSequence.getCodonTranslation(base1 = bases_string.charAt(base_index + offset * 3 + 0), base2 = bases_string.charAt(base_index + offset * 3 + 1), base3 = bases_string.charAt(base_index + offset * 3 + 2)) != search_aa) {
                    matched = false;
                    break;
                }
                ++offset;
            }
            if (matched) {
                return base_index;
            }
            ++base_index;
        }
        return -1;
    }

    public int searchBackwardFor(String bases_string, int start_index) {
        if (bases_string.length() - start_index < this.length() * 3) {
            start_index = bases_string.length() - this.length() * 3;
        }
        int base_index = start_index;
        while (base_index >= 0) {
            boolean matched = true;
            int offset = 0;
            while (offset < this.length()) {
                char base3;
                char base2;
                char base1;
                char search_aa = this.amino_acid_string.charAt(offset);
                if (search_aa != 'x' && AminoAcidSequence.getCodonTranslation(base1 = bases_string.charAt(base_index + offset * 3 + 0), base2 = bases_string.charAt(base_index + offset * 3 + 1), base3 = bases_string.charAt(base_index + offset * 3 + 2)) != search_aa) {
                    matched = false;
                    break;
                }
                ++offset;
            }
            if (matched) {
                return base_index;
            }
            --base_index;
        }
        return -1;
    }

    public int reverseComplementSearchFor(String bases_string, int start_index, boolean search_backwards) {
        if (search_backwards) {
            return this.reverseComplementSearchBackwardFor(bases_string, start_index);
        }
        return this.reverseComplementSearchForwardFor(bases_string, start_index);
    }

    public int reverseComplementSearchForwardFor(String bases_string, int start_index) {
        int pattern_base_length = this.length() * 3;
        int base_index = start_index;
        while (base_index <= bases_string.length() - pattern_base_length) {
            boolean matched = true;
            int offset = 0;
            while (offset < this.length()) {
                char base1 = Bases.complement(bases_string.charAt(base_index + offset * 3 + 0));
                char base2 = Bases.complement(bases_string.charAt(base_index + offset * 3 + 1));
                char base3 = Bases.complement(bases_string.charAt(base_index + offset * 3 + 2));
                char amino_acid_char = this.amino_acid_string.charAt(this.amino_acid_string.length() - offset - 1);
                if (amino_acid_char != 'x' && AminoAcidSequence.getCodonTranslation(base3, base2, base1) != amino_acid_char) {
                    matched = false;
                    break;
                }
                ++offset;
            }
            if (matched) {
                return base_index;
            }
            ++base_index;
        }
        return -1;
    }

    public int reverseComplementSearchBackwardFor(String bases_string, int start_index) {
        if (bases_string.length() - start_index < this.length() * 3) {
            start_index = bases_string.length() - this.length() * 3;
        }
        int base_index = start_index;
        while (base_index >= 0) {
            boolean matched = true;
            int offset = 0;
            while (offset < this.length()) {
                char base1 = Bases.complement(bases_string.charAt(base_index + offset * 3 + 0));
                char base2 = Bases.complement(bases_string.charAt(base_index + offset * 3 + 1));
                char base3 = Bases.complement(bases_string.charAt(base_index + offset * 3 + 2));
                char amino_acid_char = this.amino_acid_string.charAt(this.amino_acid_string.length() - offset - 1);
                if (amino_acid_char != 'x' && AminoAcidSequence.getCodonTranslation(base3, base2, base1) != amino_acid_char) {
                    matched = false;
                    break;
                }
                ++offset;
            }
            if (matched) {
                return base_index;
            }
            --base_index;
        }
        return -1;
    }

    public boolean containsStopCodon() {
        int i = 0;
        while (i < this.amino_acid_string.length()) {
            char this_char = this.amino_acid_string.charAt(i);
            if (AminoAcidSequence.isStopCodon(this_char)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isStopCodon(char amino_acid_char) {
        return amino_acid_char == '#' || amino_acid_char == '*' || amino_acid_char == '+';
    }

    public static boolean isLegalCodon(char one_letter_code) {
        switch (one_letter_code) {
            case '#': 
            case '*': 
            case '+': 
            case 'a': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'v': 
            case 'w': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    public static int getAminoAcidType(char aa_char) {
        switch (aa_char) {
            case 'N': 
            case 'Q': 
            case 'S': 
            case 'T': {
                return 0;
            }
            case 'H': 
            case 'K': 
            case 'R': {
                return 1;
            }
            case 'D': 
            case 'E': {
                return 2;
            }
            case 'A': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'M': 
            case 'V': 
            case 'W': 
            case 'Y': {
                return 3;
            }
            case 'C': 
            case 'G': 
            case 'P': {
                return 4;
            }
            case '#': 
            case '*': 
            case '+': {
                return 5;
            }
        }
        return 7;
    }

    public static char getOneLetterCode(String three_letter_code) {
        String real_code = String.valueOf(three_letter_code.substring(0, 1).toUpperCase()) + three_letter_code.substring(1).toLowerCase();
        int i = 0;
        while (i < amino_acid_one_letter_names.length) {
            if (real_code.equals(amino_acid_abbreviated_names[i])) {
                return amino_acid_one_letter_names[i];
            }
            ++i;
        }
        return '\uffff';
    }

    public static String getThreeLetterAbbreviation(char one_letter_code) {
        int i = 0;
        while (i < amino_acid_one_letter_names.length) {
            if (one_letter_code == amino_acid_one_letter_names[i]) {
                return amino_acid_abbreviated_names[i];
            }
            ++i;
        }
        throw new Error("internal error - illegal one letter amino acid code");
    }

    public static String getThreeLetterAbbreviation(int index) {
        return amino_acid_abbreviated_names[index];
    }

    public static int getSymbolIndex(char one_letter_code) {
        switch (one_letter_code) {
            case 'a': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 'n': {
                return 2;
            }
            case 'd': {
                return 3;
            }
            case 'c': {
                return 4;
            }
            case 'q': {
                return 5;
            }
            case 'e': {
                return 6;
            }
            case 'g': {
                return 7;
            }
            case 'h': {
                return 8;
            }
            case 'i': {
                return 9;
            }
            case 'l': {
                return 10;
            }
            case 'k': {
                return 11;
            }
            case 'm': {
                return 12;
            }
            case 'f': {
                return 13;
            }
            case 'p': {
                return 14;
            }
            case 's': {
                return 15;
            }
            case 't': {
                return 16;
            }
            case 'w': {
                return 17;
            }
            case 'y': {
                return 18;
            }
            case 'v': {
                return 19;
            }
            case '*': {
                return 20;
            }
            case '#': {
                return 21;
            }
            case '+': {
                return 22;
            }
            case '.': {
                return 23;
            }
            case 'x': {
                return 23;
            }
            case 'u': {
                return 24;
            }
        }
        throw new Error("Internal error - illegal one letter codon symbol: " + one_letter_code);
    }

    public static char getSymbolFromIndex(int index) {
        return amino_acid_one_letter_names[index];
    }
}

