/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class NewTextEditorAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;

    public NewTextEditorAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        File file = this.queryFile();
        IEditorInput input = this.createEditorInput(file);
        String editorId = this.getEditorId(file);
        IWorkbenchPage page = this.fWindow.getActivePage();
        try {
            page.openEditor(input, editorId);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private File queryFile() {
        IPath stateLocation = EditorsPlugin.getDefault().getStateLocation();
        IPath path = stateLocation.append("/_" + new Object().hashCode());
        return new File(path.toOSString());
    }

    private String getEditorId(File file) {
        IWorkbench workbench = this.fWindow.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    private IEditorInput createEditorInput(File file) {
        return new NonExistingFileEditorInput(file, TextEditorMessages.getString("NewTextEditorAction.namePrefix"));
    }
}

