/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.JavaFileEditorInput;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.part.FileEditorInput;

public class OpenExternalFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private String fFilterPath;

    public OpenExternalFileAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        this.fWindow = null;
        this.fFilterPath = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fFilterPath = System.getProperty("user.home");
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.fWindow.getShell(), 4098);
        dialog.setText(TextEditorMessages.getString("OpenExternalFileAction.title"));
        dialog.setFilterPath(this.fFilterPath);
        dialog.open();
        String[] names = dialog.getFileNames();
        if (names != null) {
            this.fFilterPath = dialog.getFilterPath();
            int numberOfFilesNotFound = 0;
            StringBuffer notFound = new StringBuffer();
            int i = 0;
            while (i < names.length) {
                File file = new File(String.valueOf(this.fFilterPath) + File.separator + names[i]);
                if (file.exists()) {
                    IEditorInput input = this.createEditorInput(file);
                    String editorId = this.getEditorId(file);
                    IWorkbenchPage page = this.fWindow.getActivePage();
                    try {
                        page.openEditor(input, editorId);
                    }
                    catch (PartInitException e) {
                        EditorsPlugin.log(e.getStatus());
                    }
                } else {
                    if (++numberOfFilesNotFound > 1) {
                        notFound.append('\n');
                    }
                    notFound.append(file.getName());
                }
                ++i;
            }
            if (numberOfFilesNotFound > 0) {
                String msgFmt = numberOfFilesNotFound == 1 ? TextEditorMessages.getString("OpenExternalFileAction.message.fileNotFound") : TextEditorMessages.getString("OpenExternalFileAction.message.filesNotFound");
                String msg = MessageFormat.format(msgFmt, notFound.toString());
                MessageDialog.openError((Shell)this.fWindow.getShell(), (String)TextEditorMessages.getString("OpenExternalFileAction.title"), (String)msg);
            }
        }
    }

    private String getEditorId(File file) {
        IWorkbench workbench = this.fWindow.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    private IEditorInput createEditorInput(File file) {
        IFile workspaceFile = this.getWorkspaceFile(file);
        if (workspaceFile != null) {
            return new FileEditorInput(workspaceFile);
        }
        return new JavaFileEditorInput(file);
    }

    private IFile getWorkspaceFile(File file) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        IFile[] files = workspace.getRoot().findFilesForLocation(location);
        if ((files = this.filterNonExistentFiles(files)) == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        return this.selectWorkspaceFile(files);
    }

    private IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    private IFile selectWorkspaceFile(IFile[] files) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.fWindow.getShell(), (ILabelProvider)new FileLabelProvider());
        dialog.setElements((Object[])files);
        dialog.setTitle(TextEditorMessages.getString("OpenExternalFileAction.title.selectWorkspaceFile"));
        dialog.setMessage(TextEditorMessages.getString("OpenExternalFileAction.message.fileLinkedToMultiple"));
        if (dialog.open() == 0) {
            return (IFile)dialog.getFirstResult();
        }
        return null;
    }

    static class FileLabelProvider
    extends LabelProvider {
        FileLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                IPath path = ((IFile)element).getFullPath();
                return path != null ? path.toString() : "";
            }
            return super.getText(element);
        }
    }
}

