/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.osgi.framework.Bundle;

public class SelectMarkerRulerAction
extends ResourceAction
implements IUpdate {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private List fMarkers;
    private ResourceBundle fBundle;
    private String fPrefix;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public SelectMarkerRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix);
        this.fRuler = ruler;
        this.fTextEditor = editor;
        this.fBundle = bundle;
        this.fPrefix = prefix;
    }

    public SelectMarkerRulerAction(ResourceBundle bundle, String prefix, IVerticalRuler ruler, ITextEditor editor) {
        this(bundle, prefix, editor, (IVerticalRulerInfo)ruler);
    }

    public void update() {
        this.fMarkers = this.getMarkers();
        this.setEnabled(!this.fMarkers.isEmpty());
    }

    public void run() {
        IWorkbenchPage page;
        IViewPart view;
        IMarker marker = this.chooseMarker(this.fMarkers);
        if (marker == null) {
            return;
        }
        boolean isProblemMarker = MarkerUtilities.isMarkerType(marker, "org.eclipse.core.resources.problemmarker");
        boolean isTaskMarker = MarkerUtilities.isMarkerType(marker, "org.eclipse.core.resources.taskmarker");
        if ((isProblemMarker || isTaskMarker) && (view = (page = this.fTextEditor.getSite().getPage()).findView(isProblemMarker ? "org.eclipse.ui.views.ProblemView" : "org.eclipse.ui.views.TaskList")) != null) {
            boolean selectionSet = false;
            try {
                Class<?> clazz = view.getClass();
                Class[] classArray = new Class[2];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.jface.viewers.IStructuredSelection");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                classArray[1] = Boolean.TYPE;
                Method method = clazz.getMethod("setSelection", classArray);
                method.invoke((Object)view, new StructuredSelection((Object)marker), Boolean.TRUE);
                selectionSet = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                selectionSet = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                selectionSet = false;
            }
            catch (InvocationTargetException invocationTargetException) {
                selectionSet = false;
            }
            if (selectionSet) {
                return;
            }
        }
        int offset = MarkerUtilities.getCharStart(marker);
        int endOffset = MarkerUtilities.getCharEnd(marker);
        if (offset > -1 && endOffset > -1) {
            this.fTextEditor.selectAndReveal(offset, endOffset - offset);
        }
    }

    protected IMarker chooseMarker(List markers) {
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        IAnnotationAccessExtension access = this.getAnnotationAccessExtension();
        IMarker marker = null;
        int maxLayer = 0;
        Iterator iter = markers.iterator();
        while (iter.hasNext()) {
            IMarker m = (IMarker)iter.next();
            MarkerAnnotation a = model.getMarkerAnnotation(m);
            if (a == null) continue;
            if (access == null) {
                marker = m;
                break;
            }
            int l = access.getLayer((Annotation)a);
            if (l == maxLayer) {
                if (marker != null) continue;
                marker = m;
                continue;
            }
            if (l <= maxLayer) continue;
            maxLayer = l;
            marker = m;
        }
        return marker;
    }

    protected IAnnotationAccessExtension getAnnotationAccessExtension() {
        Object adapter;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jface.text.source.IAnnotationAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = this.fTextEditor.getAdapter((Class)clazz)) instanceof IAnnotationAccessExtension) {
            return (IAnnotationAccessExtension)adapter;
        }
        return null;
    }

    protected IResource getResource() {
        IResource resource;
        IEditorInput input = this.fTextEditor.getEditorInput();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$4;
            if (clazz2 == null) {
                try {
                    clazz2 = class$4 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)input.getAdapter((Class)clazz2);
        }
        return resource;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected void handleCoreException(CoreException exception, String message) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = Platform.getLog((Bundle)bundle);
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
        Shell shell = this.fTextEditor.getSite().getShell();
        String title = ResourceAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.title"), (String)(String.valueOf(this.fPrefix) + "error.dialog.title"));
        String msg = ResourceAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.message"), (String)(String.valueOf(this.fPrefix) + "error.dialog.message"));
        ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)exception.getStatus());
    }

    protected List getMarkers() {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (resource != null && model != null && resource.exists()) {
            try {
                IMarker[] allMarkers = resource.findMarkers(null, true, 0);
                if (allMarkers != null) {
                    int i = 0;
                    while (i < allMarkers.length) {
                        if (this.includesRulerLine(model.getMarkerPosition(allMarkers[i]), document)) {
                            markers.add(allMarkers[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException x) {
                this.handleCoreException(x, TextEditorMessages.getString("SelectMarkerRulerAction.getMarker"));
            }
        }
        return markers;
    }
}

