/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.PackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionRange;

class StateReader {
    protected List objectTable = new ArrayList();
    public static final byte STATE_CACHE_VERSION = 7;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    public static final byte INDEX = 2;

    StateReader() {
    }

    private int addToObjectTable(Object object) {
        this.objectTable.add(object);
        return this.objectTable.size() - 1;
    }

    private boolean readState(StateImpl state, DataInputStream in, long expectedTimestamp) throws IOException {
        if (in.readByte() != 7) {
            return false;
        }
        byte tag = this.readTag(in);
        if (tag != 1) {
            return false;
        }
        long timestampRead = in.readLong();
        if (expectedTimestamp >= 0L && timestampRead != expectedTimestamp) {
            return false;
        }
        this.addToObjectTable(state);
        int length = in.readInt();
        if (length == 0) {
            return true;
        }
        int i = 0;
        while (i < length) {
            state.basicAddBundle(this.readBundleDescription(in));
            ++i;
        }
        state.setTimeStamp(timestampRead);
        state.setResolved(in.readBoolean());
        if (!state.isResolved()) {
            return true;
        }
        int resolvedLength = in.readInt();
        int i2 = 0;
        while (i2 < resolvedLength) {
            state.addResolvedBundle(this.readBundleDescription(in));
            ++i2;
        }
        return true;
    }

    private BundleDescriptionImpl readBundleDescription(DataInputStream in) throws IOException {
        int requiredBundleCount;
        int providedPackageCount;
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        if (tag == 2) {
            return (BundleDescriptionImpl)this.objectTable.get(in.readInt());
        }
        BundleDescriptionImpl result = new BundleDescriptionImpl();
        this.addToObjectTable(result);
        result.setBundleId(in.readLong());
        result.setSymbolicName(this.readString(in, false));
        result.setLocation(this.readString(in, false));
        result.setState(in.readInt());
        result.setVersion(this.readVersion(in));
        result.setHost(this.readHostSpec(in));
        int packageCount = in.readInt();
        if (packageCount > 0) {
            PackageSpecification[] packages = new PackageSpecification[packageCount];
            int i = 0;
            while (i < packages.length) {
                packages[i] = this.readPackageSpec(in);
                ++i;
            }
            result.setPackages(packages);
        }
        if ((providedPackageCount = in.readInt()) > 0) {
            String[] providedPackages = new String[providedPackageCount];
            int i = 0;
            while (i < providedPackages.length) {
                providedPackages[i] = in.readUTF();
                ++i;
            }
            result.setProvidedPackages(providedPackages);
        }
        if ((requiredBundleCount = in.readInt()) > 0) {
            BundleSpecification[] requiredBundles = new BundleSpecification[requiredBundleCount];
            int i = 0;
            while (i < requiredBundles.length) {
                requiredBundles[i] = this.readBundleSpec(in);
                ++i;
            }
            result.setRequiredBundles(requiredBundles);
        }
        result.setSingleton(in.readBoolean());
        return result;
    }

    private BundleSpecificationImpl readBundleSpec(DataInputStream in) throws IOException {
        BundleSpecificationImpl result = new BundleSpecificationImpl();
        this.readVersionConstraint(result, in);
        result.setExported(in.readBoolean());
        result.setOptional(in.readBoolean());
        return result;
    }

    private PackageSpecificationImpl readPackageSpec(DataInputStream in) throws IOException {
        PackageSpecificationImpl result = new PackageSpecificationImpl();
        this.readVersionConstraint(result, in);
        result.setExport(in.readBoolean());
        return result;
    }

    private HostSpecificationImpl readHostSpec(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        HostSpecificationImpl result = new HostSpecificationImpl();
        this.readVersionConstraint(result, in);
        result.setReloadHost(in.readBoolean());
        return result;
    }

    private void readVersionConstraint(VersionConstraintImpl version, DataInputStream in) throws IOException {
        version.setName(this.readString(in, false));
        version.setVersionRange(this.readVersionRange(in));
        version.setActualVersion(this.readVersion(in));
        version.setSupplier(this.readBundleDescription(in));
    }

    private Version readVersion(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        if (tag == 2) {
            return (Version)this.objectTable.get(in.readInt());
        }
        int majorComponent = in.readInt();
        int minorComponent = in.readInt();
        int serviceComponent = in.readInt();
        String qualifierComponent = this.readString(in, false);
        boolean inclusive = in.readBoolean();
        Version result = new Version(majorComponent, minorComponent, serviceComponent, qualifierComponent, inclusive);
        this.addToObjectTable(result);
        return result;
    }

    private VersionRange readVersionRange(DataInputStream in) throws IOException {
        return new VersionRange(this.readVersion(in), this.readVersion(in));
    }

    public final boolean loadState(StateImpl state, DataInputStream input, long expectedTimestamp) throws IOException {
        boolean bl;
        try {
            bl = this.readState(state, input, expectedTimestamp);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            input.close();
            throw throwable;
        }
        input.close();
        return bl;
    }

    private String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (intern) {
            return in.readUTF().intern();
        }
        return in.readUTF();
    }

    private byte readTag(DataInputStream in) throws IOException {
        return in.readByte();
    }
}

