/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.GenericListItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class GenericListViewer
extends ContentViewer {
    private Collection items = new HashSet();
    private Composite control;

    public GenericListViewer(Composite parent, int style) {
        this.control = new Composite(parent, style);
        this.control.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 1;
        this.control.setLayout((Layout)layout);
        this.control.setBackground(parent.getDisplay().getSystemColor(9));
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.refresh();
    }

    public Control getControl() {
        return this.getComposite();
    }

    public Composite getComposite() {
        return this.control;
    }

    public abstract GenericListItem createListItem(Object var1, Color var2, GenericListViewer var3);

    public void createContents() {
        if (this.getContentProvider() == null) {
            return;
        }
        if (this.getInput() == null) {
            return;
        }
        this.getControl().setRedraw(false);
        Iterator itemsIterator = this.items.iterator();
        while (itemsIterator.hasNext()) {
            ((GenericListItem)itemsIterator.next()).dispose();
        }
        this.items = new HashSet();
        Object[] elements = ((IStructuredContentProvider)this.getContentProvider()).getElements(this.getInput());
        ((GridLayout)this.control.getLayout()).numColumns = elements.length;
        this.createItems(elements, null, 0);
        this.getControl().setRedraw(true);
    }

    private void createItems(Object[] elements, GenericListItem parent, int indent) {
        int i = 0;
        while (i < elements.length) {
            Color color = this.getControl().getDisplay().getSystemColor(25);
            final GenericListItem newItem = this.createListItem(elements[i], color, this);
            GridData layoutData = new GridData(768);
            layoutData.horizontalIndent = indent * 20;
            newItem.getControl().setLayoutData((Object)layoutData);
            newItem.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    GenericListViewer.this.itemSelected(newItem);
                }
            });
            this.items.add(newItem);
            ++i;
        }
    }

    protected abstract void itemSelected(GenericListItem var1);

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void refresh() {
        if (this.items.isEmpty()) {
            this.createContents();
        }
    }
}

