/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.registry.NewWizardsRegistryReader;
import org.eclipse.ui.internal.registry.experimental.IConfigurationElementRemovalHandler;

public class BaseNewWizardMenu
extends CompoundContributionItem {
    private final Map actions = new HashMap(21);
    private final IConfigurationElementRemovalHandler configListener = new IConfigurationElementRemovalHandler(){

        public void removeInstance(IConfigurationElement source, Object object) {
            if (object instanceof NewWizardShortcutAction) {
                BaseNewWizardMenu.this.actions.values().remove(object);
            }
        }
    };
    private NewWizardsRegistryReader reader = new NewWizardsRegistryReader();
    private final IRegistryChangeListener registryListener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent event) {
            if (BaseNewWizardMenu.this.getParent() != null) {
                BaseNewWizardMenu.this.getParent().markDirty();
            }
            BaseNewWizardMenu.this.reader = new NewWizardsRegistryReader();
        }
    };
    private final IAction showDlgAction;
    private IWorkbenchWindow workbenchWindow;

    public BaseNewWizardMenu(IWorkbenchWindow window, String id) {
        super(id);
        Assert.isNotNull((Object)window);
        this.workbenchWindow = window;
        this.showDlgAction = ActionFactory.NEW.create(window);
        this.registerListeners();
        ((WorkbenchWindow)window).addSubmenu(4);
    }

    protected void addItems(List list) {
        this.addShortcuts(list);
        list.add(new Separator());
        list.add(new ActionContributionItem(this.getShowDialogAction()));
    }

    protected void addShortcuts(List list) {
        IWorkbenchPage page = this.workbenchWindow.getActivePage();
        if (page != null) {
            String[] wizardIds = page.getNewWizardShortcuts();
            int i = 0;
            while (i < wizardIds.length) {
                IAction action = this.getAction(wizardIds[i]);
                if (action != null && !WorkbenchActivityHelper.filterItem(action)) {
                    list.add(new ActionContributionItem(action));
                }
                ++i;
            }
        }
    }

    public void dispose() {
        if (this.workbenchWindow != null) {
            super.dispose();
            this.unregisterListeners();
            this.workbenchWindow = null;
        }
    }

    private IAction getAction(String id) {
        WorkbenchWizardElement element;
        Object action = (IAction)this.actions.get(id);
        if (action == null && (element = this.reader.findWizard(id)) != null) {
            action = new NewWizardShortcutAction(this.workbenchWindow, element);
            this.actions.put(id, action);
            ((WorkbenchWindow)this.workbenchWindow).getConfigurationElementTracker().registerObject(element.getConfigurationElement(), action);
        }
        return action;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<ActionContributionItem> list = new ArrayList<ActionContributionItem>();
        if (this.workbenchWindow != null && this.workbenchWindow.getActivePage() != null && this.workbenchWindow.getActivePage().getPerspective() != null) {
            this.addItems(list);
        } else {
            String text = WorkbenchMessages.getString("Workbench.noApplicableItems");
            Action dummyAction = new Action(text){};
            dummyAction.setEnabled(false);
            list.add(new ActionContributionItem((IAction)dummyAction));
        }
        return list.toArray(new IContributionItem[list.size()]);
    }

    protected IAction getShowDialogAction() {
        return this.showDlgAction;
    }

    protected IWorkbenchWindow getWindow() {
        return this.workbenchWindow;
    }

    private void registerListeners() {
        Platform.getExtensionRegistry().addRegistryChangeListener(this.registryListener);
        ((WorkbenchWindow)this.workbenchWindow).getConfigurationElementTracker().registerRemovalHandler(this.configListener);
    }

    protected boolean registryHasCategory(String categoryId) {
        return this.reader.getWizardElements().findCategory(categoryId) != null;
    }

    private void unregisterListeners() {
        Platform.getExtensionRegistry().removeRegistryChangeListener(this.registryListener);
        ((WorkbenchWindow)this.workbenchWindow).getConfigurationElementTracker().unregisterRemovalHandler(this.configListener);
    }
}

