/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.DetachedWindow;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.internal.dnd.SwtUtil;
import org.eclipse.ui.presentations.IPresentablePart;

public abstract class LayoutPart
implements ISizeProvider {
    protected ILayoutContainer container;
    protected String id;
    private ListenerList propertyListeners = new ListenerList(1);
    public static final String PROP_VISIBILITY = "PROP_VISIBILITY";

    public LayoutPart(String id) {
        this.id = id;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyListeners.remove((Object)listener);
    }

    public abstract void createControl(Composite var1);

    public void dispose() {
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, 0, 0);
    }

    public ILayoutContainer getContainer() {
        return this.container;
    }

    public abstract Control getControl();

    public String getID() {
        return this.id;
    }

    public String getCompoundId() {
        return this.getID();
    }

    public boolean isCompressible() {
        return false;
    }

    private IPreferenceStore getPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    boolean getShellActivated() {
        Window window = this.getWindow();
        if (window instanceof WorkbenchWindow) {
            return ((WorkbenchWindow)window).getShellActivated();
        }
        return false;
    }

    public Point getSize() {
        Rectangle r = this.getBounds();
        Point ptSize = new Point(r.width, r.height);
        return ptSize;
    }

    public int getSizeFlags(boolean horizontal) {
        return 128;
    }

    public int computePreferredSize(boolean width, int availableParallel, int availablePerpendicular, int preferredParallel) {
        return preferredParallel;
    }

    public IDropTarget getDropTarget(Object draggedObject, Point displayCoordinates) {
        return null;
    }

    public Window getWindow() {
        Object data;
        Control ctrl = this.getControl();
        if (!SwtUtil.isDisposed(ctrl) && (data = ctrl.getShell().getData()) instanceof Window) {
            return (Window)data;
        }
        return null;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        Window parentWindow = this.getWindow();
        if (parentWindow instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)parentWindow;
        }
        if (parentWindow instanceof DetachedWindow) {
            return ((DetachedWindow)parentWindow).getWorkbenchPage().getWorkbenchWindow();
        }
        return null;
    }

    public void moveAbove(Control refControl) {
    }

    public void reparent(Composite newParent) {
        Control control = this.getControl();
        if (control == null || control.getParent() == newParent) {
            return;
        }
        if (control.isReparentable()) {
            control.setBounds(0, 0, 0, 0);
            boolean enabled = control.getEnabled();
            control.setEnabled(false);
            control.setParent(newParent);
            control.setEnabled(enabled);
        }
    }

    public boolean getVisible() {
        Control ctrl = this.getControl();
        if (!SwtUtil.isDisposed(ctrl)) {
            return ctrl.getVisible();
        }
        return false;
    }

    public boolean isVisible() {
        Control ctrl = this.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            return ctrl.isVisible();
        }
        return false;
    }

    public void setVisible(boolean makeVisible) {
        Control ctrl = this.getControl();
        if (!SwtUtil.isDisposed(ctrl)) {
            if (makeVisible == ctrl.getVisible()) {
                return;
            }
            if (!makeVisible && this.isFocusAncestor(ctrl)) {
                ctrl.getShell().forceFocus();
            }
            ctrl.setVisible(makeVisible);
            Object[] listeners = this.propertyListeners.getListeners();
            if (listeners.length > 0) {
                Boolean oldValue = makeVisible ? Boolean.FALSE : Boolean.TRUE;
                Boolean newValue = makeVisible ? Boolean.TRUE : Boolean.FALSE;
                PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROP_VISIBILITY, (Object)oldValue, (Object)newValue);
                int i = 0;
                while (i < listeners.length) {
                    ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                    ++i;
                }
            }
        }
    }

    private boolean isFocusAncestor(Control ctrl) {
        Control f = ctrl.getDisplay().getFocusControl();
        while (f != null && f != ctrl) {
            f = f.getParent();
        }
        return f == ctrl;
    }

    public void setBounds(Rectangle r) {
        Control ctrl = this.getControl();
        if (!SwtUtil.isDisposed(ctrl)) {
            ctrl.setBounds(r);
        }
    }

    public void setContainer(ILayoutContainer container) {
        this.container = container;
        if (container != null) {
            this.setZoomed(container.childIsZoomed(this));
        }
    }

    public void setFocus() {
    }

    public void setID(String str) {
        this.id = str;
    }

    public LayoutPart getPart() {
        return this;
    }

    public IPresentablePart getPresentablePart() {
        return null;
    }

    public void childRequestZoomIn(LayoutPart toZoom) {
    }

    public void childRequestZoomOut() {
    }

    public final void requestZoomOut() {
        ILayoutContainer container = this.getContainer();
        if (container != null) {
            container.childRequestZoomOut();
        }
    }

    public final void requestZoomIn() {
        ILayoutContainer container = this.getContainer();
        if (container != null) {
            container.childRequestZoomIn(this);
        }
    }

    public final boolean isObscuredByZoom() {
        ILayoutContainer container = this.getContainer();
        if (container != null) {
            return container.childObscuredByZoom(this);
        }
        return false;
    }

    public boolean childObscuredByZoom(LayoutPart toTest) {
        return false;
    }

    public boolean childIsZoomed(LayoutPart childToTest) {
        return false;
    }

    public void setZoomed(boolean isZoomed) {
    }

    protected ListenerList getPropertyListeners() {
        return this.propertyListeners;
    }

    public void describeLayout(StringBuffer buf) {
        IPresentablePart part = this.getPresentablePart();
        if (part != null) {
            buf.append(part.getName());
            return;
        }
    }

    public String getPlaceHolderId() {
        return this.getID();
    }

    public void resizeChild(LayoutPart childThatChanged) {
    }

    public void flushLayout() {
        ILayoutContainer container = this.getContainer();
        if (this.getContainer() != null) {
            container.resizeChild(this);
        }
    }

    public boolean allowsAdd(LayoutPart toAdd) {
        return false;
    }

    public void testInvariants() {
    }
}

