/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.presentations.SystemMenuDetach;
import org.eclipse.ui.internal.presentations.SystemMenuFastView;
import org.eclipse.ui.internal.presentations.SystemMenuSize;
import org.eclipse.ui.internal.presentations.UpdatingActionContributionItem;
import org.eclipse.ui.presentations.IPresentablePart;

public class ViewStack
extends PartStack {
    private boolean allowStateChanges;
    private WorkbenchPage page;
    private SystemMenuSize sizeItem = new SystemMenuSize(null);
    private SystemMenuFastView fastViewAction;
    private SystemMenuDetach detachViewAction;

    public void addSystemActions(IMenuManager menuManager) {
        PartStack.appendToGroupIfPossible(menuManager, "misc", (ContributionItem)new UpdatingActionContributionItem(this.fastViewAction));
        PartStack.appendToGroupIfPossible(menuManager, "misc", (ContributionItem)new UpdatingActionContributionItem(this.detachViewAction));
        this.sizeItem = new SystemMenuSize(this.getVisiblePart());
        PartStack.appendToGroupIfPossible(menuManager, "size", this.sizeItem);
    }

    public ViewStack(WorkbenchPage page) {
        this(page, true);
    }

    public ViewStack(WorkbenchPage page, boolean allowsStateChanges) {
        this(page, allowsStateChanges, 2);
    }

    public ViewStack(WorkbenchPage page, boolean allowsStateChanges, int appearance) {
        super(appearance);
        this.page = page;
        this.setID(this.toString());
        this.allowStateChanges = allowsStateChanges;
        this.fastViewAction = new SystemMenuFastView(this.getPresentationSite());
        this.detachViewAction = new SystemMenuDetach(this.getPresentationSite());
    }

    protected WorkbenchPage getPage() {
        return this.page;
    }

    protected boolean canMoveFolder() {
        Perspective perspective = this.page.getActivePerspective();
        if (perspective == null) {
            return false;
        }
        return !perspective.isFixedLayout();
    }

    protected void updateActions() {
        ViewPane pane = null;
        PartPane part = this.getVisiblePart();
        if (part instanceof ViewPane) {
            pane = (ViewPane)part;
        }
        this.fastViewAction.setPane(pane);
        this.detachViewAction.setPane(pane);
        this.sizeItem.setPane(pane);
    }

    protected boolean isMoveable(IPresentablePart part) {
        ViewPane pane = (ViewPane)this.getPaneFor(part);
        Perspective perspective = this.page.getActivePerspective();
        if (perspective == null) {
            return true;
        }
        return perspective.isMoveable(pane.getViewReference());
    }

    protected boolean supportsState(int newState) {
        if (this.page.isFixedLayout()) {
            return false;
        }
        return this.allowStateChanges;
    }

    protected void derefPart(LayoutPart toDeref) {
        this.page.getActivePerspective().getPresentation().derefPart(toDeref);
    }

    protected boolean allowsDrop(PartPane part) {
        return part instanceof ViewPane;
    }
}

