/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;

public class NewWizardShortcutAction
extends Action
implements IPluginContribution {
    private WorkbenchWizardElement wizardElement;
    private IWorkbenchWindow window;

    public NewWizardShortcutAction(IWorkbenchWindow window, WorkbenchWizardElement element) {
        super(element.getLabel(element));
        this.setToolTipText(element.getDescription());
        this.setImageDescriptor(element.getImageDescriptor());
        this.setId(ActionFactory.NEW.getId());
        this.wizardElement = element;
        this.window = window;
    }

    public void run() {
        INewWizard wizard;
        try {
            wizard = (INewWizard)this.wizardElement.createExecutableExtension();
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.window.getShell(), (String)WorkbenchMessages.getString("NewWizardShortcutAction.errorTitle"), (String)WorkbenchMessages.getString("NewWizardShortcutAction.errorMessage"), (IStatus)e.getStatus());
            return;
        }
        ISelection selection = this.window.getSelectionService().getSelection();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection) {
            selectionToPass = this.wizardElement.adaptedSelection((IStructuredSelection)selection);
        } else {
            IWorkbenchPart part = this.window.getPartService().getActivePart();
            if (part instanceof IEditorPart) {
                Object file;
                IEditorInput input = ((IEditorPart)part).getEditorInput();
                Class fileClass = LegacyResourceSupport.getFileClass();
                if (input != null && fileClass != null && (file = input.getAdapter(fileClass)) != null) {
                    selectionToPass = new StructuredSelection(file);
                }
            }
        }
        wizard.init(this.window.getWorkbench(), (IStructuredSelection)selectionToPass);
        Shell parent = this.window.getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        WorkbenchHelp.setHelp((Control)dialog.getShell(), "org.eclipse.ui.new_wizard_shortcut_context");
        dialog.open();
    }

    public String getLocalId() {
        return this.wizardElement.getLocalId();
    }

    public String getPluginId() {
        return this.wizardElement.getPluginId();
    }
}

