/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands.ws;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.commands.CommandEvent;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandListener;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;

public final class CommandCallback
implements ExternalActionManager.ICallback {
    private static final ResourceBundle RESOURCE_BUNDLE;
    private final Set loggedCommandIds = new HashSet();
    private final Map registeredListeners = new HashMap();
    private final IWorkbench workbench;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.ws.CommandCallback");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
    }

    public CommandCallback(IWorkbench workbenchToUse) {
        this.workbench = workbenchToUse;
    }

    public void addPropertyChangeListener(String commandId, final IPropertyChangeListener listener) {
        final ICommand command = this.workbench.getCommandSupport().getCommandManager().getCommand(commandId);
        ICommandListener commandListener = new ICommandListener(){

            public void commandChanged(CommandEvent commandEvent) {
                if (commandEvent.hasNameChanged() || commandEvent.haveKeySequenceBindingsChanged()) {
                    PropertyChangeEvent event;
                    try {
                        event = new PropertyChangeEvent((Object)command, "text", null, (Object)command.getName());
                    }
                    catch (NotDefinedException notDefinedException) {
                        event = new PropertyChangeEvent((Object)command, "text", null, null);
                    }
                    listener.propertyChange(event);
                }
            }
        };
        command.addCommandListener(commandListener);
        Assert.isTrue((!this.registeredListeners.containsKey(listener) ? 1 : 0) != 0);
        this.registeredListeners.put(listener, commandListener);
    }

    public final Integer getAccelerator(String commandId) {
        ICommand command = this.workbench.getCommandSupport().getCommandManager().getCommand(commandId);
        Integer accelerator = null;
        if (command.isDefined()) {
            List keySequenceBindings = command.getKeySequenceBindings();
            int size = keySequenceBindings.size();
            int i = 0;
            while (i < size) {
                IKeySequenceBinding keySequenceBinding = (IKeySequenceBinding)keySequenceBindings.get(i);
                List keyStrokes = keySequenceBinding.getKeySequence().getKeyStrokes();
                if (keyStrokes.size() == 1) {
                    KeyStroke keyStroke = (KeyStroke)keyStrokes.get(0);
                    accelerator = new Integer(SWTKeySupport.convertKeyStrokeToAccelerator(keyStroke));
                    break;
                }
                ++i;
            }
        }
        return accelerator;
    }

    public final String getAcceleratorText(String commandId) {
        List keySequenceBindings;
        ICommand command = this.workbench.getCommandSupport().getCommandManager().getCommand(commandId);
        String acceleratorText = null;
        if (command.isDefined() && !(keySequenceBindings = command.getKeySequenceBindings()).isEmpty()) {
            IKeySequenceBinding keySequenceBinding = (IKeySequenceBinding)keySequenceBindings.get(0);
            acceleratorText = keySequenceBinding.getKeySequence().format();
        }
        return acceleratorText;
    }

    public boolean isAcceleratorInUse(int accelerator) {
        KeySequence keySequence = KeySequence.getInstance(SWTKeySupport.convertAcceleratorToKeyStroke(accelerator));
        ICommandManager commandManager = this.workbench.getCommandSupport().getCommandManager();
        return commandManager.isPerfectMatch(keySequence) || commandManager.isPartialMatch(keySequence);
    }

    public final boolean isActive(final String commandId) {
        if (commandId != null) {
            final ICommand command = this.workbench.getCommandSupport().getCommandManager().getCommand(commandId);
            if (!command.isDefined() && !this.loggedCommandIds.contains(commandId)) {
                StringBuffer message = new StringBuffer();
                message.append("The command '");
                message.append(command.getId());
                message.append("' is not defined, but is being asked if it is active.  Are you using an actionDefinitionId without defining a command?");
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, Util.translateString(RESOURCE_BUNDLE, "undefinedCommand.WarningMessage"), null);
                WorkbenchPlugin.log(message.toString(), (IStatus)status);
                this.loggedCommandIds.add(commandId);
                command.addCommandListener(new ICommandListener(){

                    public final void commandChanged(CommandEvent commandEvent) {
                        if (command.isDefined()) {
                            command.removeCommandListener(this);
                            CommandCallback.this.loggedCommandIds.remove(commandId);
                        }
                    }
                });
                return true;
            }
            return this.workbench.getActivitySupport().getActivityManager().getIdentifier(command.getId()).isEnabled();
        }
        return true;
    }

    public final void removePropertyChangeListener(String commandId, IPropertyChangeListener listener) {
        ICommand command = this.workbench.getCommandSupport().getCommandManager().getCommand(commandId);
        Object associatedListener = this.registeredListeners.remove(listener);
        if (associatedListener instanceof ICommandListener) {
            ICommandListener commandListener = (ICommandListener)associatedListener;
            command.removeCommandListener(commandListener);
        }
    }
}

