/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.decorators.FullDecoratorDefinition;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;
import org.eclipse.ui.internal.registry.RegistryReader;

public class DecoratorRegistryReader
extends RegistryReader {
    private Collection values = new ArrayList();
    private Collection ids = new HashSet();
    static final String ATT_CLASS = "class";
    private static final String ATT_LABEL = "label";
    private static final String ATT_ADAPTABLE = "adaptable";
    private static final String ATT_ID = "id";
    private static final String ATT_DESCRIPTION = "description";
    private static final String ATT_ICON = "icon";
    private static final String ATT_QUADRANT = "quadrant";
    private static final String ATT_LOCATION = "location";
    private static final String ATT_ENABLED = "state";
    private static final String CHILD_ENABLEMENT = "enablement";
    private static final String P_TRUE = "true";
    private static final String ATT_OBJECT_CLASS = "objectClass";
    private static final String ATT_LIGHTWEIGHT = "lightweight";
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int UNDERLAY = 4;
    private static final String TOP_LEFT_STRING = "TOP_LEFT";
    private static final String TOP_RIGHT_STRING = "TOP_RIGHT";
    private static final String BOTTOM_LEFT_STRING = "BOTTOM_LEFT";
    private static final String UNDERLAY_STRING = "UNDERLAY";

    public boolean readElement(IConfigurationElement element) {
        boolean noClass;
        ActionExpression enablementExpression;
        String name = element.getAttribute(ATT_LABEL);
        String id = element.getAttribute(ATT_ID);
        if (this.ids.contains(id)) {
            this.logDuplicateId(element);
            return false;
        }
        this.ids.add(id);
        String description = "";
        IConfigurationElement[] descriptions = element.getChildren(ATT_DESCRIPTION);
        if (descriptions.length > 0) {
            description = descriptions[0].getValue();
        }
        boolean adaptable = P_TRUE.equals(element.getAttribute(ATT_ADAPTABLE));
        boolean enabled = P_TRUE.equals(element.getAttribute(ATT_ENABLED));
        IConfigurationElement[] enablement = element.getChildren(CHILD_ENABLEMENT);
        if (enablement.length == 0) {
            String className = element.getAttribute(ATT_OBJECT_CLASS);
            if (className == null) {
                RegistryReader.logMissingElement(element, CHILD_ENABLEMENT);
                return false;
            }
            enablementExpression = new ActionExpression(ATT_OBJECT_CLASS, className);
        } else {
            enablementExpression = new ActionExpression(enablement[0]);
        }
        boolean bl = noClass = element.getAttribute(ATT_CLASS) == null;
        if (P_TRUE.equals(element.getAttribute(ATT_LIGHTWEIGHT)) || noClass) {
            int quadrant = this.getLocationConstant(element.getAttribute(ATT_LOCATION), element);
            String iconPath = element.getAttribute(ATT_ICON);
            if (noClass && iconPath == null) {
                RegistryReader.logMissingElement(element, ATT_ICON);
                return false;
            }
            this.values.add(new LightweightDecoratorDefinition(id, name, description, enablementExpression, adaptable, enabled, quadrant, iconPath, element));
        } else {
            this.values.add(new FullDecoratorDefinition(id, name, description, enablementExpression, adaptable, enabled, element));
        }
        return true;
    }

    Collection readRegistry(IExtensionRegistry in) {
        this.values.clear();
        this.ids.clear();
        this.readRegistry(in, "org.eclipse.ui", "decorators");
        return this.values;
    }

    public Collection getValues() {
        return this.values;
    }

    private int getLocationConstant(String locationDefinition, IConfigurationElement element) {
        if (locationDefinition == null) {
            locationDefinition = element.getAttribute(ATT_QUADRANT);
        }
        if (TOP_RIGHT_STRING.equals(locationDefinition)) {
            return 1;
        }
        if (TOP_LEFT_STRING.equals(locationDefinition)) {
            return 0;
        }
        if (BOTTOM_LEFT_STRING.equals(locationDefinition)) {
            return 2;
        }
        if (UNDERLAY_STRING.equals(locationDefinition)) {
            return 4;
        }
        return 3;
    }

    protected void logDuplicateId(IConfigurationElement element) {
        RegistryReader.logError(element, "Duplicate id found: " + element.getAttribute(ATT_ID));
    }
}

