/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.internal.misc.StringMatcher;

public class WorkbenchPreferenceGroup {
    private String id;
    private String name;
    private Collection pages = new ArrayList();
    private Collection pageIds;
    private ImageDescriptor imageDescriptor;
    private Image image;
    private boolean highlight = false;
    private Object lastSelection = null;
    private boolean isDefault = false;

    public WorkbenchPreferenceGroup(String uniqueID, String displayableName, Collection ids, ImageDescriptor icon, boolean defaultValue) {
        this.id = uniqueID;
        this.name = displayableName;
        this.imageDescriptor = icon;
        this.pageIds = ids;
        this.isDefault = defaultValue;
    }

    public String getId() {
        return this.id;
    }

    public void addNode(WorkbenchPreferenceNode node) {
        this.pages.add(node);
    }

    public Image getImage() {
        if (this.imageDescriptor == null) {
            return null;
        }
        if (this.image == null) {
            this.image = this.imageDescriptor.createImage();
        }
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public void disposeResources() {
        this.image.dispose();
        this.image = null;
    }

    public IPreferenceNode[] getPreferenceNodes() {
        IPreferenceNode[] nodes = new IPreferenceNode[this.pages.size()];
        this.pages.toArray(nodes);
        return nodes;
    }

    public Collection getPageIds() {
        return this.pageIds;
    }

    public void highlightHits(String text) {
        Iterator pagesIterator = this.pages.iterator();
        StringMatcher matcher = new StringMatcher(String.valueOf('*') + text + '*', true, false);
        while (pagesIterator.hasNext()) {
            WorkbenchPreferenceNode node = (WorkbenchPreferenceNode)pagesIterator.next();
            if (text.length() == 0) {
                this.clearSearchResults(node);
                continue;
            }
            this.matchNode(matcher, node);
        }
    }

    void clearSearchResults(WorkbenchPreferenceNode node) {
        node.setHighlighted(false);
        IPreferenceNode[] children = node.getSubNodes();
        int i = 0;
        while (i < children.length) {
            this.clearSearchResults((WorkbenchPreferenceNode)children[i]);
            ++i;
        }
    }

    private void matchNode(StringMatcher matcher, WorkbenchPreferenceNode node) {
        node.setHighlighted(matcher.match(node.getLabelText()));
        IPreferenceNode[] children = node.getSubNodes();
        int i = 0;
        while (i < children.length) {
            this.matchNode(matcher, (WorkbenchPreferenceNode)children[i]);
            ++i;
        }
    }

    public boolean isHighlighted() {
        return this.highlight;
    }

    public Object getLastSelection() {
        return this.lastSelection;
    }

    public void setLastSelection(Object lastSelection) {
        this.lastSelection = lastSelection;
    }

    private Object findParent(IPreferenceNode node, Object element) {
        IPreferenceNode[] subs = node.getSubNodes();
        int i = 0;
        while (i < subs.length) {
            IPreferenceNode subNode = subs[i];
            if (subNode.equals(element)) {
                return node;
            }
            Object parent = this.findParent(subNode, element);
            if (parent != null) {
                return parent;
            }
            ++i;
        }
        return null;
    }

    public void highlightIds(String[] filteredIds) {
        int i = 0;
        while (i < filteredIds.length) {
            this.checkId(filteredIds[i]);
            ++i;
        }
    }

    private void checkId(String id) {
        Iterator pagesIterator = this.pages.iterator();
        while (pagesIterator.hasNext()) {
            WorkbenchPreferenceNode next = (WorkbenchPreferenceNode)pagesIterator.next();
            this.checkHighlightNode(id, (IPreferenceNode)next);
        }
    }

    private boolean checkHighlightNode(String id, IPreferenceNode node) {
        if (node.getId().equals(id)) {
            ((WorkbenchPreferenceNode)node).setHighlighted(true);
            return true;
        }
        IPreferenceNode[] subNodes = node.getSubNodes();
        int i = 0;
        while (i < subNodes.length) {
            if (this.checkHighlightNode(id, subNodes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isDefault() {
        return this.isDefault;
    }
}

