/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ExceptionHandler;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ErrorInfo;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.JobErrorDialog;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.WorkbenchJob;

public class ErrorNotificationManager {
    private static final String ERROR_JOB = "errorstate.gif";
    static final String ERROR_JOB_KEY = "ERROR_JOB";
    private Collection errors = Collections.synchronizedSet(new HashSet());
    private JobErrorDialog dialog;

    void setUpImages(URL iconsRoot) throws MalformedURLException {
        JFaceResources.getImageRegistry().put(ERROR_JOB_KEY, ImageDescriptor.createFromURL((URL)new URL(iconsRoot, ERROR_JOB)));
    }

    void addError(IStatus status, Job job) {
        final Throwable exception = status.getException();
        if (exception != null && exception instanceof OutOfMemoryError) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ExceptionHandler.getInstance().handleException(exception);
                }
            });
            return;
        }
        ErrorInfo errorInfo = new ErrorInfo(status, job);
        this.showError(errorInfo);
    }

    private void showError(final ErrorInfo errorInfo) {
        if (!PlatformUI.isWorkbenchRunning()) {
            WorkbenchPlugin.log(errorInfo.getJob().getName(), errorInfo.getErrorStatus());
            return;
        }
        WorkbenchJob job = new WorkbenchJob(ProgressMessages.getString("ErrorNotificationManager.OpenErrorDialogJob")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (ProgressManagerUtil.rescheduleIfModalShellOpen(this)) {
                    return Status.CANCEL_STATUS;
                }
                ErrorNotificationManager.this.errors.add(errorInfo);
                if (ErrorNotificationManager.this.dialog != null) {
                    ErrorNotificationManager.this.dialog.refresh();
                } else if (Platform.isRunning()) {
                    Object noPromptProperty = errorInfo.getJob().getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY);
                    boolean prompt = true;
                    if (noPromptProperty instanceof Boolean) {
                        boolean bl = prompt = (Boolean)noPromptProperty == false;
                    }
                    if (prompt) {
                        return ErrorNotificationManager.this.openErrorDialog(null, null, errorInfo);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    Collection getErrors() {
        return this.errors;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus openErrorDialog(String title, String msg, ErrorInfo errorInfo) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench instanceof Workbench && ((Workbench)workbench).isClosing()) {
            return Status.CANCEL_STATUS;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return Status.CANCEL_STATUS;
        }
        this.dialog = new JobErrorDialog(window.getShell(), title, msg, errorInfo, 7);
        try {
            this.dialog.open();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.dialog = null;
            this.clearAllErrors();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.dialog = null;
            this.clearAllErrors();
            return Status.OK_STATUS;
        }
    }

    void removeErrors(Collection errorsToRemove) {
        this.errors.removeAll(errorsToRemove);
        this.removeFromFinishedJobs(errorsToRemove);
    }

    private void removeFromFinishedJobs(Collection errorsToRemove) {
        Iterator errorIterator = errorsToRemove.iterator();
        HashSet<IStatus> errorStatuses = new HashSet<IStatus>();
        while (errorIterator.hasNext()) {
            ErrorInfo next = (ErrorInfo)errorIterator.next();
            errorStatuses.add(next.getErrorStatus());
        }
        JobTreeElement[] infos = FinishedJobs.getInstance().getJobInfos();
        int i = 0;
        while (i < infos.length) {
            JobInfo info;
            if (infos[i].isJobInfo() && errorStatuses.contains((info = (JobInfo)infos[i]).getJob().getResult())) {
                FinishedJobs.getInstance().remove(info);
            }
            ++i;
        }
    }

    private void clearAllErrors() {
        this.removeFromFinishedJobs(this.errors);
        this.errors.clear();
    }

    public boolean showErrorFor(Job job, String title, String msg) {
        if (this.dialog != null) {
            return true;
        }
        ErrorInfo info = this.getErrorInfo(job);
        info = job == null ? this.getMostRecentError() : this.getErrorInfo(job);
        if (info != null) {
            this.openErrorDialog(title, msg, info);
            return true;
        }
        return false;
    }

    private ErrorInfo getMostRecentError() {
        ErrorInfo mostRecentInfo = null;
        Iterator iter = this.errors.iterator();
        while (iter.hasNext()) {
            ErrorInfo info = (ErrorInfo)iter.next();
            if (mostRecentInfo != null && info.getTimestamp() <= mostRecentInfo.getTimestamp()) continue;
            mostRecentInfo = info;
        }
        return mostRecentInfo;
    }

    private ErrorInfo getErrorInfo(Job job) {
        Iterator iter = this.errors.iterator();
        while (iter.hasNext()) {
            ErrorInfo info = (ErrorInfo)iter.next();
            if (info.getJob() != job) continue;
            return info;
        }
        return null;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

