/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.Stack;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISlaveDocumentManager;
import org.eclipse.jface.text.ISlaveDocumentManagerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.projection.ChildDocument;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationBarHoverManager;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.OverviewRulerHoverManager;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SourceViewer
extends TextViewer
implements ISourceViewer,
ISourceViewerExtension,
ISourceViewerExtension2 {
    protected static final int GAP_SIZE = 2;
    protected static final String _SELECTION_POSITION_CATEGORY = "__selection_category";
    protected static final Object MODEL_ANNOTATION_MODEL = new Object();
    protected IContentAssistant fContentAssistant;
    protected boolean fContentAssistantInstalled;
    protected IContentFormatter fContentFormatter;
    protected IReconciler fReconciler;
    protected IPresentationReconciler fPresentationReconciler;
    protected IAnnotationHover fAnnotationHover;
    protected final Stack fSelections = new Stack();
    protected IPositionUpdater fSelectionUpdater = null;
    protected String fSelectionCategory;
    protected IAnnotationHover fOverviewRulerAnnotationHover;
    protected IInformationPresenter fInformationPresenter;
    private IVerticalRuler fVerticalRuler;
    private boolean fIsVerticalRulerVisible;
    private Composite fComposite;
    private IAnnotationModel fVisualAnnotationModel;
    private Annotation fRangeIndicator;
    private AbstractHoverInformationControlManager fVerticalRulerHoveringController;
    private AbstractHoverInformationControlManager fOverviewRulerHoveringController;
    private IOverviewRuler fOverviewRuler;
    private boolean fIsOverviewRulerVisible;

    public SourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this(parent, ruler, null, false, styles);
    }

    public SourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        this.fVerticalRuler = verticalRuler;
        this.fIsVerticalRulerVisible = verticalRuler != null;
        this.fOverviewRuler = overviewRuler;
        this.fIsOverviewRulerVisible = showAnnotationsOverview && overviewRuler != null;
        this.createControl(parent, styles);
    }

    protected void createControl(Composite parent, int styles) {
        if (this.fVerticalRuler != null || this.fOverviewRuler != null) {
            styles &= 0xFFFFF7FF;
            this.fComposite = new Canvas(parent, 0);
            this.fComposite.setLayout(this.createLayout());
            parent = this.fComposite;
        }
        super.createControl(parent, styles);
        if (this.fVerticalRuler != null) {
            this.fVerticalRuler.createControl(this.fComposite, this);
        }
        if (this.fOverviewRuler != null) {
            this.fOverviewRuler.createControl(this.fComposite, this);
        }
    }

    protected Layout createLayout() {
        return new RulerLayout(2);
    }

    public Control getControl() {
        if (this.fComposite != null) {
            return this.fComposite;
        }
        return super.getControl();
    }

    public void setAnnotationHover(IAnnotationHover annotationHover) {
        this.fAnnotationHover = annotationHover;
    }

    public void setOverviewRulerAnnotationHover(IAnnotationHover annotationHover) {
        this.fOverviewRulerAnnotationHover = annotationHover;
    }

    public void configure(SourceViewerConfiguration configuration) {
        if (this.getTextWidget() == null) {
            return;
        }
        this.setDocumentPartitioning(configuration.getConfiguredDocumentPartitioning(this));
        this.fPresentationReconciler = configuration.getPresentationReconciler(this);
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.install(this);
        }
        this.fReconciler = configuration.getReconciler(this);
        if (this.fReconciler != null) {
            this.fReconciler.install(this);
        }
        this.fContentAssistant = configuration.getContentAssistant(this);
        if (this.fContentAssistant != null) {
            this.fContentAssistant.install(this);
            this.fContentAssistantInstalled = true;
        }
        this.fContentFormatter = configuration.getContentFormatter(this);
        this.fInformationPresenter = configuration.getInformationPresenter(this);
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.install(this);
        }
        this.setUndoManager(configuration.getUndoManager(this));
        this.getTextWidget().setTabs(configuration.getTabWidth(this));
        this.setAnnotationHover(configuration.getAnnotationHover(this));
        this.setOverviewRulerAnnotationHover(configuration.getOverviewRulerAnnotationHover(this));
        this.setHoverControlCreator(configuration.getInformationControlCreator(this));
        this.setHyperlinkPresenter(configuration.getHyperlinkPresenter(this));
        IHyperlinkDetector[] hyperlinkDetectors = configuration.getHyperlinkDetectors(this);
        int eventStateMask = configuration.getHyperlinkStateMask(this);
        this.setHyperlinkDetectors(hyperlinkDetectors, eventStateMask);
        String[] types = configuration.getConfiguredContentTypes(this);
        int i = 0;
        while (i < types.length) {
            String t = types[i];
            this.setAutoEditStrategies(configuration.getAutoEditStrategies(this, t), t);
            this.setTextDoubleClickStrategy(configuration.getDoubleClickStrategy(this, t), t);
            int[] stateMasks = configuration.getConfiguredTextHoverStateMasks(this, t);
            if (stateMasks != null) {
                int j = 0;
                while (j < stateMasks.length) {
                    int stateMask = stateMasks[j];
                    this.setTextHover(configuration.getTextHover(this, t, stateMask), t, stateMask);
                    ++j;
                }
            } else {
                this.setTextHover(configuration.getTextHover(this, t), t, 255);
            }
            String[] prefixes = configuration.getIndentPrefixes(this, t);
            if (prefixes != null && prefixes.length > 0) {
                this.setIndentPrefixes(prefixes, t);
            }
            if ((prefixes = configuration.getDefaultPrefixes(this, t)) != null && prefixes.length > 0) {
                this.setDefaultPrefixes(prefixes, t);
            }
            ++i;
        }
        this.activatePlugins();
    }

    protected void ensureAnnotationHoverManagerInstalled() {
        if (this.fVerticalRuler != null && this.fAnnotationHover != null && this.fVerticalRulerHoveringController == null && this.fHoverControlCreator != null) {
            this.fVerticalRulerHoveringController = new AnnotationBarHoverManager(this.fVerticalRuler, this, this.fAnnotationHover, this.fHoverControlCreator);
            this.fVerticalRulerHoveringController.install(this.fVerticalRuler.getControl());
        }
    }

    protected void ensureOverviewHoverManagerInstalled() {
        if (this.fOverviewRuler != null && this.fOverviewRulerAnnotationHover != null && this.fOverviewRulerHoveringController == null && this.fHoverControlCreator != null) {
            this.fOverviewRulerHoveringController = new OverviewRulerHoverManager(this.fOverviewRuler, (ISourceViewer)this, this.fOverviewRulerAnnotationHover, this.fHoverControlCreator);
            this.fOverviewRulerHoveringController.install(this.fOverviewRuler.getControl());
        }
    }

    public void activatePlugins() {
        this.ensureAnnotationHoverManagerInstalled();
        this.ensureOverviewHoverManagerInstalled();
        super.activatePlugins();
    }

    public void setDocument(IDocument document) {
        this.setDocument(document, null, -1, -1);
    }

    public void setDocument(IDocument document, int visibleRegionOffset, int visibleRegionLength) {
        this.setDocument(document, null, visibleRegionOffset, visibleRegionLength);
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel) {
        this.setDocument(document, annotationModel, -1, -1);
    }

    protected IAnnotationModel createVisualAnnotationModel(IAnnotationModel annotationModel) {
        AnnotationModel model = new AnnotationModel();
        model.addAnnotationModel(MODEL_ANNOTATION_MODEL, annotationModel);
        return (IAnnotationModel)model;
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        if (this.fVerticalRuler == null && this.fOverviewRuler == null) {
            if (modelRangeOffset == -1 && modelRangeLength == -1) {
                super.setDocument(document);
            } else {
                super.setDocument(document, modelRangeOffset, modelRangeLength);
            }
        } else {
            if (this.fVisualAnnotationModel != null && this.getDocument() != null) {
                this.fVisualAnnotationModel.disconnect(this.getDocument());
            }
            if (annotationModel != null && document != null) {
                this.fVisualAnnotationModel = this.createVisualAnnotationModel(annotationModel);
                this.fVisualAnnotationModel.connect(document);
            } else {
                this.fVisualAnnotationModel = null;
            }
            if (modelRangeOffset == -1 && modelRangeLength == -1) {
                super.setDocument(document);
            } else {
                super.setDocument(document, modelRangeOffset, modelRangeLength);
            }
            if (this.fVerticalRuler != null) {
                this.fVerticalRuler.setModel(this.fVisualAnnotationModel);
            }
            if (this.fOverviewRuler != null) {
                this.fOverviewRuler.setModel(this.fVisualAnnotationModel);
            }
        }
    }

    public IAnnotationModel getAnnotationModel() {
        if (this.fVisualAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension extension = (IAnnotationModelExtension)this.fVisualAnnotationModel;
            return extension.getAnnotationModel(MODEL_ANNOTATION_MODEL);
        }
        return null;
    }

    public IAnnotationModel getVisualAnnotationModel() {
        return this.fVisualAnnotationModel;
    }

    public void unconfigure() {
        this.clearRememberedSelection();
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.uninstall();
            this.fPresentationReconciler = null;
        }
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fContentAssistant != null) {
            this.fContentAssistant.uninstall();
            this.fContentAssistantInstalled = false;
            this.fContentAssistant = null;
        }
        this.fContentFormatter = null;
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.uninstall();
            this.fInformationPresenter = null;
        }
        this.fAutoIndentStrategies = null;
        this.fDoubleClickStrategies = null;
        this.fTextHovers = null;
        this.fIndentChars = null;
        this.fDefaultPrefixChars = null;
        if (this.fVerticalRulerHoveringController != null) {
            this.fVerticalRulerHoveringController.dispose();
            this.fVerticalRulerHoveringController = null;
        }
        if (this.fOverviewRulerHoveringController != null) {
            this.fOverviewRulerHoveringController.dispose();
            this.fOverviewRulerHoveringController = null;
        }
        this.setHyperlinkDetectors(null, 0);
    }

    protected void handleDispose() {
        this.unconfigure();
        if (this.fVisualAnnotationModel != null && this.getDocument() != null) {
            this.fVisualAnnotationModel.disconnect(this.getDocument());
            this.fVisualAnnotationModel = null;
        }
        this.fVerticalRuler = null;
        this.fOverviewRuler = null;
        this.fComposite = null;
        super.handleDispose();
    }

    public boolean canDoOperation(int operation) {
        if (this.getTextWidget() == null || !this.redraws() && operation != 15) {
            return false;
        }
        if (operation == 13) {
            return this.fContentAssistant != null && this.fContentAssistantInstalled && this.isEditable();
        }
        if (operation == 14) {
            return this.fContentAssistant != null && this.fContentAssistantInstalled && this.isEditable();
        }
        if (operation == 16) {
            return this.fInformationPresenter != null;
        }
        if (operation == 15) {
            return this.fContentFormatter != null && this.isEditable();
        }
        return super.canDoOperation(operation);
    }

    protected IFormattingContext createFormattingContext() {
        return new FormattingContext();
    }

    protected Point rememberSelection() {
        Point selection = this.getSelectedRange();
        IDocument document = this.getDocument();
        if (this.fSelections.isEmpty()) {
            this.fSelectionCategory = _SELECTION_POSITION_CATEGORY + this.hashCode();
            this.fSelectionUpdater = new DefaultPositionUpdater(this.fSelectionCategory);
            document.addPositionCategory(this.fSelectionCategory);
            document.addPositionUpdater(this.fSelectionUpdater);
        }
        try {
            Position position = new Position(selection.x, selection.y);
            document.addPosition(this.fSelectionCategory, position);
            this.fSelections.push(position);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return selection;
    }

    protected void restoreSelection() {
        if (!this.fSelections.isEmpty()) {
            IDocument document = this.getDocument();
            Position position = (Position)this.fSelections.pop();
            try {
                document.removePosition(this.fSelectionCategory, position);
                this.setSelectedRange(position.getOffset(), position.getLength());
                if (this.fSelections.isEmpty()) {
                    document.removePositionUpdater(this.fSelectionUpdater);
                    this.fSelectionUpdater = null;
                    document.removePositionCategory(this.fSelectionCategory);
                    this.fSelectionCategory = null;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }

    protected void clearRememberedSelection() {
        if (this.fSelections.isEmpty()) {
            return;
        }
        this.fSelections.clear();
        IDocument document = this.getDocument();
        document.removePositionUpdater(this.fSelectionUpdater);
        this.fSelectionUpdater = null;
        try {
            document.removePositionCategory(this.fSelectionCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        this.fSelectionCategory = null;
    }

    /*
     * Exception decompiling
     */
    public void doOperation(int operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 424->428)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateSlaveDocuments(IDocument masterDocument) {
        ISlaveDocumentManagerExtension extension;
        IDocument[] slaves;
        ISlaveDocumentManager manager = this.getSlaveDocumentManager();
        if (manager instanceof ISlaveDocumentManagerExtension && (slaves = (extension = (ISlaveDocumentManagerExtension)manager).getSlaveDocuments(masterDocument)) != null) {
            int i = 0;
            while (i < slaves.length) {
                if (slaves[i] instanceof ChildDocument) {
                    ChildDocument child = (ChildDocument)slaves[i];
                    Position p = child.getParentDocumentRange();
                    try {
                        if (!this.updateSlaveDocument((IDocument)child, p.getOffset(), p.getLength())) {
                            child.repairLineInformation();
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                ++i;
            }
        }
    }

    public void enableOperation(int operation, boolean enable) {
        switch (operation) {
            case 13: 
            case 14: {
                if (this.fContentAssistant == null) {
                    return;
                }
                if (enable) {
                    if (this.fContentAssistantInstalled) break;
                    this.fContentAssistant.install(this);
                    this.fContentAssistantInstalled = true;
                    break;
                }
                if (!this.fContentAssistantInstalled) break;
                this.fContentAssistant.uninstall();
                this.fContentAssistantInstalled = false;
            }
        }
    }

    public void setRangeIndicator(Annotation rangeIndicator) {
        this.fRangeIndicator = rangeIndicator;
    }

    public void setRangeIndication(int start, int length, boolean moveCursor) {
        if (moveCursor) {
            this.setSelectedRange(start, 0);
            this.revealRange(start, length);
        }
        if (this.fRangeIndicator != null && this.fVisualAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension extension = (IAnnotationModelExtension)this.fVisualAnnotationModel;
            extension.modifyAnnotationPosition(this.fRangeIndicator, new Position(start, length));
        }
    }

    public IRegion getRangeIndication() {
        Position position;
        if (this.fRangeIndicator != null && this.fVisualAnnotationModel != null && (position = this.fVisualAnnotationModel.getPosition(this.fRangeIndicator)) != null) {
            return new Region(position.getOffset(), position.getLength());
        }
        return null;
    }

    public void removeRangeIndication() {
        if (this.fRangeIndicator != null && this.fVisualAnnotationModel != null) {
            this.fVisualAnnotationModel.removeAnnotation(this.fRangeIndicator);
        }
    }

    public void showAnnotations(boolean show) {
        boolean old = this.fIsVerticalRulerVisible;
        boolean bl = this.fIsVerticalRulerVisible = show && this.fVerticalRuler != null;
        if (old != this.fIsVerticalRulerVisible) {
            if (this.fComposite != null && !this.fComposite.isDisposed()) {
                this.fComposite.layout();
            }
            if (this.fIsVerticalRulerVisible) {
                this.ensureAnnotationHoverManagerInstalled();
            } else if (this.fVerticalRulerHoveringController != null) {
                this.fVerticalRulerHoveringController.dispose();
                this.fVerticalRulerHoveringController = null;
            }
        }
    }

    protected final IVerticalRuler getVerticalRuler() {
        return this.fVerticalRuler;
    }

    public void showAnnotationsOverview(boolean show) {
        boolean old = this.fIsOverviewRulerVisible;
        boolean bl = this.fIsOverviewRulerVisible = show && this.fOverviewRuler != null;
        if (old != this.fIsOverviewRulerVisible) {
            if (this.fComposite != null && !this.fComposite.isDisposed()) {
                this.fComposite.layout();
            }
            if (this.fIsOverviewRulerVisible) {
                this.ensureOverviewHoverManagerInstalled();
            } else if (this.fOverviewRulerHoveringController != null) {
                this.fOverviewRulerHoveringController.dispose();
                this.fOverviewRulerHoveringController = null;
            }
        }
    }

    protected class RulerLayout
    extends Layout {
        protected int fGap;

        public RulerLayout(int gap) {
            this.fGap = gap;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point s = children[children.length - 1].computeSize(-1, -1, flushCache);
            if (SourceViewer.this.fVerticalRuler != null && SourceViewer.this.fIsVerticalRulerVisible) {
                s.x += SourceViewer.this.fVerticalRuler.getWidth() + this.fGap;
            }
            return s;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clArea = composite.getClientArea();
            Rectangle trim = SourceViewer.this.getTextWidget().computeTrim(0, 0, 0, 0);
            int topTrim = -trim.y;
            int scrollbarHeight = trim.height - topTrim;
            int x = clArea.x;
            int width = clArea.width;
            if (SourceViewer.this.fOverviewRuler != null && SourceViewer.this.fIsOverviewRulerVisible) {
                int overviewRulerWidth = SourceViewer.this.fOverviewRuler.getWidth();
                SourceViewer.this.fOverviewRuler.getControl().setBounds(clArea.x + clArea.width - overviewRulerWidth - 1, clArea.y + scrollbarHeight, overviewRulerWidth, clArea.height - 3 * scrollbarHeight);
                SourceViewer.this.fOverviewRuler.getHeaderControl().setBounds(clArea.x + clArea.width - overviewRulerWidth - 1, clArea.y, overviewRulerWidth, scrollbarHeight);
                width -= overviewRulerWidth + this.fGap;
            }
            if (SourceViewer.this.fVerticalRuler != null && SourceViewer.this.fIsVerticalRulerVisible) {
                int verticalRulerWidth = SourceViewer.this.fVerticalRuler.getWidth();
                SourceViewer.this.fVerticalRuler.getControl().setBounds(clArea.x, clArea.y + topTrim, verticalRulerWidth, clArea.height - scrollbarHeight - topTrim);
                x += verticalRulerWidth + this.fGap;
                width -= verticalRulerWidth + this.fGap;
            }
            SourceViewer.this.getTextWidget().setBounds(x, clArea.y, width, clArea.height);
        }
    }
}

