/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.build.BuildContentsSection;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.swt.widgets.Composite;

public class BinSection
extends BuildContentsSection
implements IModelChangedListener {
    private static String SECTION_TITLE = "BuildEditor.BinSection.title";
    private static String SECTION_DESC = "BuildEditor.BinSection.desc";

    public BinSection(BuildPage page, Composite parent) {
        super(page, parent);
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.getSection().setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    protected void initializeCheckState() {
        super.initializeCheckState();
        IBuild build = this.fBuildModel.getBuild();
        IBuildEntry binIncl = build.getEntry("bin.includes");
        IBuildEntry binExcl = build.getEntry("bin.excludes");
        if (binIncl == null) {
            return;
        }
        super.initializeCheckState(binIncl, binExcl);
    }

    protected void deleteFolderChildrenFromEntries(IFolder folder) {
        IBuild build = this.fBuildModel.getBuild();
        IBuildEntry binIncl = build.getEntry("bin.includes");
        IBuildEntry binExcl = build.getEntry("bin.excludes");
        String parentFolder = this.getResourceFolderName(folder.getProjectRelativePath().toString());
        this.removeChildren(binIncl, parentFolder);
        this.removeChildren(binExcl, parentFolder);
    }

    protected void handleBuildCheckStateChange(boolean wasTopParentChecked) {
        IResource resource = this.fParentResource;
        String resourceName = this.fParentResource.getProjectRelativePath().toString();
        IBuild build = this.fBuildModel.getBuild();
        IBuildEntry includes = build.getEntry("bin.includes");
        IBuildEntry excludes = build.getEntry("bin.excludes");
        resourceName = this.handleResourceFolder(resource, resourceName);
        if (this.isChecked) {
            this.handleCheck(includes, excludes, resourceName, resource, wasTopParentChecked, "bin.includes");
        } else {
            this.handleUncheck(includes, excludes, resourceName, resource, "bin.excludes");
        }
        this.deleteEmptyEntries();
        this.fOriginalResource = null;
        this.fParentResource = null;
    }

    public void modelChanged(IModelChangedEvent event) {
        Object changeObject;
        if (event.getChangeType() == 99) {
            this.markStale();
        }
        if (!((changeObject = event.getChangedObjects()[0]) instanceof IBuildEntry) || !((IBuildEntry)changeObject).getName().equals("bin.excludes") && !((IBuildEntry)changeObject).getName().equals("bin.includes")) {
            return;
        }
        if (this.fParentResource == null && this.fOriginalResource != null || this.fOriginalResource == null && this.fParentResource != null) {
            this.initializeCheckState();
            return;
        }
        if (this.fParentResource == null && this.fOriginalResource == null) {
            if (event.getChangedProperty() != null && event.getChangedProperty().equals("bin.includes")) {
                if (event.getOldValue() == null && event.getNewValue() != null) {
                    if (event.getNewValue().equals(".")) {
                        return;
                    }
                    IFile file = this.fProject.getFile((IPath)new Path(event.getNewValue().toString()));
                    if (!file.exists()) {
                        return;
                    }
                    this.fParentResource = this.fOriginalResource = file;
                    this.isChecked = true;
                } else if (event.getOldValue() != null && event.getNewValue() == null) {
                    if (event.getOldValue().equals(".")) {
                        return;
                    }
                    IFile file = this.fProject.getFile((IPath)new Path(event.getOldValue().toString()));
                    if (!file.exists()) {
                        return;
                    }
                    this.fParentResource = this.fOriginalResource = file;
                    this.isChecked = false;
                } else {
                    return;
                }
            }
            return;
        }
        this.fTreeViewer.setChecked((Object)this.fParentResource, this.isChecked);
        this.fTreeViewer.setGrayed((Object)this.fOriginalResource, false);
        this.fTreeViewer.setParentsGrayed((Object)this.fParentResource, true);
        this.setParentsChecked(this.fParentResource);
        this.fTreeViewer.setGrayed((Object)this.fParentResource, false);
        if (this.fParentResource instanceof IFolder) {
            this.fTreeViewer.setSubtreeChecked((Object)this.fParentResource, this.isChecked);
            this.setChildrenGrayed(this.fParentResource, false);
        }
        while (!this.fOriginalResource.equals((Object)this.fParentResource)) {
            this.fTreeViewer.setChecked((Object)this.fOriginalResource, this.isChecked);
            this.fOriginalResource = this.fOriginalResource.getParent();
        }
        this.fParentResource = null;
        this.fOriginalResource = null;
    }
}

