/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.build.AddLibraryDialog;
import org.eclipse.pde.internal.ui.editor.build.BuildUtil;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.StructuredViewerPart;
import org.eclipse.pde.internal.ui.parts.TablePart;
import org.eclipse.pde.internal.ui.wizards.FolderSelectionDialog;
import org.eclipse.pde.internal.ui.wizards.RenameDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RuntimeInfoSection
extends PDESection
implements IModelChangedListener {
    public static final String SECTION_TITLE = "BuildEditor.RuntimeInfoSection.title";
    public static final String SECTION_DESC = "BuildEditor.RuntimeInfoSection.desc";
    public static final String SECTION_NEW = "BuildEditor.RuntimeInfoSection.addLibrary";
    public static final String SECTION_UP = "ManifestEditor.LibrarySection.up";
    public static final String SECTION_DOWN = "ManifestEditor.LibrarySection.down";
    public static final String POPUP_NEW_LIBRARY = "BuildEditor.RuntimeInfoSection.popupAdd";
    public static final String POPUP_DELETE = "Actions.delete.label";
    public static final String JSECTION_NEW = "BuildEditor.RuntimeInfoSection.addFolder";
    public static final String POPUP_NEW_FOLDER = "BuildEditor.RuntimeInfoSection.popupFolder";
    public static final String JAR_INCLUDE = "BuildEditor.RuntimeInfoSection.buildInclude";
    protected TableViewer fLibraryViewer;
    protected TableViewer fFolderViewer;
    protected StructuredViewerPart fLibraryPart;
    protected StructuredViewerPart fFolderPart;
    private IBuildEntry fCurrentLibrary;
    private IStructuredSelection fCurrentSelection;
    private Button fIncludeLibraryButton;
    private boolean fEnabled = true;

    public RuntimeInfoSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.getSection().setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.getBuildModel().addModelChangedListener((IModelChangedListener)this);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
        PDEPlugin.getDefault().getLabelProvider().connect(this);
    }

    private IBuildModel getBuildModel() {
        InputContext context = this.getPage().getPDEEditor().getContextManager().findContext("build-context");
        if (context == null) {
            return null;
        }
        return (IBuildModel)context.getModel();
    }

    protected void handleLibInBinBuild(boolean isSelected, String libName) {
        IBuildModel model = this.getBuildModel();
        IBuildEntry binIncl = model.getBuild().getEntry("bin.includes");
        IProject project = model.getUnderlyingResource().getProject();
        IPath libPath = libName.equals(".") ? null : project.getFile(libName).getProjectRelativePath();
        try {
            if (binIncl == null && !isSelected) {
                return;
            }
            if (binIncl == null) {
                binIncl = model.getFactory().createEntry("bin.includes");
                model.getBuild().add(binIncl);
            }
            if (libPath != null) {
                if (!isSelected && libPath.segmentCount() == 1 && binIncl.contains("*.jar")) {
                    this.addAllJarsToBinIncludes(binIncl, project, model);
                } else if (!isSelected && libPath.segmentCount() > 1) {
                    IPath parent = libPath.removeLastSegments(1);
                    String parentPath = String.valueOf(parent.toString()) + '/';
                    if (binIncl.contains(parentPath) && !project.exists(parent)) {
                        binIncl.removeToken(parentPath);
                    } else if (parent.segmentCount() > 1 && binIncl.contains(parentPath = String.valueOf((parent = parent.removeLastSegments(1)).toString()) + '/') && !project.exists(parent)) {
                        binIncl.removeToken(parentPath);
                    }
                }
            }
            if (isSelected && !binIncl.contains(libName)) {
                binIncl.addToken(libName);
            } else if (!isSelected && binIncl.contains(libName)) {
                binIncl.removeToken(libName);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected void addAllJarsToBinIncludes(IBuildEntry binIncl, IProject project, IBuildModel model) {
        try {
            IResource[] members = project.members();
            int i = 0;
            while (i < members.length) {
                if (!(members[i] instanceof IFolder) && members[i].getFileExtension().equals("jar")) {
                    binIncl.addToken(members[i].getName());
                }
                ++i;
            }
            IBuildEntry[] libraries = BuildUtil.getBuildLibraries(model.getBuild().getBuildEntries());
            if (libraries.length != 0) {
                int j = 0;
                while (j < libraries.length) {
                    String libraryName = libraries[j].getName().substring(7);
                    IPath path = project.getFile(libraryName).getProjectRelativePath();
                    if (path.segmentCount() == 1 && !binIncl.contains(libraryName)) {
                        binIncl.addToken(libraryName);
                    }
                    ++j;
                }
            }
            binIncl.removeToken("*.jar");
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void setOutputEntryTokens(Set outputFolders, IBuildEntry outputEntry) {
        Iterator iter = outputFolders.iterator();
        try {
            while (iter.hasNext()) {
                String outputFolder = iter.next().toString();
                if (!outputFolder.endsWith("/")) {
                    outputFolder = outputFolder.concat("/");
                }
                if (outputEntry.contains(outputFolder.toString())) continue;
                outputEntry.addToken(outputFolder.toString());
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private IPackageFragmentRoot[] computeSourceFolders() {
        ArrayList<IPackageFragmentRoot> folders = new ArrayList<IPackageFragmentRoot>();
        IBuildModel buildModel = this.getBuildModel();
        IProject project = buildModel.getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        folders.add(roots[i]);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return folders.toArray(new IPackageFragmentRoot[folders.size()]);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        this.createLeftSection(container, toolkit);
        this.createRightSection(container, toolkit);
        this.fIncludeLibraryButton = toolkit.createButton(container, PDEPlugin.getResourceString(JAR_INCLUDE), 32);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fIncludeLibraryButton.setLayoutData((Object)gd);
        this.fIncludeLibraryButton.setVisible(false);
        this.fIncludeLibraryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeInfoSection.this.handleLibInBinBuild(RuntimeInfoSection.this.fIncludeLibraryButton.getSelection(), RuntimeInfoSection.this.fCurrentLibrary.getName().substring(7));
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
    }

    private void createLeftSection(Composite parent, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        container.setLayoutData((Object)gd);
        String[] stringArray = new String[4];
        stringArray[0] = PDEPlugin.getResourceString(SECTION_NEW);
        stringArray[2] = PDEPlugin.getResourceString(SECTION_UP);
        stringArray[3] = PDEPlugin.getResourceString(SECTION_DOWN);
        this.fLibraryPart = new PartAdapter(stringArray);
        this.fLibraryPart.createControl(container, 65536, 2, toolkit);
        this.fLibraryViewer = (TableViewer)this.fLibraryPart.getViewer();
        this.fLibraryViewer.setContentProvider((IContentProvider)new LibraryContentProvider());
        this.fLibraryViewer.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider());
        this.fLibraryPart.setButtonEnabled(2, false);
        this.fLibraryPart.setButtonEnabled(3, false);
        this.fLibraryViewer.setInput((Object)this.getBuildModel());
        toolkit.paintBordersFor(container);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RuntimeInfoSection.this.fillLibraryContextMenu(manager);
            }
        });
        this.fLibraryViewer.getControl().setMenu(menuMgr.createContextMenu(this.fLibraryViewer.getControl()));
    }

    private void createRightSection(Composite parent, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        container.setLayoutData((Object)gd);
        this.fFolderPart = new PartAdapter(new String[]{PDEPlugin.getResourceString(JSECTION_NEW)});
        this.fFolderPart.createControl(container, 65536, 2, toolkit);
        this.fFolderViewer = (TableViewer)this.fFolderPart.getViewer();
        this.fFolderViewer.setContentProvider((IContentProvider)new FolderContentProvider());
        this.fFolderViewer.setLabelProvider((IBaseLabelProvider)new FolderLabelProvider());
        toolkit.paintBordersFor(container);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RuntimeInfoSection.this.fillFolderViewerContextMenu(manager);
            }
        });
        this.fFolderViewer.getControl().setMenu(menuMgr.createContextMenu(this.fFolderViewer.getControl()));
    }

    protected void fillFolderViewerContextMenu(IMenuManager manager) {
        ISelection selection = this.fFolderViewer.getSelection();
        if (this.fCurrentLibrary != null) {
            Action newAction = new Action(PDEPlugin.getResourceString(POPUP_NEW_FOLDER)){

                public void run() {
                    RuntimeInfoSection.this.handleNewFolder();
                }
            };
            newAction.setEnabled(this.fEnabled);
            manager.add((IAction)newAction);
        }
        manager.add((IContributionItem)new Separator());
        Action deleteAction = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

            public void run() {
                RuntimeInfoSection.this.handleDeleteFolder();
            }
        };
        deleteAction.setEnabled(!selection.isEmpty() && this.fEnabled);
        manager.add((IAction)deleteAction);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager, false);
    }

    protected void fillLibraryContextMenu(IMenuManager manager) {
        ISelection selection = this.fLibraryViewer.getSelection();
        Action newAction = new Action(PDEPlugin.getResourceString(POPUP_NEW_LIBRARY)){

            public void run() {
                RuntimeInfoSection.this.handleNew();
            }
        };
        newAction.setEnabled(this.fEnabled);
        manager.add((IAction)newAction);
        manager.add((IContributionItem)new Separator());
        RenameAction renameAction = new RenameAction();
        renameAction.setEnabled(!selection.isEmpty() && this.fEnabled);
        manager.add((IAction)renameAction);
        Action deleteAction = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

            public void run() {
                RuntimeInfoSection.this.handleDelete();
            }
        };
        deleteAction.setEnabled(!selection.isEmpty() && this.fEnabled);
        manager.add((IAction)deleteAction);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager, false);
    }

    protected void entryModified(IBuildEntry oldEntry, String newValue) {
        IBuildEntry entry = oldEntry;
        IBuildModel buildModel = this.getBuildModel();
        IBuild build = buildModel.getBuild();
        String oldName = entry.getName().substring(7);
        try {
            IBuildEntry tempEntry;
            if (newValue.equals(entry.getName())) {
                return;
            }
            if (!newValue.startsWith("source.")) {
                newValue = "source." + newValue;
            }
            if (!(newValue.endsWith(".jar") || newValue.endsWith("/") || newValue.equals("."))) {
                newValue = String.valueOf(newValue) + "/";
            }
            if ((tempEntry = build.getEntry("jars.compile.order")) != null && tempEntry.contains(oldName)) {
                tempEntry.renameToken(oldName, newValue.substring(7));
            }
            if ((tempEntry = build.getEntry("output." + oldName)) != null) {
                tempEntry.setName("output." + newValue.substring(7));
            }
            if ((tempEntry = build.getEntry("bin.includes")) != null && tempEntry.contains(oldName)) {
                tempEntry.renameToken(oldName, newValue.substring(7));
            }
            if ((tempEntry = build.getEntry("bin.excludes")) != null && tempEntry.contains(oldName)) {
                tempEntry.renameToken(oldName, newValue.substring(7));
            }
            entry.setName(newValue);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void expandTo(Object object) {
        this.fLibraryViewer.setSelection((ISelection)new StructuredSelection(object), true);
    }

    public void handleDoubleClick(IStructuredSelection selection) {
        this.doRename();
    }

    public void enableSection(boolean enable) {
        this.fEnabled = enable;
        this.fLibraryPart.setButtonEnabled(0, enable);
        this.fLibraryPart.setButtonEnabled(2, false);
        this.fLibraryPart.setButtonEnabled(3, false);
        this.fIncludeLibraryButton.setEnabled(enable);
        this.fFolderPart.setButtonEnabled(0, enable && !this.fLibraryViewer.getSelection().isEmpty());
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            if (this.fEnabled) {
                if (this.fLibraryViewer.getControl().isFocusControl()) {
                    this.handleDelete();
                } else {
                    this.handleDeleteFolder();
                }
            }
            return true;
        }
        return false;
    }

    private void doRename() {
        IStructuredSelection selection = (IStructuredSelection)this.fLibraryViewer.getSelection();
        if (selection.size() == 1) {
            IBuildEntry entry = (IBuildEntry)selection.getFirstElement();
            String oldName = entry.getName().substring(7);
            RenameDialog dialog = new RenameDialog(this.fLibraryViewer.getControl().getShell(), oldName);
            dialog.create();
            dialog.getShell().setText(PDEPlugin.getResourceString("EditableTablePart.renameTitle"));
            dialog.getShell().setSize(300, 150);
            if (dialog.open() == 0) {
                this.entryModified(entry, dialog.getNewName());
            }
        }
    }

    public void dispose() {
        IBuildModel buildModel = this.getBuildModel();
        if (buildModel != null) {
            buildModel.removeModelChangedListener((IModelChangedListener)this);
        }
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    private void refreshOutputKeys() {
        if (!this.isJavaProject()) {
            return;
        }
        IPackageFragmentRoot[] sourceFolders = this.computeSourceFolders();
        String[] jarFolders = this.fCurrentLibrary.getTokens();
        try {
            HashSet<String> outputFolders = new HashSet<String>();
            int j = 0;
            while (j < jarFolders.length) {
                IPackageFragmentRoot sourceFolder = this.getSourceFolder(jarFolders[j], sourceFolders);
                if (sourceFolder != null) {
                    IClasspathEntry entry = sourceFolder.getRawClasspathEntry();
                    IPath outputPath = entry.getOutputLocation();
                    if (outputPath == null) {
                        outputFolders.add("bin");
                    } else {
                        outputPath = outputPath.removeFirstSegments(1);
                        outputFolders.add(outputPath.toString());
                    }
                }
                ++j;
            }
            if (outputFolders.size() != 0) {
                String outputName;
                String libName = this.fCurrentLibrary.getName().substring(7);
                IBuildModel buildModel = this.getBuildModel();
                IBuild build = buildModel.getBuild();
                IBuildEntry outputEntry = build.getEntry(outputName = "output." + libName);
                if (outputEntry == null) {
                    outputEntry = buildModel.getFactory().createEntry(outputName);
                    build.add(outputEntry);
                }
                this.setOutputEntryTokens(outputFolders, outputEntry);
            }
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private boolean isJavaProject() {
        try {
            IBuildModel buildModel = this.getBuildModel();
            IProject project = buildModel.getUnderlyingResource().getProject();
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean isReadOnly() {
        IBuildModel model = this.getBuildModel();
        if (model instanceof IEditable) {
            return !((IEditable)model).isEditable();
        }
        return true;
    }

    private void update(IBuildEntry variable) {
        this.fCurrentLibrary = variable;
        this.fFolderViewer.setInput((Object)this.fCurrentLibrary);
        this.fFolderPart.setButtonEnabled(0, !this.isReadOnly() && this.fEnabled && variable != null);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        if (item instanceof IBuildEntry) {
            this.update((IBuildEntry)item);
            this.updateDirectionalButtons();
            String name = ((IBuildEntry)item).getName();
            if (!name.endsWith(".")) {
                this.fIncludeLibraryButton.setVisible(true);
            } else {
                this.fIncludeLibraryButton.setVisible(false);
            }
            if (name.startsWith("source.")) {
                name = name.substring("source.".length());
            }
            this.fIncludeLibraryButton.setSelection(this.isJarIncluded(name));
        }
    }

    protected void updateDirectionalButtons() {
        Table table = this.fLibraryViewer.getTable();
        TableItem[] selection = table.getSelection();
        boolean hasSelection = selection.length > 0;
        boolean canMove = table.getItemCount() > 1;
        this.fLibraryPart.setButtonEnabled(2, canMove && hasSelection && table.getSelectionIndex() > 0);
        this.fLibraryPart.setButtonEnabled(3, canMove && hasSelection && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    private boolean isJarIncluded(String libName) {
        IBuildModel model = this.getBuildModel();
        IProject project = model.getUnderlyingResource().getProject();
        IPath libPath = libName.equals(".") ? null : project.getFile(libName).getProjectRelativePath();
        IBuildEntry binIncl = model.getBuild().getEntry("bin.includes");
        IBuildEntry binExcl = model.getBuild().getEntry("bin.excludes");
        if (binIncl == null) {
            return false;
        }
        if (libPath == null) {
            return binIncl.contains(libName);
        }
        if (libPath.segmentCount() == 1) {
            return binIncl.contains(libName) || binIncl.contains("*.jar");
        }
        if (binIncl.contains(libName)) {
            return true;
        }
        if (binExcl != null && binExcl.contains(libName)) {
            return false;
        }
        return this.isParentIncluded(libPath, binIncl, binExcl);
    }

    protected boolean isParentIncluded(IPath libPath, IBuildEntry binIncl, IBuildEntry binExcl) {
        while (libPath.segmentCount() > 1) {
            if (binIncl.contains(String.valueOf((libPath = libPath.removeLastSegments(1)).toString()) + '/')) {
                return true;
            }
            if (binExcl == null || !binExcl.contains(String.valueOf(libPath.toString()) + '/')) continue;
            return false;
        }
        return false;
    }

    public void refresh() {
        this.fLibraryViewer.refresh();
        this.fFolderViewer.refresh();
        this.fLibraryViewer.setSelection(null);
        this.fFolderViewer.setInput(null);
        this.fFolderPart.setButtonEnabled(0, false);
        this.fIncludeLibraryButton.setVisible(false);
        this.updateDirectionalButtons();
        super.refresh();
    }

    protected String[] getLibraryNames() {
        String[] libNames = new String[this.fLibraryViewer.getTable().getItemCount()];
        int i = 0;
        while (i < libNames.length) {
            libNames[i] = this.fLibraryViewer.getTable().getItem(i).getText();
            ++i;
        }
        return libNames;
    }

    protected void handleNew() {
        final String[] libNames = this.getLibraryNames();
        IBaseModel pmodel = this.getPage().getModel();
        final IPluginModelBase pluginModelBase = pmodel instanceof IPluginModelBase ? (IPluginModelBase)pmodel : null;
        BusyIndicator.showWhile((Display)this.fLibraryViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IBuildModel buildModel = RuntimeInfoSection.this.getBuildModel();
                IBuild build = buildModel.getBuild();
                AddLibraryDialog dialog = new AddLibraryDialog(RuntimeInfoSection.this.getSection().getShell(), libNames, pluginModelBase);
                dialog.create();
                dialog.getShell().setText(PDEPlugin.getResourceString("RuntimeInfoSection.addEntry"));
                try {
                    if (dialog.open() == 0) {
                        String keyName;
                        String name = dialog.getNewName();
                        if (!(name.endsWith(".jar") || name.equals(".") || name.endsWith("/"))) {
                            name = String.valueOf(name) + "/";
                        }
                        if (!(keyName = name).startsWith("source.")) {
                            keyName = "source." + name;
                        }
                        if (name.startsWith("source.")) {
                            name = name.substring(7);
                        }
                        if (!name.endsWith(".")) {
                            RuntimeInfoSection.this.handleLibInBinBuild(true, name);
                        }
                        IBuildEntry jarOrderEntry = build.getEntry("jars.compile.order");
                        int numLib = RuntimeInfoSection.this.fLibraryViewer.getTable().getItemCount();
                        if (jarOrderEntry == null) {
                            jarOrderEntry = RuntimeInfoSection.this.getBuildModel().getFactory().createEntry("jars.compile.order");
                            int i = 0;
                            while (i < numLib) {
                                String lib = ((IBuildEntry)RuntimeInfoSection.this.fLibraryViewer.getElementAt(i)).getName().substring(7);
                                jarOrderEntry.addToken(lib);
                                ++i;
                            }
                            jarOrderEntry.addToken(name);
                            build.add(jarOrderEntry);
                        } else if (jarOrderEntry.getTokens().length < numLib) {
                            String[] tokens = jarOrderEntry.getTokens();
                            int i = 0;
                            while (i < tokens.length) {
                                jarOrderEntry.removeToken(tokens[i]);
                                ++i;
                            }
                            i = 0;
                            while (i < numLib) {
                                String lib = ((IBuildEntry)RuntimeInfoSection.this.fLibraryViewer.getElementAt(i)).getName().substring(7);
                                jarOrderEntry.addToken(lib);
                                ++i;
                            }
                            jarOrderEntry.addToken(name);
                        } else {
                            jarOrderEntry.addToken(name);
                        }
                        IBuildEntry library = buildModel.getFactory().createEntry(keyName);
                        build.add(library);
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
    }

    private IPackageFragmentRoot getSourceFolder(String folderName, IPackageFragmentRoot[] sourceFolders) {
        int i = 0;
        while (i < sourceFolders.length) {
            if (sourceFolders[i].getPath().removeFirstSegments(1).equals((Object)new Path(folderName))) {
                return sourceFolders[i];
            }
            ++i;
        }
        return null;
    }

    protected void handleDelete() {
        int index = this.fLibraryViewer.getTable().getSelectionIndex();
        if (index != -1) {
            String libName = this.fLibraryViewer.getTable().getItem(index).getText();
            IBuild build = this.getBuildModel().getBuild();
            try {
                IBuildEntry entry = build.getEntry("jars.compile.order");
                int numLib = this.fLibraryViewer.getTable().getItemCount();
                if (entry == null) {
                    entry = this.getBuildModel().getFactory().createEntry("jars.compile.order");
                    int i = 0;
                    while (i < numLib) {
                        String lib = ((IBuildEntry)this.fLibraryViewer.getElementAt(i)).getName().substring(7);
                        entry.addToken(lib);
                        ++i;
                    }
                    build.add(entry);
                } else if (entry.getTokens().length < numLib) {
                    String[] tokens = entry.getTokens();
                    int i = 0;
                    while (i < tokens.length) {
                        entry.removeToken(tokens[i]);
                        ++i;
                    }
                    i = 0;
                    while (i < numLib) {
                        String lib = ((IBuildEntry)this.fLibraryViewer.getElementAt(i)).getName().substring(7);
                        entry.addToken(lib);
                        ++i;
                    }
                }
                entry.removeToken(libName);
                entry = build.getEntry("output." + libName);
                if (entry != null) {
                    build.remove(entry);
                }
                if ((entry = build.getEntry("bin.includes")) != null && entry.contains(libName)) {
                    entry.removeToken(libName);
                }
                if ((entry = build.getEntry("bin.excludes")) != null && entry.contains(libName)) {
                    entry.removeToken(libName);
                }
                build.remove(build.getEntry("source." + libName));
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleDeleteFolder() {
        int index = this.fFolderViewer.getTable().getSelectionIndex();
        Object object = ((IStructuredSelection)this.fFolderViewer.getSelection()).getFirstElement();
        if (object != null) {
            String libKey = this.fCurrentLibrary.getName();
            IBuildEntry entry = this.getBuildModel().getBuild().getEntry(libKey);
            if (entry != null) {
                try {
                    String[] tokens = entry.getTokens();
                    this.fCurrentSelection = tokens.length > index + 1 ? new StructuredSelection((Object)tokens[index + 1]) : null;
                    this.fCurrentLibrary = entry;
                    entry.removeToken((String)object);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        }
    }

    private void handleNewFolder() {
        IFile file = (IFile)this.getBuildModel().getUnderlyingResource();
        final IProject project = file.getProject();
        FolderSelectionDialog dialog = new FolderSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new JarsNewContentProvider(){});
        dialog.setInput(project.getWorkspace());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).equals((Object)project);
                }
                return element instanceof IFolder;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEPlugin.getResourceString("ManifestEditor.JarsSection.dialogTitle"));
        dialog.setMessage(PDEPlugin.getResourceString("ManifestEditor.JarsSection.dialogMessage"));
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length != 1 || !(selection[0] instanceof IFolder)) {
                    return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
                }
                String libKey = RuntimeInfoSection.this.fCurrentLibrary.getName();
                IBuildEntry entry = RuntimeInfoSection.this.getBuildModel().getBuild().getEntry(libKey);
                String folderPath = ((IFolder)selection[0]).getProjectRelativePath().addTrailingSeparator().toString();
                if (entry != null && entry.contains(folderPath)) {
                    return new Status(4, PDEPlugin.getPluginId(), 4, PDEPlugin.getResourceString("BuildEditor.RuntimeInfoSection.duplicateFolder"), null);
                }
                return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
            }
        });
        if (dialog.open() == 0) {
            try {
                IFolder folder = (IFolder)dialog.getFirstResult();
                String folderPath = folder.getProjectRelativePath().addTrailingSeparator().toString();
                IBuildModel buildModel = this.getBuildModel();
                String libKey = this.fCurrentLibrary.getName();
                IBuildEntry entry = buildModel.getBuild().getEntry(libKey);
                this.fCurrentSelection = new StructuredSelection((Object)folderPath);
                entry.addToken(folderPath);
                this.refreshOutputKeys();
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    protected void handleDown() {
        int index = this.fLibraryViewer.getTable().getSelectionIndex();
        String item1 = ((IBuildEntry)this.fLibraryViewer.getElementAt(index)).getName().substring(7);
        String item2 = ((IBuildEntry)this.fLibraryViewer.getElementAt(index + 1)).getName().substring(7);
        this.updateJarsCompileOrder(item1, item2);
    }

    protected void handleUp() {
        int index = this.fLibraryViewer.getTable().getSelectionIndex();
        String item1 = ((IBuildEntry)this.fLibraryViewer.getElementAt(index)).getName().substring(7);
        String item2 = ((IBuildEntry)this.fLibraryViewer.getElementAt(index - 1)).getName().substring(7);
        this.updateJarsCompileOrder(item1, item2);
    }

    public void updateJarsCompileOrder(String library1, String library2) {
        IBuildModel model = this.getBuildModel();
        IBuild build = model.getBuild();
        IBuildEntry jarOrderEntry = build.getEntry("jars.compile.order");
        try {
            if (jarOrderEntry == null) {
                jarOrderEntry = model.getFactory().createEntry("jars.compile.order");
                build.add(jarOrderEntry);
            } else {
                String[] tokens = jarOrderEntry.getTokens();
                int i = 0;
                while (i < tokens.length) {
                    jarOrderEntry.removeToken(tokens[i]);
                    ++i;
                }
            }
            int numLib = this.fLibraryViewer.getTable().getItemCount();
            String[] names = new String[numLib];
            int i = 0;
            while (i < numLib) {
                String name = ((IBuildEntry)this.fLibraryViewer.getElementAt(i)).getName().substring(7);
                if (name.equals(library1)) {
                    name = library2;
                } else if (name.equals(library2)) {
                    name = library1;
                }
                names[i] = name;
                ++i;
            }
            i = 0;
            while (i < numLib) {
                jarOrderEntry.addToken(names[i]);
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
        }
        Object changeObject = event.getChangedObjects()[0];
        String keyName = event.getChangedProperty();
        int type = event.getChangeType();
        if (!(changeObject instanceof IBuildEntry) || !((IBuildEntry)changeObject).getName().startsWith("source.") && !((IBuildEntry)changeObject).getName().equals("jars.compile.order") && !((IBuildEntry)changeObject).getName().equals("bin.includes")) {
            return;
        }
        IBuildEntry entry = (IBuildEntry)changeObject;
        if (keyName != null && keyName.equals("bin.includes")) {
            if (this.fCurrentLibrary == null) {
                return;
            }
            if (event.getOldValue() == null || event.getNewValue() == null) {
                boolean isInBinBuild = entry.contains(this.fCurrentLibrary.getName().substring(7));
                this.fIncludeLibraryButton.setSelection(isInBinBuild);
            }
            return;
        }
        if (type == 1) {
            this.fLibraryViewer.refresh();
            if (this.fCurrentSelection != null) {
                this.fLibraryViewer.setSelection((ISelection)this.fCurrentSelection);
                this.fIncludeLibraryButton.setSelection(true);
                this.updateDirectionalButtons();
            } else {
                this.fFolderPart.setButtonEnabled(0, false);
                this.fLibraryViewer.setSelection(null);
                this.fFolderViewer.setInput(null);
                this.fIncludeLibraryButton.setVisible(false);
            }
        } else if (type == 2) {
            this.fLibraryViewer.remove((Object)entry);
            this.fLibraryViewer.refresh();
            this.fFolderPart.setButtonEnabled(0, false);
            this.fLibraryViewer.setSelection(null);
            this.fFolderViewer.setInput(null);
            this.fIncludeLibraryButton.setVisible(false);
        } else if (keyName != null && keyName.startsWith("source.")) {
            if (event.getOldValue() != null && event.getNewValue() != null) {
                this.fLibraryViewer.update((Object)entry, null);
                return;
            }
            this.refresh();
            if (this.fCurrentSelection != null) {
                this.fFolderViewer.setSelection((ISelection)this.fCurrentSelection);
                this.updateDirectionalButtons();
            } else {
                this.fFolderPart.setButtonEnabled(0, false);
                this.fLibraryViewer.setSelection(null);
                this.fFolderViewer.setInput(null);
                this.fIncludeLibraryButton.setVisible(false);
            }
            if (this.fCurrentLibrary != null) {
                this.update(this.fCurrentLibrary);
            }
        } else if (keyName != null && keyName.equals("jars.compile.order")) {
            if (event.getNewValue() == null && event.getOldValue() != null) {
                return;
            }
            if (event.getOldValue() != null && event.getNewValue() != null) {
                return;
            }
            this.fLibraryViewer.refresh();
            if (this.fCurrentLibrary != null) {
                this.fLibraryViewer.setSelection((ISelection)new StructuredSelection((Object)this.fCurrentLibrary));
            }
            this.updateDirectionalButtons();
        }
    }

    class RenameAction
    extends Action {
        public RenameAction() {
            super(PDEPlugin.getResourceString("EditableTablePart.renameAction"));
        }

        public void run() {
            RuntimeInfoSection.this.doRename();
        }
    }

    class PartAdapter
    extends TablePart {
        public PartAdapter(String[] buttonLabels) {
            super(buttonLabels);
        }

        public void selectionChanged(IStructuredSelection selection) {
            if (selection.size() != 0) {
                RuntimeInfoSection.this.selectionChanged(selection);
            }
        }

        public void handleDoubleClick(IStructuredSelection selection) {
            RuntimeInfoSection.this.handleDoubleClick(selection);
        }

        public void buttonSelected(Button button, int index) {
            if (this.getViewer() == RuntimeInfoSection.this.fLibraryPart.getViewer()) {
                switch (index) {
                    case 0: {
                        RuntimeInfoSection.this.handleNew();
                        break;
                    }
                    case 2: {
                        RuntimeInfoSection.this.handleUp();
                        break;
                    }
                    case 3: {
                        RuntimeInfoSection.this.handleDown();
                    }
                }
            } else if (this.getViewer() == RuntimeInfoSection.this.fFolderPart.getViewer()) {
                if (index == 0) {
                    RuntimeInfoSection.this.handleNewFolder();
                }
            } else {
                button.getShell().setDefaultButton(null);
            }
        }
    }

    public class LibraryContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            if (parent instanceof IBuildModel) {
                IBuild build = ((IBuildModel)parent).getBuild();
                IBuildEntry jarOrderEntry = build.getEntry("jars.compile.order");
                Object[] libraries = BuildUtil.getBuildLibraries(build.getBuildEntries());
                if (jarOrderEntry == null) {
                    return libraries;
                }
                Vector<Object> libList = new Vector<Object>();
                String[] tokens = jarOrderEntry.getTokens();
                int i = 0;
                while (i < tokens.length) {
                    IBuildEntry entry = build.getEntry("source." + tokens[i]);
                    if (entry != null) {
                        libList.add(entry);
                    }
                    ++i;
                }
                i = 0;
                while (i < libraries.length) {
                    if (!libList.contains(libraries[i])) {
                        libList.add(libraries[i]);
                    }
                    ++i;
                }
                return libList.toArray(new IBuildEntry[libList.size()]);
            }
            return new Object[0];
        }
    }

    public class LibraryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            String name = ((IBuildEntry)obj).getName();
            if (name.startsWith("source.")) {
                return name.substring("source.".length());
            }
            return name;
        }

        public Image getColumnImage(Object obj, int index) {
            PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
            return provider.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
        }
    }

    class JarsNewContentProvider
    extends WorkbenchContentProvider {
        JarsNewContentProvider() {
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IFolder) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public class FolderContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            return parent instanceof IBuildEntry ? ((IBuildEntry)parent).getTokens() : new Object[]{};
        }
    }

    public class FolderLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            return sharedImages.getImage("IMG_OBJ_FOLDER");
        }
    }
}

