/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IEnvironment;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.feature.Choice;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.pde.internal.ui.editor.feature.PortabilityChoicesDialog;
import org.eclipse.pde.internal.ui.editor.feature.ReferencePropertySource;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PortabilitySection
extends PDESection
implements IPartSelectionListener {
    public static final String KEY_DIALOG_TITLE = "FeatureEditor.PortabilityChoicesDialog.title";
    public static final String SECTION_TITLE = "FeatureEditor.PortabilitySection.title";
    public static final String SECTION_DESC = "FeatureEditor.PortabilitySection.desc";
    public static final String SECTION_OS = "FeatureEditor.PortabilitySection.os";
    public static final String SECTION_WS = "FeatureEditor.PortabilitySection.ws";
    public static final String SECTION_NL = "FeatureEditor.PortabilitySection.nl";
    public static final String SECTION_ARCH = "FeatureEditor.PortabilitySection.arch";
    public static final String SECTION_EDIT = "FeatureEditor.PortabilitySection.edit";
    private FormEntry osText;
    private FormEntry wsText;
    private FormEntry nlText;
    private FormEntry archText;
    private boolean reactToSelections;
    private IStructuredSelection currentInput;

    public PortabilitySection(FeatureFormPage page, Composite parent) {
        this(page, parent, PDEPlugin.getResourceString(SECTION_TITLE), PDEPlugin.getResourceString(SECTION_DESC), 2);
    }

    public PortabilitySection(PDEFormPage page, Composite parent, String title, String desc, int toggleStyle) {
        super(page, parent, 0x80 | toggleStyle);
        this.reactToSelections = toggleStyle == 0;
        this.getSection().setText(title);
        this.getSection().setDescription(desc);
        if (!this.reactToSelections) {
            IFeatureModel model = (IFeatureModel)page.getModel();
            IFeature feature = model.getFeature();
            this.getSection().setExpanded(feature.getOS() != null || feature.getWS() != null || feature.getNL() != null || feature.getArch() != null);
        }
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void commit(boolean onSave) {
        this.osText.commit();
        this.wsText.commit();
        if (this.nlText != null) {
            this.nlText.commit();
        }
        this.archText.commit();
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        String editLabel = PDEPlugin.getResourceString(SECTION_EDIT);
        this.osText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_OS), editLabel, false);
        this.osText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("os", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.osText.getText().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Choice[] choices = ReferencePropertySource.getOSChoices();
                        PortabilitySection.access$2(1.access$0(this.this$1), PortabilitySection.access$1(1.access$0(this.this$1)), choices);
                    }
                });
            }

            static /* synthetic */ PortabilitySection access$0(1 var0) {
                return var0.PortabilitySection.this;
            }
        });
        this.limitTextWidth(this.osText);
        this.wsText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_WS), editLabel, false);
        this.wsText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("ws", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.wsText.getText().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Choice[] choices = ReferencePropertySource.getWSChoices();
                        PortabilitySection.access$2(3.access$0(this.this$1), PortabilitySection.access$3(3.access$0(this.this$1)), choices);
                    }
                });
            }

            static /* synthetic */ PortabilitySection access$0(3 var0) {
                return var0.PortabilitySection.this;
            }
        });
        this.limitTextWidth(this.wsText);
        if (!this.reactToSelections) {
            this.nlText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_NL), editLabel, false);
            this.nlText.setFormEntryListener(new FormEntryAdapter(this){

                public void textValueChanged(FormEntry text) {
                    try {
                        PortabilitySection.this.applyValue("nl", text.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }

                public void browseButtonSelected(FormEntry entry) {
                    BusyIndicator.showWhile((Display)PortabilitySection.this.nlText.getText().getDisplay(), (Runnable)new Runnable(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            Choice[] choices = ReferencePropertySource.getNLChoices();
                            PortabilitySection.access$2(5.access$0(this.this$1), PortabilitySection.access$4(5.access$0(this.this$1)), choices);
                        }
                    });
                }

                static /* synthetic */ PortabilitySection access$0(5 var0) {
                    return var0.PortabilitySection.this;
                }
            });
            this.limitTextWidth(this.nlText);
        }
        this.archText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_ARCH), editLabel, false);
        this.archText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("arch", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.archText.getText().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Choice[] choices = ReferencePropertySource.getArchChoices();
                        PortabilitySection.access$2(7.access$0(this.this$1), PortabilitySection.access$5(7.access$0(this.this$1)), choices);
                    }
                });
            }

            static /* synthetic */ PortabilitySection access$0(7 var0) {
                return var0.PortabilitySection.this;
            }
        });
        this.limitTextWidth(this.archText);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
    }

    private void limitTextWidth(FormEntry entry) {
        GridData gd = (GridData)entry.getText().getLayoutData();
        gd.widthHint = this.reactToSelections ? 30 : 150;
    }

    private void openPortabilityChoiceDialog(FormEntry text, Choice[] choices) {
        String value = text.getValue();
        PortabilityChoicesDialog dialog = new PortabilityChoicesDialog(PDEPlugin.getActiveWorkbenchShell(), choices, value);
        dialog.create();
        dialog.getShell().setText(PDEPlugin.getResourceString(KEY_DIALOG_TITLE));
        int result = dialog.open();
        if (result == 0) {
            value = dialog.getValue();
            text.setValue(value);
        }
    }

    private IFeature getFeature() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        return model.getFeature();
    }

    private void applyValue(String property, String value) throws CoreException {
        if (this.reactToSelections) {
            if (this.currentInput == null) {
                return;
            }
            Iterator iter = this.currentInput.iterator();
            while (iter.hasNext()) {
                IEnvironment env = (IEnvironment)iter.next();
                this.applyValue(env, property, value);
            }
        } else {
            this.applyValue((IEnvironment)this.getFeature(), property, value);
        }
    }

    private void setValue(String property) {
        if (this.reactToSelections) {
            if (this.currentInput == null) {
                this.clearField(property);
            } else if (this.currentInput.size() == 1) {
                this.setValue((IEnvironment)this.currentInput.getFirstElement(), property);
            } else {
                IEnvironment leader = null;
                String lvalue = null;
                Iterator iter = this.currentInput.iterator();
                while (iter.hasNext()) {
                    String nvalue;
                    IEnvironment next = (IEnvironment)iter.next();
                    if (leader == null) {
                        nvalue = this.getValue(next, property);
                        if (nvalue == null) break;
                        leader = next;
                        lvalue = nvalue;
                        continue;
                    }
                    nvalue = this.getValue(next, property);
                    if (nvalue != null && lvalue.equals(nvalue)) continue;
                    leader = null;
                    break;
                }
                if (leader == null) {
                    this.clearField(property);
                } else {
                    this.setValue(leader, property);
                }
            }
        } else {
            this.setValue((IEnvironment)this.getFeature(), property);
        }
    }

    private String getValue(IEnvironment obj, String property) {
        if (property.equals("os")) {
            return obj.getOS();
        }
        if (property.equals("ws")) {
            return obj.getWS();
        }
        if (property.equals("arch")) {
            return obj.getArch();
        }
        return null;
    }

    private void applyValue(IEnvironment obj, String property, String value) throws CoreException {
        if (property.equals("nl")) {
            ((IFeature)obj).setNL(value);
        } else if (property.equals("os")) {
            obj.setOS(value);
        } else if (property.equals("ws")) {
            obj.setWS(value);
        } else if (property.equals("arch")) {
            obj.setArch(value);
        }
    }

    private void setValue(IEnvironment obj, String property) {
        if (property.equals("nl")) {
            this.setIfDefined(this.nlText, ((IFeature)obj).getNL());
        } else if (property.equals("os")) {
            this.setIfDefined(this.osText, obj.getOS());
        } else if (property.equals("ws")) {
            this.setIfDefined(this.wsText, obj.getWS());
        } else if (property.equals("arch")) {
            this.setIfDefined(this.archText, obj.getArch());
        }
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.enableForInput(model.isEditable());
        this.refresh();
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        }
    }

    public void setFocus() {
        if (this.osText != null) {
            this.osText.getText().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        formText.setValue(value, true);
    }

    private void enableForInput(boolean enable) {
        this.osText.getText().setEditable(enable);
        this.wsText.getText().setEditable(enable);
        if (this.nlText != null) {
            this.nlText.getText().setEditable(enable);
        }
        this.archText.getText().setEditable(enable);
        this.osText.getButton().setEnabled(enable);
        this.wsText.getButton().setEnabled(enable);
        if (this.nlText != null) {
            this.nlText.getButton().setEnabled(enable);
        }
        this.archText.getButton().setEnabled(enable);
    }

    private void clearFields() {
        this.osText.setValue(null, true);
        this.wsText.setValue(null, true);
        if (this.nlText != null) {
            this.nlText.setValue(null, true);
        }
        this.archText.setValue(null, true);
    }

    private void clearField(String property) {
        if (property.equals("os")) {
            this.osText.setValue(null, true);
        } else if (property.equals("ws")) {
            this.wsText.setValue(null, true);
        } else if (property.equals("arch")) {
            this.archText.setValue(null, true);
        }
    }

    public void refresh() {
        if (this.reactToSelections && this.currentInput == null) {
            this.clearFields();
            this.enableForInput(false);
            super.refresh();
            return;
        }
        this.enableForInput(true);
        this.setValue("os");
        this.setValue("ws");
        this.setValue("arch");
        if (this.nlText != null) {
            this.setValue("nl");
        }
        super.refresh();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.currentInput = (IStructuredSelection)selection;
            if (this.currentInput.isEmpty()) {
                this.currentInput = null;
            }
        } else {
            this.currentInput = null;
        }
        this.refresh();
    }

    public void cancelEdit() {
        this.osText.cancelEdit();
        this.wsText.cancelEdit();
        this.nlText.cancelEdit();
        this.archText.cancelEdit();
        super.cancelEdit();
    }

    static /* synthetic */ void access$2(PortabilitySection portabilitySection, FormEntry formEntry, Choice[] choiceArray) {
        portabilitySection.openPortabilityChoiceDialog(formEntry, choiceArray);
    }
}

