/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.KeyValueSourcePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.model.IDocumentRange;
import org.eclipse.pde.internal.ui.model.bundle.Bundle;
import org.eclipse.pde.internal.ui.model.bundle.BundleModel;
import org.eclipse.pde.internal.ui.model.bundle.ManifestHeader;
import org.eclipse.swt.graphics.Image;

public class BundleSourcePage
extends KeyValueSourcePage {
    public BundleSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected ILabelProvider createOutlineLabelProvider() {
        return new BundleLabelProvider();
    }

    protected ITreeContentProvider createOutlineContentProvider() {
        return new BundleOutlineContentProvider();
    }

    protected IDocumentRange getRangeElement(ITextSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        IBundleModel model = (IBundleModel)this.getInputContext().getModel();
        Dictionary manifest = ((Bundle)model.getBundle()).getHeaders();
        int offset = selection.getOffset();
        IDocumentRange[] keys = new IDocumentRange[manifest.size()];
        int i = 0;
        Enumeration elements = manifest.keys();
        while (elements.hasMoreElements()) {
            keys[i++] = (IDocumentRange)manifest.get(elements.nextElement());
        }
        IDocumentRange node = this.findBuildNode(keys, offset);
        return node;
    }

    private IDocumentRange findBuildNode(IDocumentRange[] nodes, int offset) {
        int i = 0;
        while (i < nodes.length) {
            IDocumentRange node = nodes[i];
            if (offset >= node.getOffset() && offset < node.getOffset() + node.getLength()) {
                return node;
            }
            ++i;
        }
        return null;
    }

    class BundleOutlineContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        BundleOutlineContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            return false;
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof BundleModel) {
                BundleModel model = (BundleModel)parent;
                Dictionary manifest = ((Bundle)model.getBundle()).getHeaders();
                Object[] keys = new Object[manifest.size()];
                int i = 0;
                Enumeration elements = manifest.keys();
                while (elements.hasMoreElements()) {
                    keys[i++] = manifest.get(elements.nextElement());
                }
                return keys;
            }
            return new Object[0];
        }
    }

    class BundleLabelProvider
    extends LabelProvider {
        BundleLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof ManifestHeader) {
                return ((ManifestHeader)obj).getName();
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof ManifestHeader) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_BUILD_VAR_OBJ);
            }
            return null;
        }
    }
}

