/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.io.File;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.IBuildObject;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.JarEntryFile;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.build.BuildInputContext;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.pde.internal.ui.editor.build.BuildSourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.editor.plugin.BundleSourcePage;
import org.eclipse.pde.internal.ui.editor.plugin.DependenciesPage;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionPointsPage;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionsPage;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestOutlinePage;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestSourcePage;
import org.eclipse.pde.internal.ui.editor.plugin.OverviewPage;
import org.eclipse.pde.internal.ui.editor.plugin.PluginInputContext;
import org.eclipse.pde.internal.ui.editor.plugin.PluginInputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.PluginUndoManager;
import org.eclipse.pde.internal.ui.editor.plugin.RuntimePage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class ManifestEditor
extends MultiSourceEditor {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        FileEditorInput in;
        IFile file = input.getFile();
        IProject project = file.getProject();
        IFile manifestFile = null;
        IFile buildFile = null;
        IFile pluginFile = null;
        boolean fragment = false;
        String name = file.getName().toLowerCase();
        if (name.equals("manifest.mf")) {
            manifestFile = file;
            buildFile = project.getFile("build.properties");
            pluginFile = this.createPluginFile(project);
        } else if (name.equals("build.properties")) {
            buildFile = file;
            pluginFile = this.createPluginFile(project);
            manifestFile = project.getFile("META-INF/MANIFEST.MF");
        } else if (name.equals("plugin.xml") || name.equals("fragment.xml")) {
            pluginFile = file;
            fragment = name.equals("fragment.xml");
            buildFile = project.getFile("build.properties");
            manifestFile = project.getFile("META-INF/MANIFEST.MF");
        }
        if (manifestFile.exists()) {
            in = new FileEditorInput(manifestFile);
            manager.putContext((IEditorInput)in, new BundleInputContext(this, (IEditorInput)in, file == manifestFile));
        }
        if (pluginFile.exists()) {
            in = new FileEditorInput(pluginFile);
            manager.putContext((IEditorInput)in, new PluginInputContext(this, (IEditorInput)in, file == pluginFile, fragment));
        }
        if (buildFile.exists()) {
            in = new FileEditorInput(buildFile);
            manager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, file == buildFile));
        }
        manager.monitorFile(manifestFile);
        manager.monitorFile(pluginFile);
        manager.monitorFile(buildFile);
    }

    protected InputContextManager createInputContextManager() {
        PluginInputContextManager manager = new PluginInputContextManager(this);
        manager.setUndoManager(new PluginUndoManager(this));
        return manager;
    }

    public void monitoredFileAdded(IFile file) {
        String name = file.getName();
        if (name.equalsIgnoreCase("MANIFEST.MF")) {
            if (!this.inputContextManager.hasContext("bundle-context")) {
                FileEditorInput in = new FileEditorInput(file);
                this.inputContextManager.putContext((IEditorInput)in, new BundleInputContext(this, (IEditorInput)in, false));
            }
        } else if (name.equalsIgnoreCase("plugin.xml")) {
            if (!this.inputContextManager.hasContext("plugin-context")) {
                FileEditorInput in = new FileEditorInput(file);
                this.inputContextManager.putContext((IEditorInput)in, new PluginInputContext(this, (IEditorInput)in, false, false));
            }
        } else if (name.equalsIgnoreCase("fragment.xml")) {
            if (!this.inputContextManager.hasContext("plugin-context")) {
                FileEditorInput in = new FileEditorInput(file);
                this.inputContextManager.putContext((IEditorInput)in, new PluginInputContext(this, (IEditorInput)in, false, true));
            }
        } else if (name.equalsIgnoreCase("build.properties") && !this.inputContextManager.hasContext("bundle-context")) {
            FileEditorInput in = new FileEditorInput(file);
            this.inputContextManager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, false));
        }
    }

    public void ensurePluginContextPresence() {
        if (this.inputContextManager.hasContext("plugin-context")) {
            return;
        }
        IProject project = this.inputContextManager.getCommonProject();
        IFile file = project.getFile("plugin.xml");
        WorkspacePluginModel model = new WorkspacePluginModel(file);
        IPluginBase pluginBase = model.getPluginBase(true);
        try {
            pluginBase.setSchemaVersion("3.0");
        }
        catch (CoreException coreException) {}
        model.save();
        FileEditorInput in = new FileEditorInput(file);
        this.inputContextManager.putContext((IEditorInput)in, new PluginInputContext(this, (IEditorInput)in, false, false));
    }

    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    public void contextAdded(InputContext context) {
        this.addSourcePage(context.getId());
        try {
            if (context.getId().equals("build")) {
                this.addPage((IFormPage)new BuildPage(this));
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    public void contextRemoved(InputContext context) {
        if (context.isPrimary()) {
            this.close(true);
            return;
        }
        IFormPage page = this.findPage(context.getId());
        if (page != null) {
            this.removePage(context.getId());
            if (context.getId().equals("build-context")) {
                this.removePage("build");
            }
        }
    }

    protected void createSystemFileContexts(InputContextManager manager, SystemFileEditorInput input) {
        SystemFileEditorInput in;
        File dir;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        File file = (File)input.getAdapter(clazz);
        File manifestFile = null;
        File buildFile = null;
        File pluginFile = null;
        String name = file.getName().toLowerCase();
        if (name.equals("manifest.mf")) {
            manifestFile = file;
            dir = file.getParentFile().getParentFile();
            buildFile = new File(dir, "build.properties");
            pluginFile = this.createPluginFile(dir);
        } else if (name.equals("build.properties")) {
            buildFile = file;
            dir = file.getParentFile();
            pluginFile = this.createPluginFile(dir);
            manifestFile = new File(dir, "META-INF/MANIFEST.MF");
        } else if (name.equals("plugin.xml") || name.equals("fragment.xml")) {
            pluginFile = file;
            dir = file.getParentFile();
            buildFile = new File(dir, "build.properties");
            manifestFile = new File(dir, "META-INF/MANIFEST.MF");
        }
        if (manifestFile.exists()) {
            in = new SystemFileEditorInput(manifestFile);
            manager.putContext((IEditorInput)in, new BundleInputContext(this, (IEditorInput)in, file == manifestFile));
        }
        if (pluginFile.exists()) {
            in = new SystemFileEditorInput(pluginFile);
            manager.putContext((IEditorInput)in, new PluginInputContext(this, (IEditorInput)in, file == pluginFile, name.equals("fragment.xml")));
        }
        if (buildFile.exists()) {
            in = new SystemFileEditorInput(buildFile);
            manager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, file == buildFile));
        }
    }

    private File createPluginFile(File dir) {
        File pluginFile = new File(dir, "plugin.xml");
        if (!pluginFile.exists()) {
            pluginFile = new File(dir, "fragment.xml");
        }
        return pluginFile;
    }

    private IFile createPluginFile(IProject project) {
        IFile pluginFile = project.getFile("plugin.xml");
        if (!pluginFile.exists()) {
            pluginFile = project.getFile("fragment.xml");
        }
        return pluginFile;
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        if (input instanceof JarEntryEditorInput) {
            this.createJarEntryContexts(manager, (JarEntryEditorInput)input);
            return;
        }
        String name = input.getName().toLowerCase();
        if (name.startsWith("manifest.mf")) {
            manager.putContext((IEditorInput)input, new BundleInputContext(this, (IEditorInput)input, true));
        } else if (name.startsWith("build.properties")) {
            manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
        } else if (name.startsWith("plugin.xml")) {
            manager.putContext((IEditorInput)input, new PluginInputContext(this, (IEditorInput)input, true, false));
        } else if (name.startsWith("fragment.xml")) {
            manager.putContext((IEditorInput)input, new PluginInputContext(this, (IEditorInput)input, true, true));
        }
    }

    protected void createJarEntryContexts(InputContextManager manager, JarEntryEditorInput input) {
        ZipFile zip;
        IStorage storage = input.getStorage();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.zip.ZipFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((zip = (ZipFile)storage.getAdapter((Class)clazz)) == null) {
            return;
        }
        if (zip.getEntry("META-INF/MANIFEST.MF") != null) {
            input = new JarEntryEditorInput(new JarEntryFile(zip, "META-INF/MANIFEST.MF"));
            manager.putContext((IEditorInput)input, new BundleInputContext(this, (IEditorInput)input, storage.getName().equals("MANIFEST.MF")));
        }
        if (zip.getEntry("plugin.xml") != null) {
            input = new JarEntryEditorInput(new JarEntryFile(zip, "plugin.xml"));
            manager.putContext((IEditorInput)input, new PluginInputContext(this, (IEditorInput)input, storage.getName().equals("plugin.xml"), false));
        } else if (zip.getEntry("fragment.xml") != null) {
            input = new JarEntryEditorInput(new JarEntryFile(zip, "fragment.xml"));
            manager.putContext((IEditorInput)input, new PluginInputContext(this, (IEditorInput)input, storage.getName().equals("fragment.xml"), true));
        }
        if (zip.getEntry("build.properties") != null) {
            input = new JarEntryEditorInput(new JarEntryFile(zip, "build.properties"));
            manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, storage.getName().equals("build.properties")));
        }
    }

    public boolean canCopy(ISelection selection) {
        return true;
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new OverviewPage(this));
            this.addPage((IFormPage)new DependenciesPage(this));
            this.addPage((IFormPage)new RuntimePage(this));
            this.addPage((IFormPage)new ExtensionsPage(this));
            this.addPage((IFormPage)new ExtensionPointsPage(this));
            if (this.inputContextManager.hasContext("build-context")) {
                this.addPage((IFormPage)new BuildPage(this));
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        this.addSourcePage("bundle-context");
        this.addSourcePage("plugin-context");
        this.addSourcePage("build-context");
    }

    protected String computeInitialPageId() {
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            InputContext primary = this.inputContextManager.getPrimaryContext();
            boolean isBundle = this.inputContextManager.hasContext("bundle-context");
            if (primary.getId().equals("build-context")) {
                firstPageId = "build";
            } else if (primary.getId().equals("plugin-context")) {
                firstPageId = isBundle ? "extensions" : "overview";
            }
            if (firstPageId == null) {
                firstPageId = "overview";
            }
        }
        return firstPageId;
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        if (contextId.equals("plugin-context")) {
            return new ManifestSourcePage(editor, title, name);
        }
        if (contextId.equals("build-context")) {
            return new BuildSourcePage(editor, title, name);
        }
        if (contextId.equals("bundle-context")) {
            return new BundleSourcePage(editor, title, name);
        }
        return super.createSourcePage(editor, title, name, contextId);
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new ManifestOutlinePage(this);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return null;
        }
        return super.getAdapter(key);
    }

    public static void openPluginEditor(String pluginId) {
        ManifestEditor.openPluginEditor(pluginId, null);
    }

    public static void openPluginEditor(String pluginId, Object object) {
        IPlugin pluginToOpen = PDECore.getDefault().findPlugin(pluginId);
        if (pluginToOpen != null) {
            ManifestEditor.openPluginEditor((IPluginBase)pluginToOpen, object);
        } else {
            Display.getCurrent().beep();
        }
    }

    public static IEditorPart openPluginEditor(IPluginBase plugin) {
        return ManifestEditor.openPluginEditor(plugin, null);
    }

    public static IEditorPart openPluginEditor(IPluginBase plugin, Object object) {
        ManifestEditor editor = null;
        IResource underlyingResource = plugin.getModel().getUnderlyingResource();
        editor = underlyingResource == null ? ManifestEditor.openExternalPlugin(plugin) : ManifestEditor.openWorkspacePlugin((IFile)underlyingResource, plugin instanceof IFragment);
        return editor;
    }

    private static IEditorPart openWorkspacePlugin(IFile pluginFile, boolean fragment) {
        String editorId = "org.eclipse.pde.ui.manifestEditor";
        try {
            FileEditorInput input = new FileEditorInput(pluginFile);
            return PDEPlugin.getActivePage().openEditor((IEditorInput)input, editorId);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
            return null;
        }
    }

    private static ManifestEditor openExternalPlugin(IPluginBase pluginInfo) {
        boolean isFragment = pluginInfo.getPluginModel().isFragmentModel();
        String manifest = null;
        Object input = null;
        File pluginLocation = new File(pluginInfo.getModel().getInstallLocation());
        if (pluginLocation.isFile() && pluginLocation.getName().endsWith(".jar")) {
            try {
                ZipFile zipFile = new ZipFile(pluginLocation);
                manifest = zipFile.getEntry("META-INF/MANIFEST.MF") != null ? "META-INF/MANIFEST.MF" : (isFragment ? "fragment.xml" : "plugin.xml");
                input = new JarEntryEditorInput(new JarEntryFile(zipFile, manifest));
            }
            catch (Exception exception) {}
        }
        if (input == null) {
            File file = new File(pluginLocation, "META-INF/MANIFEST.MF");
            if (!file.exists()) {
                file = new File(pluginLocation, isFragment ? "fragment.xml" : "plugin.xml");
            }
            if (file.exists()) {
                input = new SystemFileEditorInput(file);
            }
        }
        try {
            if (input != null) {
                return (ManifestEditor)PDEPlugin.getActivePage().openEditor(input, "org.eclipse.pde.ui.manifestEditor");
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        return null;
    }

    public String getTitle() {
        IPluginModelBase model = (IPluginModelBase)this.getAggregateModel();
        if (model == null || !model.isValid()) {
            return super.getTitle();
        }
        String text = this.getTitleText(model.getPluginBase());
        if (text == null) {
            return super.getTitle();
        }
        return model.getResourceString(text);
    }

    public String getTitleProperty() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        String pref = store.getString("Preferences.MainPage.showObjects");
        if (pref != null && pref.equals("useNames")) {
            return "name";
        }
        return "id";
    }

    private String getTitleText(IPluginBase pluginBase) {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        String pref = store.getString("Preferences.MainPage.showObjects");
        if (pref != null && pref.equals("useNames")) {
            return pluginBase.getName();
        }
        return pluginBase.getId();
    }

    protected InputContext getInputContext(Object object) {
        InputContext context = null;
        if (object instanceof IBuildObject) {
            context = this.inputContextManager.findContext("build-context");
        } else if (object instanceof IPluginExtensionPoint || object instanceof IPluginExtension) {
            context = this.inputContextManager.findContext("plugin-context");
        } else {
            context = this.inputContextManager.findContext("bundle-context");
            if (context == null) {
                context = this.inputContextManager.findContext("plugin-context");
            }
        }
        return context;
    }
}

