/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.action.Action;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;

public class NewElementAction
extends Action {
    public static final String UNKNOWN_ELEMENT_TAG = PDEPlugin.getResourceString("NewElementAction.generic");
    private ISchemaElement elementInfo;
    private Hashtable counters = PDEPlugin.getDefault().getDefaultNameCounters();
    private IPluginParent parent;
    private IProject project;

    public NewElementAction(ISchemaElement elementInfo, IPluginParent parent) {
        this.elementInfo = elementInfo;
        this.parent = parent;
        this.setText(this.getElementName());
        this.setImageDescriptor(PDEPluginImages.DESC_GENERIC_XML_OBJ);
        IResource resource = parent.getModel().getUnderlyingResource();
        if (resource != null) {
            this.project = resource.getProject();
        }
        this.setEnabled(parent.getModel().isEditable());
    }

    public String createDefaultClassName(ISchemaAttribute attInfo, int counter) {
        String tag = attInfo.getParent().getName();
        String expectedType = attInfo.getBasedOn();
        String className = "";
        if (expectedType == null) {
            StringBuffer buf = new StringBuffer(tag);
            buf.setCharAt(0, Character.toUpperCase(tag.charAt(0)));
            className = buf.toString();
        } else {
            className = expectedType;
            int dotLoc = className.lastIndexOf(46);
            if (dotLoc != -1) {
                className = className.substring(dotLoc + 1);
            }
            if (className.length() > 2 && className.charAt(0) == 'I' && Character.isUpperCase(className.charAt(1))) {
                className = className.substring(1);
            }
        }
        String packageName = this.createDefaultPackageName(this.project.getName(), className);
        className = String.valueOf(className) + counter;
        return String.valueOf(packageName) + "." + className;
    }

    public String createDefaultName(ISchemaAttribute attInfo, int counter) {
        if (attInfo.getType().getName().equals("boolean")) {
            return "true";
        }
        String tag = attInfo.getParent().getName();
        return String.valueOf(this.project.getName()) + "." + tag + counter;
    }

    private String getCounterKey(ISchemaElement elementInfo) {
        return String.valueOf(elementInfo.getSchema().getQualifiedPointId()) + "." + elementInfo.getName();
    }

    private String getElementName() {
        return this.elementInfo != null ? this.elementInfo.getName() : UNKNOWN_ELEMENT_TAG;
    }

    private void initializeAttribute(IPluginElement element, ISchemaAttribute attInfo, int counter) throws CoreException {
        String value = null;
        value = attInfo.getKind() == 1 ? this.createDefaultClassName(attInfo, counter) : (attInfo.getUse() == 2 && attInfo.getValue() != null ? attInfo.getValue().toString() : (attInfo.getType().getRestriction() != null ? attInfo.getType().getRestriction().getChildren()[0].toString() : this.createDefaultName(attInfo, counter)));
        element.setAttribute(attInfo.getName(), value);
    }

    private void initializeAttributes(IPluginElement element) throws CoreException {
        ISchemaElement elementInfo = (ISchemaElement)element.getElementInfo();
        if (elementInfo == null) {
            return;
        }
        String counterKey = this.getCounterKey(elementInfo);
        Integer counter = (Integer)this.counters.get(counterKey);
        counter = counter == null ? new Integer(1) : new Integer(counter + 1);
        this.counters.put(counterKey, counter);
        ISchemaAttribute[] attributes = elementInfo.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            ISchemaAttribute attInfo = attributes[i];
            if (attInfo.getUse() == 1 || attInfo.getUse() == 2) {
                this.initializeAttribute(element, attInfo, counter);
            }
            ++i;
        }
    }

    public void run() {
        IPluginElement newElement = this.parent.getModel().getFactory().createElement((IPluginObject)this.parent);
        try {
            newElement.setName(this.getElementName());
            this.initializeAttributes(newElement);
            this.parent.add((IPluginObject)newElement);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public String createDefaultPackageName(String id, String className) {
        IStatus status;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < id.length()) {
            char ch = id.charAt(i);
            if (buffer.length() == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
            } else if (Character.isJavaIdentifierPart(ch)) {
                buffer.append(ch);
            } else if (ch == '.') {
                status = JavaConventions.validatePackageName((String)buffer.toString());
                if (status.getSeverity() == 4) {
                    buffer.append(className.toLowerCase());
                }
                buffer.append(ch);
            }
            ++i;
        }
        status = JavaConventions.validatePackageName((String)buffer.toString());
        if (status.getSeverity() == 4) {
            buffer.append(className.toLowerCase());
        }
        return buffer.toString();
    }
}

