/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class PackageSelectionDialog
extends ElementListSelectionDialog {
    public static final String PACKAGE_MESSAGE = "PackageSelectionDialog.label";

    public PackageSelectionDialog(Shell parent, ILabelProvider renderer, IJavaProject jProject) {
        this(parent, renderer, jProject, new Vector());
    }

    public PackageSelectionDialog(Shell parent, ILabelProvider renderer, IJavaProject jProject, Vector existingPackages) {
        super(parent, renderer);
        this.setElements(jProject, existingPackages);
        this.setMultipleSelection(true);
        this.setMessage(PDEPlugin.getResourceString(PACKAGE_MESSAGE));
    }

    private void setElements(IJavaProject jProject, Vector existingPackages) {
        HashMap<String, IPackageFragment> map = new HashMap<String, IPackageFragment>();
        try {
            IPackageFragmentRoot[] roots = this.getRoots(jProject);
            int i = 0;
            while (i < roots.length) {
                IJavaElement[] children = roots[i].getChildren();
                int j = 0;
                while (j < children.length) {
                    IPackageFragment fragment = (IPackageFragment)children[j];
                    if (fragment.hasChildren() && !existingPackages.contains(fragment.getElementName())) {
                        map.put(fragment.getElementName(), fragment);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        this.setElements(map.values().toArray());
    }

    private IPackageFragmentRoot[] getRoots(IJavaProject jProject) {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        try {
            IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1 || roots[i].isArchive() && !roots[i].isExternal()) {
                    result.add(roots[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.getShell().setText(PDEPlugin.getResourceString("PackageSelectionDialog.title"));
        return control;
    }
}

