/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.wizards.ResizableWizardDialog;
import org.eclipse.pde.internal.ui.wizards.exports.PluginExportWizard;
import org.eclipse.ui.PlatformUI;

public class PluginExportAction
extends Action {
    private PDEFormEditor fEditor;

    public PluginExportAction(PDEFormEditor editor) {
        this.fEditor = editor;
    }

    public PluginExportAction() {
    }

    private void ensureContentSaved() {
        if (this.fEditor.isDirty()) {
            try {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        PluginExportAction.this.fEditor.doSave(monitor);
                    }
                };
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void run() {
        if (this.fEditor != null) {
            this.ensureContentSaved();
        }
        PluginExportWizard wizard = new PluginExportWizard();
        IResource resource = null;
        if (this.fEditor != null) {
            resource = ((IModel)this.fEditor.getAggregateModel()).getUnderlyingResource();
        }
        StructuredSelection selection = resource != null ? new StructuredSelection((Object)resource) : new StructuredSelection();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        ResizableWizardDialog wd = new ResizableWizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        wd.create();
        int result = wd.open();
        this.notifyResult(result == 0);
    }
}

