/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.plugin.DependenciesPage;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.search.dependencies.UnusedDependenciesAction;
import org.eclipse.pde.internal.ui.wizards.PluginSelectionDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class RequiresSection
extends TableSection
implements IModelChangedListener,
IModelProviderListener {
    private TableViewer importTable;
    private Vector imports;
    private Action openAction;
    private Action newAction;
    private Action deleteAction;
    private Action buildpathAction;

    public RequiresSection(DependenciesPage page, Composite parent) {
        String[] stringArray = new String[4];
        stringArray[0] = PDEPlugin.getResourceString("RequiresSection.add");
        stringArray[2] = PDEPlugin.getResourceString("RequiresSection.up");
        stringArray[3] = PDEPlugin.getResourceString("RequiresSection.down");
        super((PDEFormPage)page, parent, 128, stringArray);
        this.getSection().setText(PDEPlugin.getResourceString("RequiresSection.title"));
        boolean fragment = ((IPluginModelBase)this.getPage().getModel()).isFragmentModel();
        if (fragment) {
            this.getSection().setDescription(PDEPlugin.getResourceString("RequiresSection.fDesc"));
        } else {
            this.getSection().setDescription(PDEPlugin.getResourceString("RequiresSection.desc"));
        }
        this.getTablePart().setEditable(false);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 4, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.importTable = tablePart.getTableViewer();
        this.importTable.setContentProvider((IContentProvider)new ImportContentProvider());
        this.importTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        toolkit.paintBordersFor(container);
        this.makeActions();
        section.setClient((Control)container);
        this.initialize();
    }

    protected void selectionChanged(IStructuredSelection sel) {
        this.getPage().getPDEEditor().setSelection((ISelection)sel);
        if (this.getPage().getModel().isEditable()) {
            this.updateDirectionalButtons();
        }
    }

    private void updateDirectionalButtons() {
        Table table = this.getTablePart().getTableViewer().getTable();
        TableItem[] selection = table.getSelection();
        boolean hasSelection = selection.length > 0;
        boolean canMove = table.getItemCount() > 1;
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(2, canMove && hasSelection && table.getSelectionIndex() > 0);
        tablePart.setButtonEnabled(3, canMove && hasSelection && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    protected void handleDoubleClick(IStructuredSelection sel) {
        this.handleOpen((ISelection)sel);
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                break;
            }
            case 2: {
                this.handleUp();
                break;
            }
            case 3: {
                this.handleDown();
            }
        }
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        PDECore.getDefault().getWorkspaceModelManager().removeModelProviderListener((IModelProviderListener)this);
        PDECore.getDefault().getExternalModelManager().removeModelProviderListener((IModelProviderListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    protected void doPaste() {
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IPluginImport) {
            ImportObject iobj = new ImportObject((IPluginImport)object);
            this.importTable.setSelection((ISelection)new StructuredSelection((Object)iobj), true);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.importTable.getSelection();
        manager.add((IAction)this.newAction);
        if (!selection.isEmpty()) {
            manager.add((IAction)this.openAction);
        }
        manager.add((IContributionItem)new Separator());
        this.getPage().contextMenuAboutToShow(manager);
        if (!selection.isEmpty()) {
            manager.add((IAction)this.deleteAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
        actionGroup.setContext(new ActionContext(selection));
        actionGroup.fillContextMenu(manager);
        if (((IModel)this.getPage().getModel()).getUnderlyingResource() != null) {
            manager.add((IAction)new UnusedDependenciesAction((IPluginModelBase)this.getPage().getModel(), false));
        }
    }

    private void handleOpen(ISelection sel) {
        IStructuredSelection ssel;
        if (sel instanceof IStructuredSelection && (ssel = (IStructuredSelection)sel).size() == 1) {
            this.handleOpen(ssel.getFirstElement());
        }
    }

    private void handleOpen(Object obj) {
        IPlugin plugin;
        if (obj instanceof ImportObject && (plugin = ((ImportObject)obj).getPlugin()) != null) {
            ManifestEditor.openPluginEditor((IPluginBase)plugin);
        }
    }

    private void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.importTable.getSelection();
        if (ssel.isEmpty()) {
            return;
        }
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        IPluginBase pluginBase = model.getPluginBase();
        try {
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                ImportObject iobj = (ImportObject)iter.next();
                pluginBase.remove(iobj.getImport());
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.refresh();
    }

    private void handleNew() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        PluginSelectionDialog dialog = new PluginSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), this.getAvailablePlugins(model), true);
        dialog.create();
        if (dialog.open() == 0) {
            Object[] models = dialog.getResult();
            int i = 0;
            while (i < models.length) {
                try {
                    IPluginModel candidate = (IPluginModel)models[i];
                    IPluginImport importNode = model.getPluginFactory().createImport();
                    importNode.setId(candidate.getPlugin().getId());
                    model.getPluginBase().add(importNode);
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
    }

    private void handleUp() {
        int index = this.getTablePart().getTableViewer().getTable().getSelectionIndex();
        if (index < 1) {
            return;
        }
        this.swap(index, index - 1);
    }

    private void handleDown() {
        Table table = this.getTablePart().getTableViewer().getTable();
        int index = table.getSelectionIndex();
        if (index == table.getItemCount() - 1) {
            return;
        }
        this.swap(index, index + 1);
    }

    public void swap(int index1, int index2) {
        Table table = this.getTablePart().getTableViewer().getTable();
        IPluginImport dep1 = ((ImportObject)table.getItem(index1).getData()).getImport();
        IPluginImport dep2 = ((ImportObject)table.getItem(index2).getData()).getImport();
        try {
            IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
            IPluginBase pluginBase = model.getPluginBase();
            pluginBase.swap(dep1, dep2);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private IPluginModelBase[] getAvailablePlugins(IPluginModelBase model) {
        IPluginModel[] plugins = PDECore.getDefault().getModelManager().getPluginsOnly();
        HashSet existingImports = PluginSelectionDialog.getExistingImports(model.getPluginBase());
        ArrayList<IPluginModel> result = new ArrayList<IPluginModel>();
        int i = 0;
        while (i < plugins.length) {
            if (!existingImports.contains(plugins[i].getPluginBase().getId())) {
                result.add(plugins[i]);
            }
            ++i;
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public void initialize() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        this.importTable.setInput((Object)model.getPluginBase());
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        this.getTablePart().setButtonEnabled(2, false);
        this.getTablePart().setButtonEnabled(3, false);
        model.addModelChangedListener((IModelChangedListener)this);
        PDECore.getDefault().getWorkspaceModelManager().addModelProviderListener((IModelProviderListener)this);
        PDECore.getDefault().getExternalModelManager().addModelProviderListener((IModelProviderListener)this);
        this.newAction.setEnabled(model.isEditable());
        this.deleteAction.setEnabled(model.isEditable());
        this.buildpathAction.setEnabled(model.isEditable());
    }

    private void makeActions() {
        this.newAction = new Action(PDEPlugin.getResourceString("RequiresSection.add")){

            public void run() {
                RequiresSection.this.handleNew();
            }
        };
        this.openAction = new Action(PDEPlugin.getResourceString("RequiresSection.open")){

            public void run() {
                RequiresSection.this.handleOpen(RequiresSection.this.importTable.getSelection());
            }
        };
        this.deleteAction = new Action(PDEPlugin.getResourceString("RequiresSection.delete")){

            public void run() {
                RequiresSection.this.handleDelete();
            }
        };
        this.buildpathAction = new Action(PDEPlugin.getResourceString("RequiresSection.compute")){

            public void run() {
                IBaseModel model = RequiresSection.this.getPage().getModel();
                if (model instanceof IPluginModelBase) {
                    RequiresSection.this.computeBuildPath((IPluginModelBase)model, true);
                }
            }
        };
    }

    public void refresh() {
        this.imports = null;
        this.importTable.refresh();
        super.refresh();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        if (event.getChangedProperty() == "import_order") {
            this.refresh();
            this.updateDirectionalButtons();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IPluginImport) {
            IPluginImport iimport = (IPluginImport)changeObject;
            if (event.getChangeType() == 1) {
                ImportObject iobj = new ImportObject(iimport);
                this.imports.add(iobj);
                this.importTable.add((Object)iobj);
                this.importTable.setSelection((ISelection)new StructuredSelection((Object)iobj), true);
                this.importTable.getTable().setFocus();
            } else {
                ImportObject iobj = this.findImportObject(iimport);
                if (iobj != null) {
                    if (event.getChangeType() == 2) {
                        this.imports.remove(iobj);
                        this.importTable.remove((Object)iobj);
                    } else {
                        this.importTable.update((Object)iobj, null);
                    }
                }
            }
        } else {
            this.importTable.update(((IStructuredSelection)this.importTable.getSelection()).toArray(), null);
        }
    }

    public void modelsChanged(IModelProviderEvent e) {
        this.imports = null;
        final Control control = this.importTable.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!control.isDisposed()) {
                        RequiresSection.this.importTable.refresh();
                    }
                }
            });
        }
    }

    private ImportObject findImportObject(IPluginImport iimport) {
        if (this.imports == null) {
            return null;
        }
        int i = 0;
        while (i < this.imports.size()) {
            ImportObject iobj = (ImportObject)this.imports.get(i);
            if (iobj.getImport().equals(iimport)) {
                return iobj;
            }
            ++i;
        }
        return null;
    }

    private void computeBuildPath(final IPluginModelBase model, final boolean save) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                monitor.beginTask(PDEPlugin.getResourceString("RequiresSection.update"), 1);
                try {
                    try {
                        if (save && RequiresSection.this.getPage().getEditor().isDirty()) {
                            RequiresSection.this.getPage().getEditor().doSave(monitor);
                        }
                        ClasspathUtilCore.setClasspath((IPluginModelBase)model, (IProgressMonitor)monitor);
                        monitor.worked(1);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
        }
        catch (InterruptedException e) {
            PDEPlugin.logException(e);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e.getTargetException());
        }
    }

    public void setFocus() {
        if (this.importTable != null) {
            this.importTable.getTable().setFocus();
        }
    }

    Action getBuildpathAction() {
        return this.buildpathAction;
    }

    class ImportContentProvider
    extends DefaultTableProvider {
        ImportContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (RequiresSection.this.imports == null) {
                this.createImportObjects();
            }
            return RequiresSection.this.imports.toArray();
        }

        private void createImportObjects() {
            RequiresSection.this.imports = new Vector();
            IPluginModelBase model = (IPluginModelBase)RequiresSection.this.getPage().getModel();
            IPluginImport[] iimports = model.getPluginBase().getImports();
            int i = 0;
            while (i < iimports.length) {
                IPluginImport iimport = iimports[i];
                RequiresSection.this.imports.add(new ImportObject(iimport));
                ++i;
            }
        }
    }
}

