/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.BasicLauncherTab;
import org.eclipse.pde.internal.ui.launcher.JUnitLaunchConfiguration;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class JUnitArgumentsTab
extends BasicLauncherTab {
    protected String getApplicationAttribute() {
        return "testApplication";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("location0", LauncherUtils.getDefaultPath().append("runtime-test-workspace").toOSString());
        config.setAttribute("clearws", true);
        config.setAttribute("askclear", false);
        config.setAttribute("progargs", "");
        config.setAttribute("vmargs", "");
        config.setAttribute("bootstrap", "");
        if (!JUnitLaunchConfiguration.requiresUI((ILaunchConfiguration)config)) {
            config.setAttribute("application", "org.eclipse.pde.junit.runtime.coretestapplication");
        }
    }

    protected String[] getApplicationNames() {
        TreeSet<String> result = new TreeSet<String>();
        result.add(PDEPlugin.getResourceString("JUnitArgumentsTab.headless"));
        IPluginModelBase[] plugins = PDECore.getDefault().getModelManager().getPlugins();
        int i = 0;
        while (i < plugins.length) {
            IPluginExtension[] extensions = plugins[i].getPluginBase().getExtensions();
            int j = 0;
            while (j < extensions.length) {
                String id;
                String point = extensions[j].getPoint();
                if (point != null && point.equals("org.eclipse.core.runtime.applications") && (id = String.valueOf(extensions[j].getPluginBase().getId()) + "." + extensions[j].getId()) != null && !id.startsWith("org.eclipse.pde.junit.runtime")) {
                    result.add(id);
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    protected void initializeApplicationSection(ILaunchConfiguration config) throws CoreException {
        String application = config.getAttribute("application", null);
        if ("org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
            this.fApplicationCombo.setText(PDEPlugin.getResourceString("JUnitArgumentsTab.headless"));
        } else {
            super.initializeApplicationSection(config);
        }
    }

    protected void saveApplicationSection(ILaunchConfigurationWorkingCopy config) {
        if (this.fApplicationCombo.getText().equals(PDEPlugin.getResourceString("JUnitArgumentsTab.headless"))) {
            config.setAttribute("application", "org.eclipse.pde.junit.runtime.coretestapplication");
            config.setAttribute("testApplication", null);
        } else {
            config.setAttribute("application", null);
            super.saveApplicationSection(config);
        }
    }
}

