/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.model.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.ui.model.DocumentTextNode;
import org.eclipse.pde.internal.ui.model.IDocumentAttribute;
import org.eclipse.pde.internal.ui.model.IDocumentNode;
import org.eclipse.pde.internal.ui.model.IDocumentTextNode;
import org.eclipse.pde.internal.ui.model.plugin.PluginParentNode;

public class PluginElementNode
extends PluginParentNode
implements IPluginElement {
    private static final long serialVersionUID = 1L;
    private transient ISchemaElement elementInfo;

    public IPluginElement createCopy() {
        return null;
    }

    public IPluginAttribute getAttribute(String name) {
        return (IPluginAttribute)this.fAttributes.get(name);
    }

    public IPluginAttribute[] getAttributes() {
        return this.fAttributes.values().toArray(new IPluginAttribute[this.fAttributes.size()]);
    }

    public int getAttributeCount() {
        return this.fAttributes.size();
    }

    public String getText() {
        IDocumentTextNode node = this.getTextNode();
        return node == null ? "" : node.getText();
    }

    public void setAttribute(String name, String value) throws CoreException {
        this.setXMLAttribute(name, value);
    }

    public void setText(String text) throws CoreException {
        IDocumentTextNode node = this.getTextNode();
        if (node == null) {
            node = new DocumentTextNode();
            node.setEnclosingElement(this);
            this.addTextNode(node);
        }
        node.setText(text);
        this.firePropertyChanged(this, "text", node, node);
    }

    public String write(boolean indent) {
        String sep = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        if (indent) {
            buffer.append(this.getIndent());
        }
        IDocumentNode[] children = this.getChildNodes();
        String text = this.getText();
        if (children.length > 0 || text.length() > 0) {
            buffer.append(String.valueOf(this.writeShallow(false)) + sep);
            if (text.length() > 0) {
                buffer.append(String.valueOf(this.getIndent()) + "   " + text + sep);
            }
            int i = 0;
            while (i < children.length) {
                children[i].setLineIndent(this.getLineIndent() + 3);
                buffer.append(String.valueOf(children[i].write(true)) + sep);
                ++i;
            }
            buffer.append(String.valueOf(this.getIndent()) + "</" + this.getXMLTagName() + ">");
        } else {
            buffer.append(this.writeShallow(true));
        }
        return buffer.toString();
    }

    public String writeShallow(boolean terminate) {
        String sep = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer("<" + this.getXMLTagName());
        IDocumentAttribute[] attrs = this.getNodeAttributes();
        if (attrs.length == 1) {
            if (attrs[0].getAttributeValue().length() > 0) {
                buffer.append(" " + attrs[0].write());
            }
        } else {
            int i = 0;
            while (i < attrs.length) {
                if (attrs[i].getAttributeValue().length() > 0) {
                    buffer.append(String.valueOf(sep) + this.getIndent() + "      " + attrs[i].write());
                }
                ++i;
            }
        }
        if (terminate) {
            buffer.append("/");
        }
        buffer.append(">");
        return buffer.toString();
    }

    public String getName() {
        return this.getXMLTagName();
    }

    public void setName(String name) throws CoreException {
        this.setXMLTagName(name);
    }

    public Object getElementInfo() {
        if (this.elementInfo == null) {
            IPluginExtension extension;
            ISchema schema;
            IDocumentNode node;
            for (node = this.getParentNode(); node != null && !(node instanceof IPluginExtension); node = node.getParentNode()) {
            }
            if (node != null && (schema = (ISchema)(extension = (IPluginExtension)node).getSchema()) != null) {
                this.elementInfo = schema.findElement(this.getName());
            }
        }
        return this.elementInfo;
    }
}

