/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.EclipseHomeInitializer;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.ModelProviderEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.preferences.TargetPlatformPreferencePage;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ExternalPluginsBlock {
    private CheckboxTableViewer pluginListViewer;
    private TargetPlatformPreferencePage page;
    private static final String KEY_RELOAD = "ExternalPluginsBlock.reload";
    private static final String KEY_WORKSPACE = "ExternalPluginsBlock.workspace";
    private boolean reloaded;
    private TablePart tablePart;
    private HashSet changed = new HashSet();
    private IPluginModelBase[] initialModels;
    private IPluginModelBase[] fModels;
    private PDEState fCurrentState;
    private Button fIncludeFragments;

    public ExternalPluginsBlock(TargetPlatformPreferencePage page) {
        this.page = page;
        String[] stringArray = new String[8];
        stringArray[0] = PDEPlugin.getResourceString(KEY_RELOAD);
        stringArray[3] = PDEPlugin.getResourceString("WizardCheckboxTablePart.selectAll");
        stringArray[4] = PDEPlugin.getResourceString("WizardCheckboxTablePart.deselectAll");
        stringArray[5] = PDEPlugin.getResourceString("ExternalPluginsBlock.workingSet");
        stringArray[6] = PDEPlugin.getResourceString("ExternalPluginsBlock.addRequired");
        stringArray[7] = PDEPlugin.getResourceString(KEY_WORKSPACE);
        String[] buttonLabels = stringArray;
        this.tablePart = new TablePart(buttonLabels);
        this.tablePart.setSelectAllIndex(3);
        this.tablePart.setDeselectAllIndex(4);
        PDEPlugin.getDefault().getLabelProvider().connect(this);
    }

    void computeDelta() {
        int type = 0;
        IModel[] addedArray = null;
        IModel[] removedArray = null;
        IModel[] changedArray = null;
        if (this.reloaded) {
            type = 3;
            removedArray = this.initialModels;
            addedArray = this.getAllModels();
        } else if (this.changed.size() > 0) {
            type |= 4;
            changedArray = this.changed.toArray(new IModel[this.changed.size()]);
        }
        this.changed.clear();
        if (type != 0) {
            ExternalModelManager registry = PDECore.getDefault().getExternalModelManager();
            ModelProviderEvent event = new ModelProviderEvent((Object)registry, type, addedArray, removedArray, changedArray);
            registry.fireModelProviderEvent((IModelProviderEvent)event);
        }
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.tablePart.createControl(container);
        this.pluginListViewer = this.tablePart.getTableViewer();
        this.pluginListViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        GridData gd = (GridData)this.tablePart.getControl().getLayoutData();
        gd.heightHint = 100;
        Label label = new Label(container, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fIncludeFragments = new Button(container, 32);
        this.fIncludeFragments.setText(PDEPlugin.getResourceString("ExternalPluginsBlock.includeFragments"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fIncludeFragments.setLayoutData((Object)gd);
        this.fIncludeFragments.setSelection(PDECore.getDefault().getPluginPreferences().getBoolean("includeFragments"));
        return container;
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    private IPluginModelBase[] getAllModels() {
        if (this.fModels == null) {
            this.initialModels = PDECore.getDefault().getExternalModelManager().getAllModels();
            return this.initialModels;
        }
        return this.fModels;
    }

    protected void handleReload() {
        String platformPath = this.page.getPlatformPath();
        if (platformPath != null && platformPath.length() > 0) {
            URL[] pluginPaths = PluginPathFinder.getPluginPaths((String)platformPath);
            ReloadOperation op = new ReloadOperation(pluginPaths);
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            this.pluginListViewer.setInput((Object)PDECore.getDefault().getExternalModelManager());
            this.changed.clear();
            this.handleSelectAll(true);
            this.reloaded = true;
        }
        this.page.resetNeedsReload();
    }

    public void initialize() {
        String platformPath = this.page.getPlatformPath();
        if (platformPath != null && platformPath.length() == 0) {
            return;
        }
        this.pluginListViewer.setInput((Object)PDECore.getDefault().getExternalModelManager());
        IPluginModelBase[] allModels = this.getAllModels();
        Vector<IPluginModelBase> selection = new Vector<IPluginModelBase>();
        int i = 0;
        while (i < allModels.length) {
            IPluginModelBase model = allModels[i];
            if (model.isEnabled()) {
                selection.add(model);
            }
            ++i;
        }
        this.tablePart.setSelection(selection.toArray());
    }

    public void save() {
        BusyIndicator.showWhile((Display)this.page.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ExternalPluginsBlock.this.savePreferences();
                if (ExternalPluginsBlock.this.reloaded) {
                    EclipseHomeInitializer.resetEclipseHomeVariable();
                }
                ExternalPluginsBlock.this.updateModels();
                ExternalPluginsBlock.this.computeDelta();
            }
        });
    }

    private void savePreferences() {
        Path defaultPath;
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        Path newPath = new Path(this.page.getPlatformPath());
        String mode = ExternalModelManager.arePathsEqual((IPath)newPath, (IPath)(defaultPath = new Path(ExternalModelManager.computeDefaultPlatformPath()))) ? "useThis" : "useOther";
        preferences.setValue("target_mode", mode);
        preferences.setValue("platform_path", this.page.getPlatformPath());
        String[] locations = this.page.getPlatformLocations();
        int i = 0;
        while (i < locations.length && i < 5) {
            preferences.setValue("saved_platform" + i, locations[i]);
            ++i;
        }
        preferences.setValue("includeFragments", this.fIncludeFragments.getSelection());
        PDECore.getDefault().savePluginPreferences();
    }

    private void updateModels() {
        Iterator iter = this.changed.iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            model.setEnabled(this.tablePart.getTableViewer().getChecked((Object)model));
        }
        if (this.reloaded) {
            PDECore.getDefault().getExternalModelManager().reset(this.fCurrentState, this.fModels);
        }
    }

    private void selectNotInWorkspace() {
        WorkspaceModelManager wm = PDECore.getDefault().getWorkspaceModelManager();
        IPluginModelBase[] wsModels = wm.getAllModels();
        IPluginModelBase[] exModels = this.getAllModels();
        Vector<IPluginModelBase> selected = new Vector<IPluginModelBase>();
        int i = 0;
        while (i < exModels.length) {
            IPluginModelBase exModel = exModels[i];
            boolean inWorkspace = false;
            int j = 0;
            while (j < wsModels.length) {
                IPluginModelBase wsModel = wsModels[j];
                String extId = exModel.getPluginBase().getId();
                String wsId = wsModel.getPluginBase().getId();
                if (extId != null && wsId != null && extId.equals(wsId)) {
                    inWorkspace = true;
                    break;
                }
                ++j;
            }
            if (!inWorkspace) {
                selected.add(exModel);
            }
            if (exModel.isEnabled() == inWorkspace) {
                this.changed.add(exModel);
            } else if (this.changed.contains(exModel)) {
                this.changed.remove(exModel);
            }
            ++i;
        }
        this.tablePart.setSelection(selected.toArray());
    }

    public void handleSelectAll(boolean selected) {
        this.tablePart.selectAll(selected);
    }

    private void handleWorkingSets() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(this.tablePart.getControl().getShell(), true);
        if (dialog.open() == 0) {
            HashSet set = this.getPluginIDs(dialog.getSelection());
            IPluginModelBase[] models = this.getAllModels();
            int counter = 0;
            int i = 0;
            while (i < models.length) {
                String id = models[i].getPluginBase().getId();
                if (id != null) {
                    if (set.contains(id)) {
                        if (!this.pluginListViewer.getChecked((Object)models[i])) {
                            this.pluginListViewer.setChecked((Object)models[i], true);
                            ++counter;
                            if (!models[i].isEnabled()) {
                                this.changed.add(models[i]);
                            }
                        }
                        set.remove(id);
                    }
                    if (set.isEmpty()) break;
                }
                ++i;
            }
            this.tablePart.incrementCounter(counter);
        }
    }

    private HashSet getPluginIDs(IWorkingSet[] workingSets) {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < workingSets.length) {
            IAdaptable[] elements = workingSets[i].getElements();
            int j = 0;
            while (j < elements.length) {
                IAdaptable element = elements[j];
                if (element instanceof PersistablePluginObject) {
                    set.add(((PersistablePluginObject)element).getPluginID());
                } else {
                    IPluginModelBase model;
                    if (element instanceof IJavaProject) {
                        element = ((IJavaProject)element).getProject();
                    }
                    if (element instanceof IProject && (model = PDECore.getDefault().getWorkspaceModelManager().getWorkspacePluginModel((IProject)element)) != null) {
                        set.add(model.getPluginBase().getId());
                    }
                }
                ++j;
            }
            ++i;
        }
        return set;
    }

    private void handleAddRequired() {
        TableItem[] items = this.tablePart.getTableViewer().getTable().getItems();
        if (items.length == 0) {
            return;
        }
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < items.length) {
            IPluginModelBase model = (IPluginModelBase)items[i].getData();
            if (this.tablePart.getTableViewer().getChecked((Object)model)) {
                this.addPluginAndDependencies((IPluginModelBase)items[i].getData(), result);
            }
            ++i;
        }
        this.tablePart.setSelection(result.toArray());
    }

    protected void addPluginAndDependencies(IPluginModelBase model, ArrayList selected) {
        if (!selected.contains(model)) {
            selected.add(model);
            if (!model.isEnabled()) {
                this.changed.add(model);
            }
            this.addDependencies(this.getAllModels(), model, selected);
        }
    }

    protected void addDependencies(IPluginModelBase[] models, IPluginModelBase model, ArrayList selected) {
        IPluginModelBase found;
        IPluginImport[] required = model.getPluginBase().getImports();
        if (required.length > 0) {
            int i = 0;
            while (i < required.length) {
                found = this.findModel(models, required[i].getId());
                if (found != null) {
                    this.addPluginAndDependencies(found, selected);
                }
                ++i;
            }
        }
        if (model instanceof IPluginModel) {
            int i;
            boolean addFragments = this.fIncludeFragments.getSelection();
            if (!addFragments) {
                IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
                i = 0;
                while (i < libraries.length) {
                    if (ClasspathUtilCore.containsVariables((String)libraries[i].getName())) {
                        addFragments = true;
                        break;
                    }
                    ++i;
                }
            }
            if (addFragments) {
                IFragmentModel[] fragments = this.findFragments(models, ((IPluginModel)model).getPlugin());
                i = 0;
                while (i < fragments.length) {
                    this.addPluginAndDependencies((IPluginModelBase)fragments[i], selected);
                    ++i;
                }
            }
        } else {
            IFragment fragment = ((IFragmentModel)model).getFragment();
            found = this.findModel(models, fragment.getPluginId());
            if (found != null) {
                this.addPluginAndDependencies(found, selected);
            }
        }
    }

    private IPluginModelBase findModel(IPluginModelBase[] models, String id) {
        int i = 0;
        while (i < models.length) {
            String modelId = models[i].getPluginBase().getId();
            if (modelId != null && modelId.equals(id)) {
                return models[i];
            }
            ++i;
        }
        return null;
    }

    private IFragmentModel[] findFragments(IPluginModelBase[] models, IPlugin plugin) {
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < models.length) {
            if (models[i] instanceof IFragmentModel) {
                IFragment fragment = ((IFragmentModel)models[i]).getFragment();
                if (plugin.getId().equalsIgnoreCase(fragment.getPluginId())) {
                    result.add(models[i]);
                }
            }
            ++i;
        }
        return result.toArray(new IFragmentModel[result.size()]);
    }

    class ReloadOperation
    implements IRunnableWithProgress {
        private URL[] pluginPaths;

        public ReloadOperation(URL[] pluginPaths) {
            this.pluginPaths = pluginPaths;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            ExternalPluginsBlock.this.fCurrentState = new PDEState(this.pluginPaths, true, monitor);
            ExternalPluginsBlock.this.fModels = ExternalPluginsBlock.this.fCurrentState.getModels();
        }
    }

    public class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            return ExternalPluginsBlock.this.getAllModels();
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String[] buttonLabels) {
            super(null, buttonLabels);
        }

        protected void buttonSelected(Button button, int index) {
            switch (index) {
                case 0: {
                    ExternalPluginsBlock.this.handleReload();
                    break;
                }
                case 5: {
                    ExternalPluginsBlock.this.handleWorkingSets();
                    break;
                }
                case 6: {
                    ExternalPluginsBlock.this.handleAddRequired();
                    break;
                }
                case 7: {
                    ExternalPluginsBlock.this.selectNotInWorkspace();
                    break;
                }
                default: {
                    super.buttonSelected(button, index);
                }
            }
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
            viewer.setSorter(ListUtil.PLUGIN_SORTER);
            return viewer;
        }

        protected void elementChecked(Object element, boolean checked) {
            IPluginModelBase model = (IPluginModelBase)element;
            if (ExternalPluginsBlock.this.changed.contains(model) && model.isEnabled() == checked) {
                ExternalPluginsBlock.this.changed.remove(model);
            } else if (model.isEnabled() != checked) {
                ExternalPluginsBlock.this.changed.add(model);
            }
            super.elementChecked(element, checked);
        }

        protected void handleSelectAll(boolean select) {
            super.handleSelectAll(select);
            IPluginModelBase[] allModels = ExternalPluginsBlock.this.getAllModels();
            int i = 0;
            while (i < allModels.length) {
                IPluginModelBase model = allModels[i];
                if (model.isEnabled() != select) {
                    ExternalPluginsBlock.this.changed.add(model);
                } else if (ExternalPluginsBlock.this.changed.contains(model) && model.isEnabled() == select) {
                    ExternalPluginsBlock.this.changed.remove(model);
                }
                ++i;
            }
        }

        public void incrementCounter(int increment) {
            this.updateCounter(this.getSelectionCount() + increment);
        }
    }
}

