/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.AbstractSearchResultPage;
import org.eclipse.pde.internal.ui.search.ManifestEditorOpener;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;

public class PluginSearchResultPage
extends AbstractSearchResultPage {
    public PluginSearchResultPage() {
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        mgr.add((IContributionItem)new Separator());
        PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
        actionGroup.setContext(new ActionContext(this.getViewer().getSelection()));
        actionGroup.fillContextMenu(mgr);
    }

    protected ILabelProvider createLabelProvider() {
        return new SearchLabelProvider();
    }

    protected ViewerSorter createViewerSorter() {
        return new ViewerSorter();
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        ManifestEditorOpener.open(match, activate);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    class SearchLabelProvider
    extends LabelProvider {
        SearchLabelProvider() {
        }

        public Image getImage(Object element) {
            return PDEPlugin.getDefault().getLabelProvider().getImage(element);
        }

        public String getText(Object object) {
            if (object instanceof IPluginBase) {
                return ((IPluginBase)object).getId();
            }
            if (object instanceof IPluginImport) {
                IPluginImport dep = (IPluginImport)object;
                return String.valueOf(dep.getId()) + " - " + dep.getPluginBase().getId();
            }
            if (object instanceof IPluginExtension) {
                IPluginExtension extension = (IPluginExtension)object;
                return String.valueOf(extension.getPoint()) + " - " + extension.getPluginBase().getId();
            }
            if (object instanceof IPluginExtensionPoint) {
                return ((IPluginExtensionPoint)object).getFullId();
            }
            return PDEPlugin.getDefault().getLabelProvider().getText(object);
        }
    }
}

