/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.search.SearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class DependencyExtentSearchResult
extends SearchResult
implements IEditorMatchAdapter {
    public DependencyExtentSearchResult(ISearchQuery query) {
        super(query);
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        return true;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            IFile file = fileEditorInput.getFile();
            if (JavaCore.create((IFile)file) != null) {
                return this.computeContainedMatches(result, file);
            }
        } else if (editorInput instanceof IClassFileEditorInput) {
            IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)editorInput;
            HashSet matches = new HashSet();
            this.collectMatches(matches, (IJavaElement)classFileEditorInput.getClassFile());
            return matches.toArray(new Match[matches.size()]);
        }
        return super.computeContainedMatches(result, editor);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        IJavaElement javaElement = JavaCore.create((IFile)file);
        if (!(javaElement instanceof ICompilationUnit) && !(javaElement instanceof IClassFile)) {
            return new Match[0];
        }
        HashSet matches = new HashSet();
        this.collectMatches(matches, javaElement);
        return matches.toArray(new Match[matches.size()]);
    }

    private void collectMatches(Set matches, IJavaElement element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
        if (element instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                IJavaElement[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.collectMatches(matches, children[i]);
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public String getLabel() {
        int count = this.getMatchCount();
        return String.valueOf(this.fQuery.getLabel()) + " - " + count + " " + (count == 1 ? PDEPlugin.getResourceString("DependencyExtentSearchResult.dependency") : PDEPlugin.getResourceString("DependencyExtentSearchResult.dependencies"));
    }

    public String getTooltip() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return PDEPluginImages.DESC_PSEARCH_OBJ;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }
}

