/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.swt.graphics.Image;

public class DependenciesLabelProvider
extends LabelProvider {
    private PDELabelProvider fSharedProvider;
    private boolean fShowReexport;

    public DependenciesLabelProvider(boolean showRexport) {
        this.fShowReexport = showRexport;
        this.fSharedProvider = PDEPlugin.getDefault().getLabelProvider();
        this.fSharedProvider.connect((Object)this);
    }

    public void dispose() {
        this.fSharedProvider.disconnect((Object)this);
        super.dispose();
    }

    public String getText(Object obj) {
        if (obj instanceof IPluginImport) {
            return ((IPluginImport)obj).getId();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof IPluginModelBase) {
            return ((IPluginModelBase)obj).getPluginBase(false).getId();
        }
        if (obj instanceof IPluginBase) {
            return ((IPluginBase)obj).getId();
        }
        return this.fSharedProvider.getText(obj);
    }

    public Image getImage(Object obj) {
        int flags = 0;
        String id = null;
        if (obj instanceof IPluginImport) {
            IPluginImport iobj = (IPluginImport)obj;
            id = iobj.getId();
            if (this.fShowReexport && iobj.isReexported()) {
                flags = 4;
            }
        } else if (obj instanceof String) {
            id = (String)obj;
        }
        if (id != null) {
            IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(id);
            if (model != null && model.getUnderlyingResource() == null) {
                flags |= 0x20;
            }
            if (model == null) {
                flags = 1;
            }
            if (model != null && model instanceof IFragmentModel) {
                return this.fSharedProvider.get(PDEPluginImages.DESC_FRAGMENT_OBJ, flags);
            }
            return this.fSharedProvider.get(PDEPluginImages.DESC_PLUGIN_OBJ, flags);
        }
        if (obj instanceof IPluginModelBase) {
            if (((IPluginModelBase)obj).getUnderlyingResource() == null) {
                flags |= 0x20;
            }
            if (obj instanceof IFragmentModel) {
                return this.fSharedProvider.get(PDEPluginImages.DESC_FRAGMENT_OBJ, flags);
            }
            return this.fSharedProvider.get(PDEPluginImages.DESC_PLUGIN_OBJ, flags);
        }
        if (obj instanceof IPluginBase) {
            if (((IPluginBase)obj).getPluginModel().getUnderlyingResource() == null) {
                flags |= 0x20;
            }
            if (obj instanceof IFragment) {
                return this.fSharedProvider.get(PDEPluginImages.DESC_FRAGMENT_OBJ, flags);
            }
            return this.fSharedProvider.get(PDEPluginImages.DESC_PLUGIN_OBJ, flags);
        }
        return this.fSharedProvider.getImage(obj);
    }
}

