/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.builders.DependencyLoop;
import org.eclipse.pde.internal.builders.DependencyLoopFinder;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.IHelpContextIds;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.plugin.LoopDialog;
import org.eclipse.pde.internal.ui.view.CalleesListContentProvider;
import org.eclipse.pde.internal.ui.view.CalleesTreeContentProvider;
import org.eclipse.pde.internal.ui.view.CallersListContentProvider;
import org.eclipse.pde.internal.ui.view.CallersTreeContentProvider;
import org.eclipse.pde.internal.ui.view.DependenciesViewListPage;
import org.eclipse.pde.internal.ui.view.DependenciesViewPage;
import org.eclipse.pde.internal.ui.view.DependenciesViewTreePage;
import org.eclipse.pde.internal.ui.view.HistoryDropDownAction;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class DependenciesView
extends PageBookView
implements IPreferenceConstants,
IHelpContextIds {
    protected static final IWorkbenchPart PART_CALLEES_LIST = new DummyPart();
    protected static final IWorkbenchPart PART_CALLEES_TREE = new DummyPart();
    protected static final IWorkbenchPart PART_CALLERS_LIST = new DummyPart();
    protected static final IWorkbenchPart PART_CALLERS_TREE = new DummyPart();
    public static final String TREE_ACTION_GROUP = "tree";
    protected static final String MEMENTO_KEY_INPUT = "inputPluginId";
    private static final DependencyLoop[] NO_LOOPS = new DependencyLoop[0];
    private Map fPagesToParts;
    private Map fPartsToPages;
    private Object fInput;
    private Preferences fPreferences = PDEPlugin.getDefault().getPluginPreferences();
    private ShowCalleesAction fShowCallees;
    private ShowCallersAction fShowCallers;
    private ShowListAction fShowList;
    private ShowTreeAction fShowTree;
    private ShowLoopsAction fShowLoops;
    private ArrayList fInputHistory;
    private DependencyLoop[] fLoops;
    private HistoryDropDownAction fHistoryDropDownAction;

    public DependenciesView() {
        this.fPartsToPages = new HashMap(4);
        this.fPagesToParts = new HashMap(4);
        this.fInputHistory = new ArrayList();
        this.fLoops = NO_LOOPS;
    }

    private void contributeToActionBars(IActionBars actionBars) {
        this.contributeToLocalToolBar(actionBars.getToolBarManager());
        actionBars.updateActionBars();
    }

    private void contributeToLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator(TREE_ACTION_GROUP));
        manager.add((IContributionItem)new Separator("type"));
        manager.appendToGroup("type", (IAction)this.fShowCallees);
        manager.appendToGroup("type", (IAction)this.fShowCallers);
        manager.add((IContributionItem)new Separator("presentation"));
        manager.appendToGroup("presentation", (IAction)this.fShowTree);
        manager.appendToGroup("presentation", (IAction)this.fShowList);
        manager.add((IContributionItem)new Separator("history"));
        manager.add((IAction)this.fShowLoops);
        manager.add((IAction)this.fHistoryDropDownAction);
    }

    protected IPage createDefaultPage(PageBook book) {
        if (this.fPreferences.getBoolean("DependenciesView.show.callers")) {
            if (this.fPreferences.getBoolean("DependenciesView.show.list")) {
                return this.createPage(PART_CALLERS_LIST);
            }
            return this.createPage(PART_CALLERS_TREE);
        }
        if (this.fPreferences.getBoolean("DependenciesView.show.list")) {
            return this.createPage(PART_CALLEES_LIST);
        }
        return this.createPage(PART_CALLEES_TREE);
    }

    private DependenciesViewPage createPage(IWorkbenchPart part) {
        DependenciesViewPage page = part == PART_CALLEES_TREE ? new DependenciesViewTreePage(this, new CalleesTreeContentProvider(this)) : (part == PART_CALLEES_LIST ? new DependenciesViewListPage(this, new CalleesListContentProvider(this)) : (part == PART_CALLERS_TREE ? new DependenciesViewTreePage(this, new CallersTreeContentProvider(this)) : new DependenciesViewListPage(this, new CallersListContentProvider(this))));
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        this.fPartsToPages.put(part, page);
        this.fPagesToParts.put(page, part);
        return page;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fShowCallees = new ShowCalleesAction();
        this.fShowCallees.setChecked(!this.fPreferences.getBoolean("DependenciesView.show.callers"));
        this.fShowCallers = new ShowCallersAction();
        this.fShowCallers.setChecked(this.fPreferences.getBoolean("DependenciesView.show.callers"));
        this.fShowTree = new ShowTreeAction();
        this.fShowTree.setChecked(!this.fPreferences.getBoolean("DependenciesView.show.list"));
        this.fShowList = new ShowListAction();
        this.fShowList.setChecked(this.fPreferences.getBoolean("DependenciesView.show.list"));
        this.fShowLoops = new ShowLoopsAction();
        this.fShowLoops.setEnabled(this.fLoops != NO_LOOPS);
        this.fHistoryDropDownAction = new HistoryDropDownAction(this);
        this.fHistoryDropDownAction.setEnabled(!this.fInputHistory.isEmpty());
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.contributeToActionBars(actionBars);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.pde.doc.user.dependencies_view");
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        Object page = (IPageBookViewPage)this.fPartsToPages.get(part);
        if (page == null && !this.fPartsToPages.containsKey(part)) {
            page = this.createPage(part);
        }
        if (page != null) {
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        this.fPartsToPages.remove(part);
    }

    protected IWorkbenchPart getBootstrapPart() {
        if (this.fPreferences.getBoolean("DependenciesView.show.callers")) {
            if (this.fPreferences.getBoolean("DependenciesView.show.list")) {
                return PART_CALLERS_LIST;
            }
            return PART_CALLERS_TREE;
        }
        if (this.fPreferences.getBoolean("DependenciesView.show.list")) {
            return PART_CALLEES_LIST;
        }
        return PART_CALLEES_TREE;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        IPluginModelBase plugin;
        super.init(site, memento);
        if (memento == null) {
            return;
        }
        String id = memento.getString(MEMENTO_KEY_INPUT);
        if (id != null && (plugin = PDECore.getDefault().getModelManager().findModel(id)) != null) {
            this.fInput = plugin;
            this.addHistoryEntry(id);
            this.findLoops();
        }
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof DummyPart;
    }

    public void openTo(Object object) {
        if (object != null && !object.equals(this.fInput) && object instanceof IPluginModelBase) {
            String id = ((IPluginModelBase)object).getPluginBase().getId();
            this.addHistoryEntry(id);
        }
        this.updateInput(object);
    }

    private void updateInput(Object object) {
        this.fInput = object;
        this.findLoops();
        ((DependenciesViewPage)this.getCurrentPage()).setInput(object);
    }

    private void findLoops() {
        this.fLoops = NO_LOOPS;
        if (this.fInput != null && this.fInput instanceof IPluginModel) {
            BusyIndicator.showWhile((Display)PDEPlugin.getActiveWorkbenchShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    IPlugin plugin = ((IPluginModel)DependenciesView.this.fInput).getPlugin();
                    DependencyLoop[] loops = DependencyLoopFinder.findLoops((IPlugin)plugin);
                    if (loops.length > 0) {
                        DependenciesView.this.fLoops = loops;
                    }
                }
            });
        }
        if (this.fShowLoops != null) {
            this.fShowLoops.setEnabled(this.fLoops != NO_LOOPS);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.fInput != null && this.fInput instanceof IPluginModelBase) {
            String inputPluginId = ((IPluginModelBase)this.fInput).getPluginBase().getId();
            memento.putString(MEMENTO_KEY_INPUT, inputPluginId);
        }
    }

    void setPresentation(boolean listNotTree) {
        IWorkbenchPart currentPart = this.getCurrentContributingPart();
        if (listNotTree) {
            if (currentPart == PART_CALLEES_TREE) {
                this.partActivated(PART_CALLEES_LIST);
            } else if (currentPart == PART_CALLERS_TREE) {
                this.partActivated(PART_CALLERS_LIST);
            }
        } else if (currentPart == PART_CALLEES_LIST) {
            this.partActivated(PART_CALLEES_TREE);
        } else if (currentPart == PART_CALLERS_LIST) {
            this.partActivated(PART_CALLERS_TREE);
        }
    }

    void setViewType(boolean callers) {
        IWorkbenchPart currentPart = this.getCurrentContributingPart();
        if (callers) {
            if (currentPart == PART_CALLEES_TREE) {
                this.partActivated(PART_CALLERS_TREE);
            } else if (currentPart == PART_CALLEES_LIST) {
                this.partActivated(PART_CALLERS_LIST);
            }
        } else if (currentPart == PART_CALLERS_TREE) {
            this.partActivated(PART_CALLEES_TREE);
        } else if (currentPart == PART_CALLERS_LIST) {
            this.partActivated(PART_CALLEES_LIST);
        }
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        IPage p = pageRec.page;
        ((DependenciesViewPage)p).setInput(this.fInput);
        super.showPageRec(pageRec);
        this.updateTitle(this.fInput);
    }

    void updateTitle(Object newInput) {
        if (newInput == null || newInput.equals(PDECore.getDefault().getModelManager())) {
            IConfigurationElement config = this.getConfigurationElement();
            if (config == null) {
                return;
            }
            String viewName = config.getAttribute("name");
            this.setContentDescription(viewName);
        } else {
            String name = PDEPlugin.getDefault().getLabelProvider().getText(newInput);
            String title = this.getCurrentContributingPart() == PART_CALLEES_TREE ? PDEPlugin.getFormattedMessage("DependenciesView.callees.tree.title", name) : (this.getCurrentContributingPart() == PART_CALLEES_LIST ? PDEPlugin.getFormattedMessage("DependenciesView.callees.list.title", name) : (this.getCurrentContributingPart() == PART_CALLERS_TREE ? PDEPlugin.getFormattedMessage("DependenciesView.callers.tree.title", name) : PDEPlugin.getFormattedMessage("DependenciesView.callers.list.title", name)));
            if (this.fLoops != NO_LOOPS) {
                title = String.valueOf(title) + " " + PDEPlugin.getResourceString("DependenciesView.cycles.title");
            }
            this.setContentDescription(title);
        }
        this.setTitleToolTip(this.getTitle());
    }

    private void addHistoryEntry(String entry) {
        if (this.fInputHistory.contains(entry)) {
            this.fInputHistory.remove(entry);
        }
        this.fInputHistory.add(0, entry);
        if (this.fHistoryDropDownAction != null) {
            this.fHistoryDropDownAction.setEnabled(true);
        }
    }

    private void updateHistoryEntries() {
        int i = this.fInputHistory.size() - 1;
        while (i >= 0) {
            String type = (String)this.fInputHistory.get(i);
            if (PDECore.getDefault().getModelManager().findModel(type) == null) {
                this.fInputHistory.remove(i);
            }
            --i;
        }
        if (this.fHistoryDropDownAction != null) {
            this.fHistoryDropDownAction.setEnabled(!this.fInputHistory.isEmpty());
        }
    }

    public void gotoHistoryEntry(String entry) {
        if (this.fInputHistory.contains(entry)) {
            this.updateInput(PDECore.getDefault().getModelManager().findModel(entry));
        }
    }

    public String[] getHistoryEntries() {
        if (this.fInputHistory.size() > 0) {
            this.updateHistoryEntries();
        }
        return this.fInputHistory.toArray(new String[this.fInputHistory.size()]);
    }

    public void setHistoryEntries(String[] elems) {
        this.fInputHistory.clear();
        int i = 0;
        while (i < elems.length) {
            this.fInputHistory.add(elems[i]);
            ++i;
        }
        this.updateHistoryEntries();
    }

    public String getInput() {
        if (this.fInput != null) {
            return ((IPluginModelBase)this.fInput).getPluginBase().getId();
        }
        return null;
    }

    static class DummyPart
    implements IWorkbenchPart {
        DummyPart() {
        }

        public void addPropertyListener(IPropertyListener listener) {
        }

        public void createPartControl(Composite parent) {
        }

        public void dispose() {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public IWorkbenchPartSite getSite() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public Image getTitleImage() {
            return null;
        }

        public String getTitleToolTip() {
            return null;
        }

        public void removePropertyListener(IPropertyListener listener) {
        }

        public void setFocus() {
        }
    }

    class ShowLoopsAction
    extends Action {
        public ShowLoopsAction() {
            super("", 1);
            this.setText(PDEPlugin.getResourceString("DependenciesView.ShowLoopsAction.label"));
            this.setDescription(PDEPlugin.getResourceString("DependenciesView.ShowLoopsAction.description"));
            this.setToolTipText(PDEPlugin.getResourceString("DependenciesView.ShowLoopsAction.tooltip"));
            this.setImageDescriptor(PDEPluginImages.DESC_DEP_LOOP);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_DEP_LOOP_DISABLED);
            this.setEnabled(false);
        }

        public void run() {
            LoopDialog dialog = new LoopDialog(PDEPlugin.getActiveWorkbenchShell(), DependenciesView.this.fLoops);
            dialog.open();
        }
    }

    class ShowCalleesAction
    extends Action {
        public ShowCalleesAction() {
            super("", 8);
            this.setText(PDEPlugin.getResourceString("DependenciesView.ShowCalleesAction.label"));
            this.setDescription(PDEPlugin.getResourceString("DependenciesView.ShowCalleesAction.description"));
            this.setToolTipText(PDEPlugin.getResourceString("DependenciesView.ShowCalleesAction.tooltip"));
            this.setImageDescriptor(PDEPluginImages.DESC_CALLEES);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_CALLEES_DISABLED);
        }

        public void run() {
            if (this.isChecked()) {
                DependenciesView.this.fPreferences.setValue("DependenciesView.show.callers", false);
                DependenciesView.this.setViewType(false);
            }
        }
    }

    class ShowCallersAction
    extends Action {
        public ShowCallersAction() {
            super("", 8);
            this.setText(PDEPlugin.getResourceString("DependenciesView.ShowCallersAction.label"));
            this.setDescription(PDEPlugin.getResourceString("DependenciesView.ShowCallersAction.description"));
            this.setToolTipText(PDEPlugin.getResourceString("DependenciesView.ShowCallersAction.tooltip"));
            this.setImageDescriptor(PDEPluginImages.DESC_CALLERS);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_CALLERS_DISABLED);
        }

        public void run() {
            if (this.isChecked()) {
                DependenciesView.this.fPreferences.setValue("DependenciesView.show.callers", true);
                DependenciesView.this.setViewType(true);
            }
        }
    }

    class ShowListAction
    extends Action {
        public ShowListAction() {
            super("", 8);
            this.setText(PDEPlugin.getResourceString("DependenciesView.ShowListAction.label"));
            this.setDescription(PDEPlugin.getResourceString("DependenciesView.ShowListAction.description"));
            this.setToolTipText(PDEPlugin.getResourceString("DependenciesView.ShowListAction.tooltip"));
            this.setImageDescriptor(PDEPluginImages.DESC_FLAT_LAYOUT);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_FLAT_LAYOUT_DISABLED);
        }

        public void run() {
            if (this.isChecked()) {
                DependenciesView.this.fPreferences.setValue("DependenciesView.show.list", true);
                DependenciesView.this.setPresentation(true);
            }
        }
    }

    class ShowTreeAction
    extends Action {
        public ShowTreeAction() {
            super("", 8);
            this.setText(PDEPlugin.getResourceString("DependenciesView.ShowTreeAction.label"));
            this.setDescription(PDEPlugin.getResourceString("DependenciesView.ShowTreeAction.description"));
            this.setToolTipText(PDEPlugin.getResourceString("DependenciesView.ShowTreeAction.tooltip"));
            this.setImageDescriptor(PDEPluginImages.DESC_HIERARCHICAL_LAYOUT);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_HIERARCHICAL_LAYOUT_DISABLED);
        }

        public void run() {
            if (this.isChecked()) {
                DependenciesView.this.fPreferences.setValue("DependenciesView.show.list", false);
                DependenciesView.this.setPresentation(false);
            }
        }
    }
}

