/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.plugin.PluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.search.dependencies.DependencyExtentAction;
import org.eclipse.pde.internal.ui.search.dependencies.UnusedDependenciesAction;
import org.eclipse.pde.internal.ui.view.DependenciesView;
import org.eclipse.pde.internal.ui.wizards.PluginSelectionDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.Page;

public abstract class DependenciesViewPage
extends Page {
    private Action fFocusOnAction;
    private FocusOnSelectionAction fFocusOnSelectionAction;
    private Action fOpenAction;
    private IPropertyChangeListener fPropertyListener;
    private DependenciesView fView;
    protected StructuredViewer fViewer;

    public DependenciesViewPage(DependenciesView view) {
        this.fView = view;
        this.fPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("Preferences.MainPage.showObjects")) {
                    DependenciesViewPage.this.fViewer.refresh();
                }
            }
        };
    }

    public void createControl(Composite parent) {
        this.fViewer = this.createViewer(parent);
        PDEPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    public void dispose() {
        PDEPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
        super.dispose();
    }

    private void fillContextMenu(IMenuManager manager) {
        Object importObj;
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.size() == 1) {
            manager.add((IAction)this.fOpenAction);
            manager.add((IContributionItem)new Separator());
        }
        this.fFocusOnSelectionAction.update(this.getSelectedObject());
        if (this.fFocusOnSelectionAction.isEnabled()) {
            manager.add((IAction)this.fFocusOnSelectionAction);
        }
        manager.add((IAction)this.fFocusOnAction);
        Object selectionElement = selection.getFirstElement();
        manager.add((IContributionItem)new Separator());
        if (selection.size() == 1 && (importObj = selectionElement) instanceof IPluginImport) {
            String id = ((IPluginImport)importObj).getId();
            IResource resource = ((IPluginImport)importObj).getModel().getUnderlyingResource();
            if (resource != null) {
                manager.add((IAction)new DependencyExtentAction(resource.getProject(), id));
            }
        }
        ISharedPluginModel model = null;
        if (selectionElement instanceof PluginReference) {
            selectionElement = ((PluginReference)selectionElement).getPlugin();
        }
        if (selectionElement instanceof IPluginObject) {
            model = ((IPluginObject)selectionElement).getModel();
        }
        if (model != null && model.getUnderlyingResource() != null) {
            manager.add((IAction)new UnusedDependenciesAction((IPluginModelBase)model, true));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    public Control getControl() {
        return this.fViewer.getControl();
    }

    private Object getSelectedObject() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        return selection.getFirstElement();
    }

    public DependenciesView getView() {
        return this.fView;
    }

    private void handleDoubleClick() {
        Object obj = this.getSelectedObject();
        if (obj instanceof IPluginImport) {
            ManifestEditor.openPluginEditor(((IPluginImport)obj).getId());
        } else if (obj instanceof IPluginBase) {
            ManifestEditor.openPluginEditor((IPluginBase)obj);
        }
    }

    private void handleFocusOn() {
        PluginSelectionDialog dialog = new PluginSelectionDialog(this.fViewer.getControl().getShell(), true, false);
        dialog.create();
        if (dialog.open() == 0) {
            this.handleFocusOn(dialog.getFirstResult());
        }
    }

    private void handleFocusOn(Object newFocus) {
        if (newFocus instanceof IPluginModelBase) {
            this.fView.openTo(newFocus);
        }
        if (newFocus instanceof IPluginBase) {
            this.fView.openTo(((IPluginBase)newFocus).getModel());
        }
        if (newFocus instanceof IPluginImport) {
            IPluginImport pluginImport = (IPluginImport)newFocus;
            String id = pluginImport.getId();
            IPlugin importedPlugin = PDECore.getDefault().findPlugin(id);
            if (importedPlugin != null) {
                this.fView.openTo(importedPlugin.getModel());
            } else {
                this.fView.openTo(null);
            }
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DependenciesViewPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this.fView.getSite().getId(), menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void hookDoubleClickAction() {
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DependenciesViewPage.this.handleDoubleClick();
            }
        });
    }

    private void makeActions() {
        this.fOpenAction = new Action(){

            public void run() {
                DependenciesViewPage.this.handleDoubleClick();
            }

            public void update(Object object) {
            }
        };
        this.fOpenAction.setText(PDEPlugin.getResourceString("DependenciesView.open"));
        this.fFocusOnSelectionAction = new FocusOnSelectionAction();
        this.fFocusOnAction = new Action(){

            public void run() {
                DependenciesViewPage.this.handleFocusOn();
            }
        };
        this.fFocusOnAction.setText(PDEPlugin.getResourceString("DependenciesViewPage.focusOn"));
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    public void setFocus() {
        Control c;
        if (this.fViewer != null && !(c = this.fViewer.getControl()).isFocusControl()) {
            c.setFocus();
        }
    }

    public void setInput(Object object) {
        if (object != this.fViewer.getInput()) {
            this.fViewer.setInput(object);
        }
    }

    class FocusOnSelectionAction
    extends Action {
        FocusOnSelectionAction() {
        }

        public void run() {
            DependenciesViewPage.this.handleFocusOn(DependenciesViewPage.this.getSelectedObject());
        }

        public void update(Object object) {
            this.setEnabled(object != null);
            String name = ((LabelProvider)DependenciesViewPage.this.fViewer.getLabelProvider()).getText(object);
            this.setText(PDEPlugin.getFormattedMessage("DependenciesViewPage.focusOnSelection", name));
        }
    }
}

