/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.view.DependenciesView;

public class DependenciesViewPageContentProvider
extends DefaultContentProvider
implements IPluginModelListener {
    private PluginModelManager fPluginManager;
    private DependenciesView fView;
    private StructuredViewer fViewer;

    public DependenciesViewPageContentProvider(DependenciesView view) {
        this.fView = view;
        this.fPluginManager = PDECore.getDefault().getModelManager();
        this.fPluginManager.addPluginModelListener((IPluginModelListener)this);
    }

    public void dispose() {
        this.fPluginManager.removePluginModelListener((IPluginModelListener)this);
    }

    private void handleRemoved(ModelEntry[] removed) {
        int i = 0;
        while (i < removed.length) {
            ModelEntry entry = removed[i];
            IPluginModelBase model = entry.getActiveModel();
            if (model != null && model.equals(this.fViewer.getInput())) {
                this.fViewer.setInput(null);
                return;
            }
            ++i;
        }
        this.fViewer.refresh();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fView.updateTitle(newInput);
        this.fViewer = (StructuredViewer)viewer;
    }

    public void modelsChanged(final PluginModelDelta delta) {
        if (this.fViewer == null || this.fViewer.getControl().isDisposed()) {
            return;
        }
        this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                int kind = delta.getKind();
                if (DependenciesViewPageContentProvider.this.fViewer.getControl().isDisposed()) {
                    return;
                }
                if ((kind & 4) != 0 || (kind & 1) != 0) {
                    DependenciesViewPageContentProvider.this.fViewer.refresh();
                    return;
                }
                if ((kind & 2) != 0) {
                    ModelEntry[] removed = delta.getRemovedEntries();
                    DependenciesViewPageContentProvider.this.handleRemoved(removed);
                }
                if ((kind & 1) != 0) {
                    DependenciesViewPageContentProvider.this.fViewer.refresh();
                }
            }
        });
    }

    protected PluginModelManager getPluginManager() {
        return this.fPluginManager;
    }
}

