/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;
import org.eclipse.pde.internal.core.SourceAttachmentManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class RequiredPluginsContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IClasspathEntry entry;
    private CheckboxTableViewer viewer;
    private Image projectImage;
    private Image libraryImage;
    private Image slibraryImage;
    private IClasspathEntry[] realEntries;
    private IJavaProject javaProject;
    private Button attachSourceButton;
    private Hashtable replacedEntries;

    public RequiredPluginsContainerPage() {
        super("requiredPluginsContainerPage");
        this.setTitle(PDEPlugin.getResourceString("RequiredPluginsContainerPage.title"));
        this.setDescription(PDEPlugin.getResourceString("RequiredPluginsContainerPage.desc"));
        this.projectImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.libraryImage = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_l_obj.gif");
        this.slibraryImage = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_lsrc_obj.gif");
        this.setImageDescriptor(PDEPluginImages.DESC_CONVJPPRJ_WIZ);
        this.replacedEntries = new Hashtable();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("RequiredPluginsContainerPage.label"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2816);
        this.viewer.setContentProvider((IContentProvider)new EntryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EntryLabelProvider());
        this.viewer.setSorter((ViewerSorter)new EntrySorter());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RequiredPluginsContainerPage.this.viewer.setChecked(event.getElement(), !event.getChecked());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                RequiredPluginsContainerPage.this.handleSelectionChanged((IStructuredSelection)e.getSelection());
            }
        });
        gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.attachSourceButton = new Button(container, 8);
        this.attachSourceButton.setText(PDEPlugin.getResourceString("RequiredPluginsContainerPage.attachSource"));
        gd = new GridData(2);
        this.attachSourceButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.attachSourceButton);
        this.attachSourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequiredPluginsContainerPage.this.handleAttachSource();
            }
        });
        this.attachSourceButton.setEnabled(false);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.plugins_container_page");
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        if (this.realEntries != null) {
            this.initializeView();
        }
    }

    private void handleSelectionChanged(IStructuredSelection selection) {
        IClasspathEntry entry = (IClasspathEntry)selection.getFirstElement();
        boolean canAttach = true;
        if (entry == null || entry.getEntryKind() != 1) {
            canAttach = false;
        }
        this.attachSourceButton.setEnabled(canAttach);
    }

    private IClasspathEntry getEditableEntry(IClasspathEntry entry) {
        IClasspathEntry modifiedEntry = (IClasspathEntry)this.replacedEntries.get(entry);
        if (modifiedEntry != null) {
            return modifiedEntry;
        }
        return entry;
    }

    private void handleAttachSource() {
        IStructuredSelection ssel = (IStructuredSelection)this.viewer.getSelection();
        IClasspathEntry entry = (IClasspathEntry)ssel.getFirstElement();
        IClasspathEntry editableEntry = this.getEditableEntry(entry);
        IClasspathEntry newEntry = BuildPathDialogAccess.configureSourceAttachment((Shell)this.viewer.getControl().getShell(), (IClasspathEntry)editableEntry);
        if (newEntry != null) {
            this.replacedEntries.put(entry, newEntry);
        }
    }

    public boolean finish() {
        if (this.replacedEntries.size() > 0) {
            this.processReplacedEntries();
        }
        return true;
    }

    private void processReplacedEntries() {
        SourceAttachmentManager manager = PDECore.getDefault().getSourceAttachmentManager();
        Enumeration keys = this.replacedEntries.keys();
        while (keys.hasMoreElements()) {
            IClasspathEntry entry = (IClasspathEntry)keys.nextElement();
            IClasspathEntry newEntry = (IClasspathEntry)this.replacedEntries.get(entry);
            manager.addEntry(newEntry.getPath(), newEntry.getSourceAttachmentPath(), newEntry.getSourceAttachmentRootPath());
        }
        manager.save();
        this.resetContainer();
    }

    public IClasspathEntry getSelection() {
        return this.entry;
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.javaProject = project;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.entry = containerEntry;
        this.createRealEntries();
        if (this.viewer != null) {
            this.initializeView();
        }
    }

    private void resetContainer() {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)this.entry.getPath(), (IJavaProject)javaProject);
                if (container instanceof RequiredPluginsClasspathContainer) {
                    ((RequiredPluginsClasspathContainer)container).reset();
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private void createRealEntries() {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            this.realEntries = new IClasspathEntry[0];
            return;
        }
        if (this.entry == null) {
            RequiredPluginsClasspathContainer container;
            this.entry = ClasspathUtilCore.createContainerEntry();
            PluginModelManager mng = PDECore.getDefault().getModelManager();
            ModelEntry entry = mng.findEntry(javaProject.getProject());
            if (entry != null && (container = entry.getClasspathContainer()) != null) {
                this.realEntries = container.getClasspathEntries();
            }
        } else {
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)this.entry.getPath(), (IJavaProject)javaProject);
                if (container != null) {
                    this.realEntries = container.getClasspathEntries();
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        if (this.realEntries == null) {
            this.realEntries = new IClasspathEntry[0];
        }
    }

    private IJavaProject getJavaProject() {
        return this.javaProject;
    }

    private void initializeView() {
        this.viewer.setInput((Object)this.entry);
        this.viewer.setAllGrayed(true);
        int i = 0;
        while (i < this.realEntries.length) {
            if (this.realEntries[i].isExported()) {
                this.viewer.setChecked((Object)this.realEntries[i], true);
            }
            ++i;
        }
    }

    class EntryContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        EntryContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (RequiredPluginsContainerPage.this.realEntries != null) {
                return RequiredPluginsContainerPage.this.realEntries;
            }
            return new Object[0];
        }
    }

    class EntrySorter
    extends ViewerSorter {
        EntrySorter() {
        }

        public int category(Object obj) {
            IClasspathEntry entry = (IClasspathEntry)obj;
            return entry.getEntryKind() == 2 ? -10 : 0;
        }
    }

    class EntryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        EntryLabelProvider() {
        }

        public String getText(Object obj) {
            IClasspathEntry entry = (IClasspathEntry)obj;
            int kind = entry.getEntryKind();
            if (kind == 2) {
                return entry.getPath().segment(0);
            }
            IPath path = entry.getPath();
            String name = path.lastSegment();
            return String.valueOf(name) + " - " + path.uptoSegment(path.segmentCount() - 1).toOSString();
        }

        public Image getImage(Object obj) {
            IClasspathEntry entry = (IClasspathEntry)obj;
            int kind = entry.getEntryKind();
            if (kind == 2) {
                return RequiredPluginsContainerPage.this.projectImage;
            }
            if (kind == 1) {
                IPath sourceAtt = entry.getSourceAttachmentPath();
                return sourceAtt != null ? RequiredPluginsContainerPage.this.slibraryImage : RequiredPluginsContainerPage.this.libraryImage;
            }
            return null;
        }

        public String getColumnText(Object obj, int col) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int col) {
            return this.getImage(obj);
        }
    }
}

