/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.preferences.TargetPlatformPreferenceNode;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public abstract class BaseExportWizardPage
extends WizardPage {
    private String S_EXPORT_UPDATE = "exportUpdate";
    private String S_EXPORT_DIRECTORY = "exportDirectory";
    private String S_EXPORT_SOURCE = "exportSource";
    private String S_DESTINATION = "destination";
    private String S_ZIP_FILENAME = "zipFileName";
    private String S_SAVE_AS_ANT = "saveAsAnt";
    private String S_ANT_FILENAME = "antFileName";
    private IStructuredSelection fSelection;
    protected ExportPart fExportPart;
    protected boolean fIsFeatureExport;
    private Label fDirectoryLabel;
    private Combo fDestination;
    private Button fBrowseDirectory;
    private Label fFileLabel;
    private Combo fZipFile;
    private Button fBrowseFile;
    private Button fIncludeSource;
    private Combo fExportFormats;
    private Label fAntLabel;
    private Combo fAntCombo;
    private Button fBrowseAnt;
    private Button fSaveAsAntButton;
    private String fZipExtension = Platform.getOS().equals("macosx") ? ".tar.gz" : ".zip";

    public BaseExportWizardPage(IStructuredSelection selection, String name, String choiceLabel, boolean featureExport) {
        super(name);
        this.fSelection = selection;
        this.fIsFeatureExport = featureExport;
        String[] stringArray = new String[4];
        stringArray[0] = PDEPlugin.getResourceString("WizardCheckboxTablePart.selectAll");
        stringArray[1] = PDEPlugin.getResourceString("WizardCheckboxTablePart.deselectAll");
        stringArray[3] = PDEPlugin.getResourceString("ExportWizard.workingSet");
        this.fExportPart = new ExportPart(choiceLabel, stringArray);
        this.setDescription(PDEPlugin.getResourceString("ExportWizard.Plugin.description"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.createTableViewerSection(container);
        this.createOptionsSection(container);
        this.createExportDestinationSection(container);
        this.createAntBuildSection(container);
        Dialog.applyDialogFont((Control)container);
        this.initializeList();
        this.loadSettings();
        this.pageChanged();
        this.hookListeners();
        this.setControl((Control)container);
        this.hookHelpContext((Control)container);
    }

    private void createTableViewerSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fExportPart.createControl(composite);
        GridData gd = (GridData)this.fExportPart.getControl().getLayoutData();
        gd.heightHint = 125;
        gd.widthHint = 150;
        gd.horizontalSpan = 2;
    }

    private void createExportDestinationSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEPlugin.getResourceString("ExportWizard.destination.group"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.fFileLabel = new Label((Composite)group, 0);
        this.fFileLabel.setText(PDEPlugin.getResourceString("ExportWizard.zipFile"));
        this.fZipFile = new Combo((Composite)group, 2048);
        this.fZipFile.setLayoutData((Object)new GridData(768));
        this.fBrowseFile = new Button((Composite)group, 8);
        this.fBrowseFile.setText(PDEPlugin.getResourceString("ExportWizard.browse"));
        this.fBrowseFile.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseFile);
        this.fDirectoryLabel = new Label((Composite)group, 0);
        this.fDirectoryLabel.setText(PDEPlugin.getResourceString("ExportWizard.destination"));
        this.fDestination = new Combo((Composite)group, 2048);
        this.fDestination.setLayoutData((Object)new GridData(768));
        this.fBrowseDirectory = new Button((Composite)group, 8);
        this.fBrowseDirectory.setText(PDEPlugin.getResourceString("ExportWizard.browse"));
        this.fBrowseDirectory.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseDirectory);
    }

    private void createOptionsSection(Composite parent) {
        Group comp = new Group(parent, 0);
        comp.setText(PDEPlugin.getResourceString("ExportWizard.options"));
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(768));
        Composite top = new Composite((Composite)comp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        Label label = new Label(top, 0);
        label.setText(PDEPlugin.getResourceString("ExportWizard.format"));
        this.fExportFormats = new Combo(top, 8);
        this.fExportFormats.setLayoutData((Object)new GridData(768));
        String[] formats = new String[]{Platform.getOS().equals("macosx") ? PDEPlugin.getResourceString("ExportWizard.tar") : PDEPlugin.getResourceString("ExportWizard.zip"), PDEPlugin.getResourceString("ExportWizard.directory"), PDEPlugin.getResourceString("ExportWizard.updateJars")};
        this.fExportFormats.setItems(formats);
        Composite bottom = new Composite((Composite)comp, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        bottom.setLayout((Layout)layout);
        bottom.setLayoutData((Object)new GridData(768));
        this.fIncludeSource = new Button(bottom, 32);
        this.fIncludeSource.setText(PDEPlugin.getResourceString("ExportWizard.includeSource"));
        this.fIncludeSource.setLayoutData((Object)new GridData(768));
        Button button = new Button(bottom, 8);
        button.setText(PDEPlugin.getResourceString("ExportWizard.targetEnv.button"));
        button.setLayoutData((Object)new GridData(128));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.showPreferencePage(new TargetPlatformPreferenceNode());
            }
        });
        SWTUtil.setButtonDimensionHint(button);
    }

    private void createAntBuildSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEPlugin.getResourceString("ExportWizard.antTitle"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.fSaveAsAntButton = new Button((Composite)group, 32);
        this.fSaveAsAntButton.setText(PDEPlugin.getResourceString("ExportWizard.antCheck"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fSaveAsAntButton.setLayoutData((Object)gd);
        this.fAntLabel = new Label((Composite)group, 0);
        this.fAntLabel.setText(PDEPlugin.getResourceString("ExportWizard.antLabel"));
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.fAntLabel.setLayoutData((Object)gd);
        this.fAntCombo = new Combo((Composite)group, 0);
        this.fAntCombo.setLayoutData((Object)new GridData(768));
        this.fBrowseAnt = new Button((Composite)group, 8);
        this.fBrowseAnt.setText(PDEPlugin.getResourceString("ExportWizard.browse2"));
        this.fBrowseAnt.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseAnt);
    }

    private void showPreferencePage(final IPreferenceNode targetNode) {
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot(targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                dialog.create();
                dialog.setMessage(targetNode.getLabelText());
                dialog.open();
            }
        });
    }

    private void hookListeners() {
        this.fSaveAsAntButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.fAntLabel.setEnabled(BaseExportWizardPage.this.fSaveAsAntButton.getSelection());
                BaseExportWizardPage.this.fAntCombo.setEnabled(BaseExportWizardPage.this.fSaveAsAntButton.getSelection());
                BaseExportWizardPage.this.fBrowseAnt.setEnabled(BaseExportWizardPage.this.fSaveAsAntButton.getSelection());
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.fExportFormats.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.enableZipOption(BaseExportWizardPage.this.doExportAsZip());
                BaseExportWizardPage.this.enableDirectoryOption(!BaseExportWizardPage.this.doExportAsZip());
                BaseExportWizardPage.this.fIncludeSource.setEnabled(!BaseExportWizardPage.this.doExportAsUpdateJars());
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.fBrowseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.chooseFile(BaseExportWizardPage.this.fZipFile, "*" + BaseExportWizardPage.this.fZipExtension);
            }
        });
        this.fZipFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.fZipFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.fDestination.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.fDestination.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.fBrowseDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.chooseDestination();
            }
        });
        this.fBrowseAnt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.chooseFile(BaseExportWizardPage.this.fAntCombo, "*.xml");
            }
        });
        this.fAntCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.fAntCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
    }

    private void chooseFile(Combo combo, String filter) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setFileName(this.fZipFile.getText());
        dialog.setFilterExtensions(new String[]{filter});
        String res = dialog.open();
        if (res != null) {
            if (combo.indexOf(res) == -1) {
                combo.add(res, 0);
            }
            combo.setText(res);
        }
    }

    private void enableZipOption(boolean enabled) {
        if (this.fFileLabel.getEnabled() != enabled) {
            this.fFileLabel.setEnabled(enabled);
            this.fZipFile.setEnabled(enabled);
            this.fBrowseFile.setEnabled(enabled);
        }
    }

    private void enableDirectoryOption(boolean enabled) {
        if (this.fDirectoryLabel.getEnabled() != enabled) {
            this.fDirectoryLabel.setEnabled(enabled);
            this.fDestination.setEnabled(enabled);
            this.fBrowseDirectory.setEnabled(enabled);
        }
    }

    protected abstract Object[] getListElements();

    private void initializeList() {
        CheckboxTableViewer viewer = this.fExportPart.getTableViewer();
        viewer.setContentProvider((IContentProvider)new ExportListProvider());
        viewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        viewer.setSorter(ListUtil.PLUGIN_SORTER);
        this.fExportPart.getTableViewer().setInput((Object)PDECore.getDefault().getWorkspaceModelManager());
        this.checkSelected();
    }

    private void chooseDestination() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        dialog.setFilterPath(this.fDestination.getText());
        dialog.setText(PDEPlugin.getResourceString("ExportWizard.dialog.title"));
        dialog.setMessage(PDEPlugin.getResourceString("ExportWizard.dialog.message"));
        String res = dialog.open();
        if (res != null) {
            if (this.fDestination.indexOf(res) == -1) {
                this.fDestination.add(res, 0);
            }
            this.fDestination.setText(res);
        }
    }

    protected void checkSelected() {
        Object[] elems = this.fSelection.toArray();
        ArrayList<IModel> checked = new ArrayList<IModel>(elems.length);
        int i = 0;
        while (i < elems.length) {
            IModel model;
            Object elem = elems[i];
            IProject project = null;
            if (elem instanceof IFile) {
                IFile file = (IFile)elem;
                project = file.getProject();
            } else if (elem instanceof IProject) {
                project = (IProject)elem;
            } else if (elem instanceof IJavaProject) {
                project = ((IJavaProject)elem).getProject();
            }
            if (project != null && (model = this.findModelFor((IAdaptable)project)) != null && !checked.contains(model)) {
                checked.add(model);
            }
            ++i;
        }
        this.fExportPart.setSelection(checked.toArray());
        if (checked.size() > 0) {
            this.fExportPart.getTableViewer().reveal(checked.get(0));
        }
    }

    protected abstract IModel findModelFor(IAdaptable var1);

    private void pageChanged() {
        boolean hasSel;
        String message = null;
        if (this.fSaveAsAntButton != null && !this.fSaveAsAntButton.isDisposed() && this.fSaveAsAntButton.getSelection() && this.fAntCombo.getText().trim().length() == 0) {
            message = PDEPlugin.getResourceString("ExportWizard.status.noantfile");
        }
        if (this.fExportFormats != null && !this.fExportFormats.isDisposed() && this.doExportAsZip()) {
            if (this.fZipFile.getText().trim().length() == 0) {
                message = PDEPlugin.getResourceString("ExportWizard.status.nofile");
            }
        } else if (this.fDestination != null && !this.fDestination.isDisposed() && this.fDestination.getText().trim().length() == 0) {
            message = PDEPlugin.getResourceString("ExportWizard.status.nodirectory");
        }
        boolean bl = hasSel = this.fExportPart.getSelectionCount() > 0;
        if (!hasSel) {
            message = PDEPlugin.getResourceString("ExportWizard.status.noselection");
        }
        this.setMessage(message);
        this.setPageComplete(hasSel && message == null);
    }

    private void loadSettings() {
        IDialogSettings settings = this.getDialogSettings();
        this.initializeExportOptions(settings);
        this.initializeDestinationSection(settings);
        this.initializeAntBuildSection(settings);
    }

    private void initializeExportOptions(IDialogSettings settings) {
        boolean exportUpdate = settings.getBoolean(this.S_EXPORT_UPDATE);
        boolean exportDirectory = settings.getBoolean(this.S_EXPORT_DIRECTORY);
        int index = 0;
        if (exportUpdate) {
            index = 2;
        } else if (exportDirectory) {
            index = 1;
        }
        this.fExportFormats.setText(this.fExportFormats.getItem(index));
        this.enableZipOption(!exportUpdate && !exportDirectory);
        this.enableDirectoryOption(exportUpdate || exportDirectory);
        this.fIncludeSource.setSelection(settings.getBoolean(this.S_EXPORT_SOURCE));
        this.fIncludeSource.setEnabled(!this.doExportAsUpdateJars());
    }

    private void initializeDestinationSection(IDialogSettings settings) {
        this.initializeCombo(settings, this.S_DESTINATION, this.fDestination);
        this.initializeCombo(settings, this.S_ZIP_FILENAME, this.fZipFile);
    }

    private void initializeAntBuildSection(IDialogSettings settings) {
        this.fSaveAsAntButton.setSelection(settings.getBoolean(this.S_SAVE_AS_ANT));
        this.initializeCombo(settings, this.S_ANT_FILENAME, this.fAntCombo);
        this.fAntLabel.setEnabled(this.fSaveAsAntButton.getSelection());
        this.fAntCombo.setEnabled(this.fSaveAsAntButton.getSelection());
        this.fBrowseAnt.setEnabled(this.fSaveAsAntButton.getSelection());
    }

    private void initializeCombo(IDialogSettings settings, String key, Combo combo) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < 6) {
            String curr = settings.get(String.valueOf(key) + String.valueOf(i));
            if (curr != null && !list.contains(curr)) {
                list.add(curr);
            }
            ++i;
        }
        String[] items = list.toArray(new String[list.size()]);
        combo.setItems(items);
        if (items.length > 0) {
            combo.setText(items[0]);
        }
    }

    public void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(this.S_EXPORT_UPDATE, this.doExportAsUpdateJars());
        settings.put(this.S_EXPORT_DIRECTORY, this.doExportAsDirectory());
        settings.put(this.S_EXPORT_SOURCE, this.fIncludeSource.getSelection());
        settings.put(this.S_SAVE_AS_ANT, this.fSaveAsAntButton.getSelection());
        this.saveCombo(settings, this.S_DESTINATION, this.fDestination);
        this.saveCombo(settings, this.S_ZIP_FILENAME, this.fZipFile);
        this.saveCombo(settings, this.S_ANT_FILENAME, this.fAntCombo);
    }

    private void saveCombo(IDialogSettings settings, String key, Combo combo) {
        if (combo.getText().trim().length() > 0) {
            settings.put(String.valueOf(key) + String.valueOf(0), combo.getText().trim());
            String[] items = combo.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(String.valueOf(key) + String.valueOf(i + 1), items[i].trim());
                ++i;
            }
        }
    }

    public Object[] getSelectedItems() {
        return this.fExportPart.getSelection();
    }

    public boolean doExportAsZip() {
        return this.fExportFormats.getSelectionIndex() == 0;
    }

    public boolean doExportAsUpdateJars() {
        return this.fExportFormats.getSelectionIndex() == 2;
    }

    public boolean doExportAsDirectory() {
        return this.fExportFormats.getSelectionIndex() == 1;
    }

    public boolean doExportSource() {
        return this.fIncludeSource != null && this.fIncludeSource.getSelection();
    }

    public String getFileName() {
        String path;
        if (this.doExportAsZip() && (path = this.fZipFile.getText()) != null && path.length() > 0) {
            String fileName = new Path(path).lastSegment();
            if (!fileName.endsWith(this.fZipExtension)) {
                fileName = String.valueOf(fileName) + this.fZipExtension;
            }
            return fileName;
        }
        return null;
    }

    public String getDestination() {
        if (this.fExportFormats != null && this.doExportAsZip()) {
            String path = this.fZipFile.getText();
            if (path != null && path.length() > 0) {
                path = new Path(path).removeLastSegments(1).toOSString();
                return new File(path).getAbsolutePath();
            }
            return "";
        }
        if (this.fDestination == null || this.fDestination.isDisposed()) {
            return "";
        }
        File dir = new File(this.fDestination.getText().trim());
        return dir.getAbsolutePath();
    }

    public int getExportType() {
        return this.fExportFormats.getSelectionIndex();
    }

    protected abstract void hookHelpContext(Control var1);

    private void handleWorkingSets() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(this.getShell(), true);
        if (dialog.open() == 0) {
            ArrayList<IModel> models = new ArrayList<IModel>();
            IWorkingSet[] workingSets = dialog.getSelection();
            int i = 0;
            while (i < workingSets.length) {
                IAdaptable[] elements = workingSets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    IModel model = this.findModelFor(elements[j]);
                    if (this.isValidModel(model)) {
                        models.add(model);
                    }
                    ++j;
                }
                ++i;
            }
            this.fExportPart.setSelection(models.toArray());
        }
    }

    protected abstract boolean isValidModel(IModel var1);

    public boolean doGenerateAntFile() {
        return this.fSaveAsAntButton.getSelection();
    }

    public String getAntBuildFileName() {
        return this.fAntCombo.getText().trim();
    }

    class ExportListProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ExportListProvider() {
        }

        public Object[] getElements(Object parent) {
            return BaseExportWizardPage.this.getListElements();
        }
    }

    class ExportPart
    extends WizardCheckboxTablePart {
        public ExportPart(String label, String[] buttonLabels) {
            super(label, buttonLabels);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            BaseExportWizardPage.this.pageChanged();
        }

        protected void buttonSelected(Button button, int index) {
            switch (index) {
                case 0: {
                    this.handleSelectAll(true);
                    break;
                }
                case 1: {
                    this.handleSelectAll(false);
                    break;
                }
                case 3: {
                    BaseExportWizardPage.this.handleWorkingSets();
                }
            }
        }
    }
}

