/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public abstract class BaseFeatureSpecPage
extends WizardPage {
    private boolean isPatch;
    protected WizardNewProjectCreationPage mainPage;
    protected Text featureIdText;
    protected Text featureNameText;
    protected Text featureVersionText;
    protected Text featureProviderText;
    protected Text patchIdText;
    protected Text patchNameText;
    protected Text patchProviderText;
    protected Text libraryText;
    protected Button browseButton;
    protected Button customChoice;
    protected String initialId;
    protected String initialName;
    protected Label libraryLabel;
    protected boolean isInitialized = false;
    protected IFeatureModel fFeatureToPatch;
    public static final String PATCH_ID = "NewFeaturePatch.SpecPage.id";
    public static final String PATCH_NAME = "NewFeaturePatch.SpecPage.name";
    public static final String PATCH_PROVIDER = "NewFeaturePatch.SpecPage.provider";
    public static final String FEATURE_ID = "NewFeatureWizard.SpecPage.id";
    public static final String FEATURE_NAME = "NewFeatureWizard.SpecPage.name";
    public static final String FEATURE_VERSION = "NewFeatureWizard.SpecPage.version";
    public static final String FEATURE_PROVIDER = "NewFeatureWizard.SpecPage.provider";
    public static final String KEY_LIBRARY = "NewFeatureWizard.SpecPage.library";
    public static final String KEY_VERSION_FORMAT = "NewFeatureWizard.SpecPage.versionFormat";
    public static final String KEY_INVALID_ID = "NewFeatureWizard.SpecPage.invalidId";
    public static final String KEY_MISSING = "NewFeatureWizard.SpecPage.missing";
    public static final String KEY_PMISSING = "NewFeatureWizard.SpecPage.pmissing";
    public static final String KEY_LIBRARY_MISSING = "NewFeatureWizard.SpecPage.error.library";
    private static final String KEY_CUSTOM_INSTALL_HANDLER = "NewFeatureWizard.SpecPage.customProject";
    private static final String KEY_PATCH_CUSTOM_INSTALL_HANDLER = "NewFeatureWizard.SpecPage.patch.customProject";

    public BaseFeatureSpecPage(WizardNewProjectCreationPage mainPage, boolean isPatch) {
        super("specPage");
        this.isPatch = isPatch;
        this.mainPage = mainPage;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 12;
        layout.horizontalSpacing = 9;
        container.setLayout((Layout)layout);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseFeatureSpecPage.this.verifyComplete();
            }
        };
        if (this.isPatch()) {
            Group patchPropertiesGroup = new Group(container, 0);
            layout = new GridLayout(2, false);
            patchPropertiesGroup.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            patchPropertiesGroup.setLayoutData((Object)gd);
            patchPropertiesGroup.setText(PDEPlugin.getResourceString("NewFeatureWizard.SpecPage.patchProperties"));
            Label label = new Label((Composite)patchPropertiesGroup, 0);
            label.setText(PDEPlugin.getResourceString(PATCH_ID));
            this.patchIdText = new Text((Composite)patchPropertiesGroup, 2048);
            gd = new GridData(768);
            this.patchIdText.setLayoutData((Object)gd);
            if (this.initialId != null) {
                this.patchIdText.setText(this.initialId);
            }
            this.patchIdText.addModifyListener(listener);
            label = new Label((Composite)patchPropertiesGroup, 0);
            label.setText(PDEPlugin.getResourceString(PATCH_NAME));
            this.patchNameText = new Text((Composite)patchPropertiesGroup, 2048);
            gd = new GridData(768);
            this.patchNameText.setLayoutData((Object)gd);
            if (this.initialName != null) {
                this.patchNameText.setText(this.initialName);
            }
            this.patchNameText.addModifyListener(listener);
            label = new Label((Composite)patchPropertiesGroup, 0);
            label.setText(PDEPlugin.getResourceString(PATCH_PROVIDER));
            this.patchProviderText = new Text((Composite)patchPropertiesGroup, 2048);
            gd = new GridData(768);
            this.patchProviderText.setLayoutData((Object)gd);
            this.patchProviderText.addModifyListener(listener);
        }
        this.addFeatureProperties(container, listener);
        this.addCustomInstallHandlerSection(container, listener);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    private void addCustomInstallHandlerSection(Composite parent, ModifyListener listener) {
        Group customHandlerGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        customHandlerGroup.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        customHandlerGroup.setLayoutData((Object)gd);
        customHandlerGroup.setText(PDEPlugin.getResourceString("BaseFeatureSpecPage.customGroup"));
        this.customChoice = new Button((Composite)customHandlerGroup, 32);
        if (!this.isPatch()) {
            this.customChoice.setText(PDEPlugin.getResourceString(KEY_CUSTOM_INSTALL_HANDLER));
        } else {
            this.customChoice.setText(PDEPlugin.getResourceString(KEY_PATCH_CUSTOM_INSTALL_HANDLER));
        }
        this.customChoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.widget).getSelection();
                BaseFeatureSpecPage.this.libraryText.setEnabled(isSelected);
                BaseFeatureSpecPage.this.libraryLabel.setEnabled(isSelected);
                BaseFeatureSpecPage.this.verifyComplete();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.customChoice.setLayoutData((Object)gd);
        this.libraryLabel = new Label((Composite)customHandlerGroup, 0);
        this.libraryLabel.setText(PDEPlugin.getResourceString(KEY_LIBRARY));
        gd = new GridData();
        gd.horizontalIndent = 22;
        this.libraryLabel.setLayoutData((Object)gd);
        this.libraryText = new Text((Composite)customHandlerGroup, 2052);
        this.libraryText.setLayoutData((Object)new GridData(768));
        this.libraryText.addModifyListener(listener);
    }

    public boolean isPatch() {
        return this.isPatch;
    }

    protected abstract void verifyComplete();

    public String getInitialName() {
        return this.initialName;
    }

    public void setInitialName(String initialName) {
        this.initialName = initialName;
    }

    public void setInitialId(String initialId) {
        this.initialId = initialId;
    }

    public String getInitialId() {
        return this.initialId;
    }

    protected void initialize() {
        this.customChoice.setSelection(false);
        this.libraryText.setEnabled(false);
        this.libraryLabel.setEnabled(false);
    }

    private void addFeatureProperties(Composite container, ModifyListener listener) {
        Label label;
        Group featurePropertiesGroup = new Group(container, 0);
        GridLayout layout = new GridLayout(2, false);
        featurePropertiesGroup.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        featurePropertiesGroup.setLayoutData((Object)gd);
        if (this.isPatch()) {
            featurePropertiesGroup.setText(PDEPlugin.getResourceString("BaseFeatureSpecPage.patchGroup.title"));
            label = new Label((Composite)featurePropertiesGroup, 0);
            label.setText(PDEPlugin.getResourceString(FEATURE_ID));
            Composite patchcontainer = new Composite((Composite)featurePropertiesGroup, 0);
            layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 5;
            patchcontainer.setLayout((Layout)layout);
            gd = new GridData(768);
            gd.horizontalSpan = 1;
            patchcontainer.setLayoutData((Object)gd);
            this.featureIdText = new Text(patchcontainer, 2048);
            gd = new GridData(768);
            this.featureIdText.setLayoutData((Object)gd);
            if (this.initialId != null) {
                this.featureIdText.setText(this.initialId);
            }
            this.featureIdText.addModifyListener(listener);
            this.browseButton = new Button(patchcontainer, 8);
            this.browseButton.setText(PDEPlugin.getResourceString("BaseFeatureSpecPage.browse"));
            gd = new GridData(128);
            this.browseButton.setLayoutData((Object)gd);
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FeatureSelectionDialog dialog = new FeatureSelectionDialog(BaseFeatureSpecPage.this.getShell(), BaseFeatureSpecPage.this.getAllFeatureModels());
                    dialog.create();
                    if (dialog.open() == 0) {
                        Object[] result = dialog.getResult();
                        IFeatureModel selectedModel = (IFeatureModel)result[0];
                        BaseFeatureSpecPage.this.featureIdText.setText(selectedModel.getFeature().getId());
                        BaseFeatureSpecPage.this.featureNameText.setText(selectedModel.getFeature().getLabel());
                        BaseFeatureSpecPage.this.featureVersionText.setText(selectedModel.getFeature().getVersion());
                        BaseFeatureSpecPage.this.fFeatureToPatch = selectedModel;
                    }
                }
            });
            SWTUtil.setButtonDimensionHint(this.browseButton);
        } else {
            featurePropertiesGroup.setText(PDEPlugin.getResourceString("BaseFeatureSpecPage.featurePropertiesGroup.title"));
            label = new Label((Composite)featurePropertiesGroup, 0);
            label.setText(PDEPlugin.getResourceString(FEATURE_ID));
            this.featureIdText = new Text((Composite)featurePropertiesGroup, 2048);
            gd = new GridData(768);
            this.featureIdText.setLayoutData((Object)gd);
            if (this.initialId != null) {
                this.featureIdText.setText(this.initialId);
            }
            this.featureIdText.addModifyListener(listener);
        }
        label = new Label((Composite)featurePropertiesGroup, 0);
        label.setText(PDEPlugin.getResourceString(FEATURE_NAME));
        this.featureNameText = new Text((Composite)featurePropertiesGroup, 2048);
        gd = new GridData(768);
        this.featureNameText.setLayoutData((Object)gd);
        if (this.initialName != null) {
            this.featureNameText.setText(this.initialName);
        }
        this.featureNameText.addModifyListener(listener);
        label = new Label((Composite)featurePropertiesGroup, 0);
        label.setText(PDEPlugin.getResourceString(FEATURE_VERSION));
        this.featureVersionText = new Text((Composite)featurePropertiesGroup, 2048);
        gd = new GridData(768);
        this.featureVersionText.setLayoutData((Object)gd);
        this.featureVersionText.addModifyListener(listener);
        if (!this.isPatch()) {
            label = new Label((Composite)featurePropertiesGroup, 0);
            label.setText(PDEPlugin.getResourceString(FEATURE_PROVIDER));
            this.featureProviderText = new Text((Composite)featurePropertiesGroup, 2048);
            gd = new GridData(768);
            this.featureProviderText.setLayoutData((Object)gd);
            this.featureProviderText.addModifyListener(listener);
        }
    }

    protected String computeInitialId(String projectName) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(projectName, ".");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            int i = 0;
            while (i < token.length()) {
                if (Character.isLetterOrDigit(token.charAt(i))) {
                    buffer.append(token.charAt(i));
                }
                ++i;
            }
            if (!stok.hasMoreTokens() || buffer.charAt(buffer.length() - 1) == '.') continue;
            buffer.append(".");
        }
        return buffer.toString();
    }

    protected String verifyVersion() {
        String problemText = PDEPlugin.getResourceString(KEY_VERSION_FORMAT);
        String value = this.featureVersionText.getText();
        if (value.length() == 0) {
            return problemText;
        }
        try {
            new PluginVersionIdentifier(value);
        }
        catch (Throwable throwable) {
            return problemText;
        }
        return null;
    }

    protected String verifyIdRules() {
        String problemText = PDEPlugin.getResourceString(KEY_INVALID_ID);
        String name = this.featureIdText.getText();
        if (name == null || name.length() == 0) {
            return PDEPlugin.getResourceString(KEY_MISSING);
        }
        StringTokenizer stok = new StringTokenizer(name, ".");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            int i = 0;
            while (i < token.length()) {
                if (!Character.isLetterOrDigit(token.charAt(i))) {
                    return problemText;
                }
                ++i;
            }
        }
        return null;
    }

    public IFeatureModel getFeatureToPatch() {
        return this.fFeatureToPatch;
    }

    public IFeatureModel[] getAllFeatureModels() {
        IPath targetPath = ExternalModelManager.getEclipseHome();
        File mainFeatureDir = targetPath.append("features").toFile();
        if (!mainFeatureDir.exists() || !mainFeatureDir.isDirectory()) {
            return null;
        }
        File[] featureDirs = mainFeatureDir.listFiles();
        PluginVersionIdentifier bestVid = null;
        File bestDir = null;
        ArrayList<Object> allModels = new ArrayList<Object>();
        int i = 0;
        while (i < featureDirs.length) {
            block14: {
                block13: {
                    bestVid = null;
                    bestDir = null;
                    File featureDir = featureDirs[i];
                    String name = featureDir.getName();
                    if (!featureDir.isDirectory()) break block13;
                    int loc = name.lastIndexOf("_");
                    if (loc == -1) break block14;
                    String version = name.substring(loc + 1);
                    PluginVersionIdentifier vid = new PluginVersionIdentifier(version);
                    if (bestVid == null || vid.isGreaterThan(bestVid)) {
                        bestVid = vid;
                        bestDir = featureDir;
                    }
                }
                if (bestVid == null) {
                    return null;
                }
                File manifest = new File(bestDir, "feature.xml");
                ExternalFeatureModel model = new ExternalFeatureModel();
                model.setInstallLocation(bestDir.getAbsolutePath());
                FileInputStream stream = null;
                boolean error = false;
                try {
                    stream = new FileInputStream(manifest);
                    model.load((InputStream)stream, false);
                }
                catch (Exception exception) {
                    error = true;
                }
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                if (!error && model.isLoaded()) {
                    allModels.add(model);
                }
            }
            ++i;
        }
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        IFeatureModel[] workspaceModels = mng.getFeatureModels();
        int i2 = 0;
        while (i2 < workspaceModels.length) {
            if (!this.isFeatureIncluded(allModels, workspaceModels[i2])) {
                allModels.add(workspaceModels[i2]);
            }
            ++i2;
        }
        return allModels.toArray(new IFeatureModel[allModels.size()]);
    }

    protected boolean isFeatureIncluded(ArrayList models, IFeatureModel workspaceModel) {
        int i = 0;
        while (i < models.size()) {
            IFeatureModel model;
            if (models.get(i) instanceof IFeatureModel && (model = (IFeatureModel)models.get(i)).getFeature().getId().equals(workspaceModel.getFeature().getId()) && model.getFeature().getVersion().equals(workspaceModel.getFeature().getVersion())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getInstallHandlerLibrary() {
        if (!this.customChoice.getSelection()) {
            return null;
        }
        String library = this.libraryText.getText();
        if (!(library.endsWith(".jar") || library.endsWith("/") || library.equals("."))) {
            library = String.valueOf(library) + "/";
        }
        return library;
    }
}

