/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.ui.PDEPlugin;

public class UpdateClasspathJob
extends Job {
    private static final String KEY_JOB_TITLE = "UpdateClasspathJob.title";
    private static final String KEY_TITLE = "UpdateClasspathJob.error.title";
    private static final String KEY_MESSAGE = "UpdateClasspathJob.error.message";
    private static final String KEY_UPDATE = "UpdateClasspathJob.task";
    IPluginModelBase[] fModels;

    public UpdateClasspathJob(IPluginModelBase[] models) {
        super(PDEPlugin.getResourceString(KEY_JOB_TITLE));
        this.setPriority(30);
        this.fModels = models;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doUpdateClasspath(IProgressMonitor monitor, IPluginModelBase[] models) throws CoreException {
        block8: {
            block7: {
                monitor.beginTask(PDEPlugin.getResourceString(KEY_UPDATE), models.length);
                try {
                    int i = 0;
                    while (i < models.length) {
                        IPluginModelBase model = models[i];
                        monitor.subTask(models[i].getPluginBase().getId());
                        IProject project = model.getUnderlyingResource().getProject();
                        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                            monitor.worked(1);
                        } else {
                            ClasspathUtilCore.setClasspath((IPluginModelBase)model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            if (monitor.isCanceled()) {
                                Object var6_6 = null;
                                break block7;
                            }
                        }
                        ++i;
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return false;
        }
        Object var6_8 = null;
        monitor.done();
        return true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            UpdateClasspathWorkspaceRunnable runnable = new UpdateClasspathWorkspaceRunnable();
            PDEPlugin.getWorkspace().run((IWorkspaceRunnable)runnable, monitor);
            if (runnable.isCanceled()) {
                return new Status(8, "org.eclipse.pde.ui", 8, "", null);
            }
        }
        catch (CoreException e) {
            String title = PDEPlugin.getResourceString(KEY_TITLE);
            String message = PDEPlugin.getResourceString(KEY_MESSAGE);
            PDEPlugin.logException(e, title, message);
            return new Status(4, "org.eclipse.pde.ui", 0, message, (Throwable)e);
        }
        return new Status(0, "org.eclipse.pde.ui", 0, "", null);
    }

    class UpdateClasspathWorkspaceRunnable
    implements IWorkspaceRunnable {
        boolean fCanceled = false;

        UpdateClasspathWorkspaceRunnable() {
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            this.fCanceled = UpdateClasspathJob.this.doUpdateClasspath(monitor, UpdateClasspathJob.this.fModels);
        }

        public boolean isCanceled() {
            return this.fCanceled;
        }
    }
}

