/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfFont;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;

class PdfChunk
implements SplitCharacter {
    private static final HashMap keysAttributes = new HashMap();
    private static final HashMap keysNoStroke = new HashMap();
    protected String value = "";
    protected String encoding = "PDF";
    protected PdfFont font;
    protected HashMap attributes = new HashMap();
    protected HashMap noStroke = new HashMap();
    protected boolean newlineSplit;
    protected Image image;
    protected float offsetX;
    protected float offsetY;
    protected boolean changeLeading = false;

    private PdfChunk(String string, PdfFont pdfFont, HashMap hashMap, HashMap hashMap2) {
        this.value = string;
        this.font = pdfFont;
        this.attributes = hashMap;
        this.noStroke = hashMap2;
        Object[] objectArray = (Object[])hashMap.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.encoding = pdfFont.getFont().getEncoding();
    }

    PdfChunk(Chunk chunk, PdfAction pdfAction) {
        BaseFont baseFont;
        this.value = chunk.content();
        Font font = chunk.font();
        float f = font.size();
        if (f == -1.0f) {
            f = 12.0f;
        }
        if ((baseFont = font.getBaseFont()) == null) {
            int n;
            int n2 = font.style();
            if (n2 == -1) {
                n2 = 0;
            }
            block0 : switch (font.family()) {
                case 0: {
                    switch (n2 & 3) {
                        case 1: {
                            n = 1;
                            break block0;
                        }
                        case 2: {
                            n = 2;
                            break block0;
                        }
                        case 3: {
                            n = 3;
                            break block0;
                        }
                    }
                    n = 0;
                    break;
                }
                case 2: {
                    switch (n2 & 3) {
                        case 1: {
                            n = 10;
                            break block0;
                        }
                        case 2: {
                            n = 11;
                            break block0;
                        }
                        case 3: {
                            n = 12;
                            break block0;
                        }
                    }
                    n = 9;
                    break;
                }
                case 3: {
                    n = 8;
                    break;
                }
                case 4: {
                    n = 13;
                    break;
                }
                default: {
                    switch (n2 & 3) {
                        case 1: {
                            n = 5;
                            break block0;
                        }
                        case 2: {
                            n = 6;
                            break block0;
                        }
                        case 3: {
                            n = 7;
                            break block0;
                        }
                    }
                    n = 4;
                }
            }
            this.font = new PdfFont(n, f);
        } else {
            this.font = new PdfFont(baseFont, f);
        }
        HashMap hashMap = chunk.getAttributes();
        if (hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (keysAttributes.containsKey(k)) {
                    this.attributes.put(k, hashMap.get(k));
                    continue;
                }
                if (!keysNoStroke.containsKey(k)) continue;
                this.noStroke.put(k, hashMap.get(k));
            }
            if ("".equals(hashMap.get("GENERICTAG"))) {
                this.attributes.put("GENERICTAG", chunk.content());
            }
        }
        if (font.isUnderlined()) {
            this.attributes.put("UNDERLINE", null);
        }
        if (font.isStrikethru()) {
            this.attributes.put("STRIKETHRU", null);
        }
        if (pdfAction != null) {
            this.attributes.put("ACTION", pdfAction);
        }
        this.noStroke.put("COLOR", font.color());
        this.noStroke.put("ENCODING", this.font.getFont().getEncoding());
        Object[] objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.font.setImage(this.image);
        this.encoding = this.font.getFont().getEncoding();
    }

    protected int getWord(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            if (!Character.isLetter(string.charAt(n))) break;
            ++n;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    PdfChunk split(float var1_1) {
        block20: {
            this.newlineSplit = false;
            if (this.image != null) {
                if (this.image.scaledWidth() > var1_1) {
                    var2_2 = new PdfChunk("*", this.font, this.attributes, this.noStroke);
                    this.value = "";
                    this.attributes = new HashMap<K, V>();
                    this.image = null;
                    this.font = new PdfFont(4, 12.0f);
                    return var2_2;
                }
                return null;
            }
            var2_3 = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
            if (var2_3 == null) {
                var2_3 = this;
            }
            var3_4 = (HyphenationEvent)this.noStroke.get("HYPHENATION");
            var4_5 = 0;
            var5_6 = -1;
            var6_7 = 0.0f;
            var7_8 = -1;
            var8_9 = 0.0f;
            var9_10 = this.value.length();
            var10_11 = '\u0000';
            var11_12 = this.font.getFont();
            if (var11_12.getFontType() != 2 || var11_12.getUnicodeEquivalent(' ') == ' ') ** GOTO lbl66
            while (var4_5 < var9_10) {
                var12_13 = this.value.charAt(var4_5);
                var10_11 = var11_12.getUnicodeEquivalent(var12_13);
                if (var10_11 == '\n') {
                    this.newlineSplit = true;
                    var13_17 = this.value.substring(var4_5 + 1);
                    this.value = this.value.substring(0, var4_5);
                    if (this.value.length() < 1) {
                        this.value = "\u0001";
                    }
                    var14_21 = new PdfChunk(var13_17, this.font, this.attributes, this.noStroke);
                    return var14_21;
                }
                var6_7 += this.font.width(var12_13);
                if (var10_11 == ' ') {
                    var7_8 = var4_5 + 1;
                    var8_9 = var6_7;
                }
                if (!(var6_7 > var1_1)) {
                    if (var2_3.isSplitCharacter(var10_11)) {
                        var5_6 = var4_5 + 1;
                    }
                    ++var4_5;
                    continue;
                }
                break block20;
            }
            break block20;
lbl-1000:
            // 1 sources

            {
                var10_11 = this.value.charAt(var4_5);
                if (var10_11 == '\r' || var10_11 == '\n') {
                    this.newlineSplit = true;
                    var12_14 = 1;
                    if (var10_11 == '\r' && var4_5 + 1 < var9_10 && this.value.charAt(var4_5 + 1) == '\n') {
                        var12_14 = 2;
                    }
                    var13_18 = this.value.substring(var4_5 + var12_14);
                    this.value = this.value.substring(0, var4_5);
                    if (this.value.length() < 1) {
                        this.value = " ";
                    }
                    var14_22 = new PdfChunk(var13_18, this.font, this.attributes, this.noStroke);
                    return var14_22;
                }
                var6_7 += this.font.width(var10_11);
                if (var10_11 == ' ') {
                    var7_8 = var4_5 + 1;
                    var8_9 = var6_7;
                }
                if (var6_7 > var1_1) break;
                if (var2_3.isSplitCharacter(var10_11)) {
                    var5_6 = var4_5 + 1;
                }
                ++var4_5;
lbl66:
                // 2 sources

                ** while (var4_5 < var9_10)
            }
        }
        if (var4_5 == var9_10) {
            return null;
        }
        if (var5_6 < 0) {
            var12_15 = this.value;
            this.value = "";
            var13_19 = new PdfChunk(var12_15, this.font, this.attributes, this.noStroke);
            return var13_19;
        }
        if (var7_8 > var5_6 && var2_3.isSplitCharacter(' ')) {
            var5_6 = var7_8;
        }
        if (var3_4 != null && var7_8 < var4_5 && (var12_13 = this.getWord(this.value, var7_8)) > var7_8) {
            var13_20 = var3_4.getHyphenatedWordPre(this.value.substring(var7_8, var12_13), this.font.getFont(), this.font.size(), var1_1 - var8_9);
            var14_23 = var3_4.getHyphenatedWordPost();
            if (var14_23.length() > 0) {
                var15_24 = var14_23 + this.value.substring(var12_13);
                this.value = this.trim(this.value.substring(0, var7_8) + (String)var13_20);
                var16_25 = new PdfChunk(var15_24, this.font, this.attributes, this.noStroke);
                return var16_25;
            }
        }
        var12_16 = this.value.substring(var5_6);
        this.value = this.trim(this.value.substring(0, var5_6));
        var13_20 = new PdfChunk(var12_16, this.font, this.attributes, this.noStroke);
        return var13_20;
    }

    PdfChunk truncate(float f) {
        if (this.image != null) {
            if (this.image.scaledWidth() > f) {
                PdfChunk pdfChunk = new PdfChunk("", this.font, this.attributes, this.noStroke);
                this.value = "";
                this.attributes.remove("IMAGE");
                this.image = null;
                this.font = new PdfFont(4, 12.0f);
                return pdfChunk;
            }
            return null;
        }
        int n = 0;
        float f2 = 0.0f;
        if (f < this.font.width()) {
            String string = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            PdfChunk pdfChunk = new PdfChunk(string, this.font, this.attributes, this.noStroke);
            return pdfChunk;
        }
        int n2 = this.value.length();
        while (n < n2) {
            char c = this.value.charAt(n);
            if ((f2 += this.font.width(c)) > f) break;
            ++n;
        }
        if (n == n2) {
            return null;
        }
        if (n == 0) {
            n = 1;
        }
        String string = this.value.substring(n);
        this.value = this.value.substring(0, n);
        PdfChunk pdfChunk = new PdfChunk(string, this.font, this.attributes, this.noStroke);
        return pdfChunk;
    }

    PdfFont font() {
        return this.font;
    }

    Color color() {
        return (Color)this.noStroke.get("COLOR");
    }

    float width() {
        if (this.image != null) {
            return this.image.scaledWidth();
        }
        return this.font.getFont().getWidthPoint(this.value, this.font.size());
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    public float getWidthCorrected(float f, float f2) {
        if (this.image != null) {
            return this.image.scaledWidth() + f;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = this.value.indexOf(32, n2 + 1)) >= 0) {
            ++n;
        }
        return this.font.getFont().getWidthPoint(this.value, this.font.size()) + (float)this.value.length() * f + (float)n * f2;
    }

    public float trimLastSpace() {
        BaseFont baseFont = this.font.getFont();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(' ') != ' ') {
            if (this.value.length() > 1 && this.value.endsWith("\u0001")) {
                this.value = this.value.substring(0, this.value.length() - 1);
                return this.font.width('\u0001');
            }
        } else if (this.value.length() > 1 && this.value.endsWith(" ")) {
            this.value = this.value.substring(0, this.value.length() - 1);
            return this.font.width(' ');
        }
        return 0.0f;
    }

    Object getAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return this.attributes.get(string);
        }
        return this.noStroke.get(string);
    }

    boolean isAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return true;
        }
        return this.noStroke.containsKey(string);
    }

    boolean isStroked() {
        return this.attributes.size() > 0;
    }

    boolean isImage() {
        return this.image != null;
    }

    Image getImage() {
        return this.image;
    }

    void setImageOffsetX(float f) {
        this.offsetX = f;
    }

    float getImageOffsetX() {
        return this.offsetX;
    }

    void setImageOffsetY(float f) {
        this.offsetY = f;
    }

    float getImageOffsetY() {
        return this.offsetY;
    }

    void setValue(String string) {
        this.value = string;
    }

    public String toString() {
        return this.value;
    }

    boolean isSpecialEncoding() {
        return this.encoding.equals("UnicodeBigUnmarked") || this.encoding.equals("Identity-H");
    }

    String getEncoding() {
        return this.encoding;
    }

    int length() {
        return this.value.length();
    }

    public boolean isSplitCharacter(char c) {
        if (c <= ' ' || c == '-') {
            return true;
        }
        if (c < '\u2e80') {
            return false;
        }
        return c >= '\u2e80' && c < '\ud7a0' || c >= '\uf900' && c < '\ufb00' || c >= '\ufe30' && c < '\ufe50' || c >= '\uff61' && c < '\uffa0';
    }

    /*
     * Unable to fully structure code
     */
    String trim(String var1_1) {
        block2: {
            var2_2 = this.font.getFont();
            if (var2_2.getFontType() != 2 || var2_2.getUnicodeEquivalent(' ') == ' ') ** GOTO lbl8
            while (var1_1.endsWith("\u0001")) {
                var1_1 = var1_1.substring(0, var1_1.length() - 1);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.substring(0, var1_1.length() - 1);
lbl8:
                // 2 sources

                ** while (var1_1.endsWith((String)" ") || var1_1.endsWith((String)"\t"))
            }
        }
        return var1_1;
    }

    public boolean changeLeading() {
        return this.changeLeading;
    }

    static {
        keysAttributes.put("ACTION", null);
        keysAttributes.put("STRIKETHRU", null);
        keysAttributes.put("UNDERLINE", null);
        keysAttributes.put("REMOTEGOTO", null);
        keysAttributes.put("LOCALGOTO", null);
        keysAttributes.put("LOCALDESTINATION", null);
        keysAttributes.put("GENERICTAG", null);
        keysAttributes.put("NEWPAGE", null);
        keysAttributes.put("IMAGE", null);
        keysAttributes.put("BACKGROUND", null);
        keysAttributes.put("PDFANNOTATION", null);
        keysNoStroke.put("SUBSUPSCRIPT", null);
        keysNoStroke.put("SPLITCHARACTER", null);
        keysNoStroke.put("HYPHENATION", null);
    }
}

