/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

class Atom
implements Cloneable {
    int modelNumber = 1;
    String elementSymbol;
    byte elementNumber = (byte)-1;
    String atomName;
    int formalCharge = Integer.MIN_VALUE;
    float partialCharge = Float.NaN;
    int scatterFactor = Integer.MIN_VALUE;
    float x = Float.NaN;
    float y = Float.NaN;
    float z = Float.NaN;
    float vectorX = Float.NaN;
    float vectorY = Float.NaN;
    float vectorZ = Float.NaN;
    float bfactor = Float.NaN;
    int occupancy = 100;
    boolean isHetero;
    int atomSerial = Integer.MIN_VALUE;
    char chainID = '\u0000';
    String group3;
    int sequenceNumber = Integer.MIN_VALUE;
    char insertionCode = '\u0000';
    String pdbAtomRecord;
    static final int[] elementCharMasks = new int[]{1972292, -2147351151, -2146019271, 0x1000008, 0x160000, -2147348464, 25, -2147205008, -2147344384, 0, -2147352576, 0x120101, 548936, -2147434213, -2147221504, -2145759221, 0, 1056947, -2147339946, 6551, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x800010, -2147483646, 139264};

    Atom() {
    }

    Atom cloneAtom() {
        try {
            return (Atom)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    String getElementSymbol() {
        if (this.elementSymbol == null && this.atomName != null) {
            int ichFirst;
            int len = this.atomName.length();
            char chFirst = '\u0000';
            for (ichFirst = 0; ichFirst < len && !Atom.isValidFirstSymbolChar(chFirst = this.atomName.charAt(ichFirst)); ++ichFirst) {
            }
            switch (len - ichFirst) {
                case 0: {
                    break;
                }
                default: {
                    char chSecond = this.atomName.charAt(ichFirst + 1);
                    if (Atom.isValidElementSymbol(chFirst, chSecond)) {
                        this.elementSymbol = "" + chFirst + chSecond;
                        break;
                    }
                }
                case 1: {
                    if (!Atom.isValidElementSymbol(chFirst)) break;
                    this.elementSymbol = "" + chFirst;
                }
            }
        }
        return this.elementSymbol;
    }

    static boolean isValidElementSymbol(char ch) {
        return ch >= 'A' && ch <= 'Z' && elementCharMasks[ch - 65] < 0;
    }

    static boolean isValidElementSymbol(char chFirst, char chSecond) {
        if (chFirst < 'A' || chFirst > 'Z' || chSecond < 'a' || chSecond > 'z') {
            return false;
        }
        return (elementCharMasks[chFirst - 65] >> chSecond - 97 & 1) != 0;
    }

    static boolean isValidElementSymbolNoCaseSecondChar(char chFirst, char chSecond) {
        if (chSecond >= 'A' && chSecond <= 'Z') {
            chSecond = (char)(chSecond + 32);
        }
        if (chFirst < 'A' || chFirst > 'Z' || chSecond < 'a' || chSecond > 'z') {
            return false;
        }
        return (elementCharMasks[chFirst - 65] >> chSecond - 97 & 1) != 0;
    }

    static boolean isValidFirstSymbolChar(char ch) {
        return ch >= 'A' && ch <= 'Z' && elementCharMasks[ch - 65] != 0;
    }
}

