/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Model;
import org.jmol.adapter.smarter.ModelReader;

class GamessReader
extends ModelReader {
    static final float angstromsPerBohr = 0.529177f;
    int atomCountInFirstModel;

    GamessReader() {
    }

    Model readModel(BufferedReader reader) throws Exception {
        this.model = new Model("gamess");
        try {
            this.discardLinesUntilContains(reader, "COORDINATES (BOHR)");
            this.readAtomsInBohrCoordinates(reader);
            this.discardLinesUntilContains(reader, "FREQUENCIES IN CM");
            this.readFrequencies(reader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.model.errorMessage = "Could not read file:" + ex;
            return this.model;
        }
        if (this.model.atomCount == 0) {
            this.model.errorMessage = "No atoms in file";
        }
        return this.model;
    }

    void readAtomsInBohrCoordinates(BufferedReader reader) throws Exception {
        String atomName;
        String line;
        reader.readLine();
        while ((line = reader.readLine()) != null && (atomName = this.parseToken(line, 1, 6)) != null) {
            float x = this.parseFloat(line, 17, 37);
            float y = this.parseFloat(line, 37, 57);
            float z = this.parseFloat(line, 57, 77);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) break;
            Atom atom = this.model.addNewAtom();
            atom.atomName = atomName;
            atom.x = x * 0.529177f;
            atom.y = y * 0.529177f;
            atom.z = z * 0.529177f;
        }
    }

    void readFrequencies(BufferedReader reader) throws Exception {
        int totalFrequencyCount = 0;
        this.atomCountInFirstModel = this.model.atomCount;
        float[] frequencies = new float[5];
        float[] xComponents = new float[5];
        float[] yComponents = new float[5];
        float[] zComponents = new float[5];
        String line = this.discardLinesUntilContains(reader, "FREQUENCY:");
        do {
            float frequency;
            int lineFreqCount;
            int lineBaseFreqCount = totalFrequencyCount;
            this.ichNextParse = 17;
            for (lineFreqCount = 0; lineFreqCount < 5 && !Float.isNaN(frequency = this.parseFloat(line, this.ichNextParse)); ++lineFreqCount) {
                if (++totalFrequencyCount <= 1) continue;
                this.createNewModel(totalFrequencyCount);
            }
            Atom[] atoms = this.model.atoms;
            this.discardLinesUntilBlank(reader);
            for (int i = 0; i < this.atomCountInFirstModel; ++i) {
                this.readComponents(reader.readLine(), lineFreqCount, xComponents);
                this.readComponents(reader.readLine(), lineFreqCount, yComponents);
                this.readComponents(reader.readLine(), lineFreqCount, zComponents);
                for (int j = 0; j < lineFreqCount; ++j) {
                    int atomIndex = (lineBaseFreqCount + j) * this.atomCountInFirstModel + i;
                    Atom atom = atoms[atomIndex];
                    atom.vectorX = xComponents[j];
                    atom.vectorY = yComponents[j];
                    atom.vectorZ = zComponents[j];
                }
            }
            this.discardLines(reader, 12);
        } while ((line = reader.readLine()).indexOf("FREQUENCY:") > 0);
    }

    void readComponents(String line, int count, float[] components) {
        int i = 0;
        int start = 20;
        while (i < count) {
            components[i] = this.parseFloat(line, start, start + 12);
            ++i;
            start += 12;
        }
    }

    void createNewModel(int modelNumber) {
        Atom[] atoms = this.model.atoms;
        for (int i = 0; i < this.atomCountInFirstModel; ++i) {
            Atom atomNew = this.model.newCloneAtom(atoms[i]);
            atomNew.modelNumber = modelNumber;
        }
    }
}

