/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.LimitedLineReader;
import org.jmol.adapter.smarter.Model;
import org.jmol.adapter.smarter.ModelReader;
import org.jmol.api.ModelAdapter;

class ModelResolver {
    static final String[] pdbRecords = new String[]{"HEADER", "OBSLTE", "TITLE ", "CAVEAT", "COMPND", "SOURCE", "KEYWDS", "EXPDTA", "AUTHOR", "REVDAT", "SPRSDE", "JRNL  ", "REMARK", "DBREF ", "SEQADV", "SEQRES", "MODRES", "HELIX ", "SHEET ", "TURN  ", "CRYST1", "ORIGX1", "ORIGX2", "ORIGX3", "SCALE1", "SCALE2", "SCALE3", "ATOM  ", "HETATM", "MODEL "};
    static final String[] shelxRecords = new String[]{"TITL ", "ZERR ", "LATT ", "SYMM ", "CELL "};
    static final String[] cifRecords = new String[]{"data_"};
    static final String[] ghemicalMMRecords = new String[]{"!Header mm1gp", "!Header gpr"};
    static final String[] jaguarRecords = new String[]{"  |  Jaguar version"};
    static final String[] hinRecords = new String[]{"mol "};
    static final String[] mdlRecords = new String[]{"$MDL "};
    static final String[][] startsWithRecords = new String[][]{pdbRecords, shelxRecords, cifRecords, ghemicalMMRecords, jaguarRecords, hinRecords, mdlRecords};
    static final String[] startsWithFormats = new String[]{"Pdb", "Shelx", "Cif", "GhemicalMM", "Jaguar", "Hin", "Mol"};
    static final String[] cmlRecords = new String[]{"<?xml", "<atom", "<molecule", "<reaction", "<cml", "<bond", ".dtd\"", "<list>", "<entry", "<identifier", "http://www.xml-cml.org/schema/cml2/core"};
    static final String[] gaussianRecords = new String[]{"Entering Gaussian System", "1998 Gaussian, Inc."};
    static final String[] mopacRecords = new String[]{"MOPAC 93 (c) Fujitsu", "MOPAC2002 (c) Fujitsu"};
    static final String[] qchemRecords = new String[]{"Welcome to Q-Chem", "A Quantum Leap Into The Future Of Chemistry"};
    static final String[] gamessRecords = new String[]{"GAMESS"};
    static final String[] spartanRecords = new String[]{"Spartan"};
    static final String[][] containsRecords = new String[][]{cmlRecords, gaussianRecords, mopacRecords, qchemRecords, gamessRecords, spartanRecords};
    static final String[] containsFormats = new String[]{"Cml", "Gaussian", "Mopac", "Qchem", "Gamess", "Spartan"};

    ModelResolver() {
    }

    static Object resolveModel(String name, BufferedReader bufferedReader, ModelAdapter.Logger logger) throws Exception {
        ModelReader modelReader;
        String modelReaderName = ModelResolver.determineModelReader(bufferedReader, logger);
        logger.log("The model resolver thinks", modelReaderName);
        String className = "org.jmol.adapter.smarter." + modelReaderName + "Reader";
        if (modelReaderName == null) {
            return "unrecognized file format";
        }
        try {
            Class<?> modelReaderClass = Class.forName(className);
            modelReader = (ModelReader)modelReaderClass.newInstance();
        }
        catch (Exception e) {
            String err = "Could not instantiate:" + className;
            logger.log(err);
            return err;
        }
        modelReader.setLogger(logger);
        modelReader.initialize();
        Model model = modelReader.readModel(bufferedReader);
        if (model.errorMessage != null) {
            return model.errorMessage;
        }
        if (model.atomCount == 0) {
            return "No atoms in file";
        }
        return model;
    }

    static String determineModelReader(BufferedReader bufferedReader, ModelAdapter.Logger logger) throws Exception {
        String[] lines = new String[4];
        LimitedLineReader llr = new LimitedLineReader(bufferedReader, 2048);
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = llr.readLineWithNewline();
        }
        if (lines[3].length() >= 6) {
            String line4trimmed = lines[3].trim();
            if (line4trimmed.endsWith("V2000") || line4trimmed.endsWith("v2000") || line4trimmed.endsWith("V3000")) {
                return "Mol";
            }
            try {
                Integer.parseInt(lines[3].substring(0, 3).trim());
                Integer.parseInt(lines[3].substring(3, 6).trim());
                return "Mol";
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        try {
            int atomCount = Integer.parseInt(lines[0].trim());
            return "Xyz";
        }
        catch (NumberFormatException e) {
            int k;
            String recordTag;
            int j;
            String[] recordTags;
            int i;
            for (i = 0; i < startsWithRecords.length; ++i) {
                recordTags = startsWithRecords[i];
                for (j = 0; j < recordTags.length; ++j) {
                    recordTag = recordTags[j];
                    for (k = 0; k < lines.length; ++k) {
                        if (!lines[k].startsWith(recordTag)) continue;
                        return startsWithFormats[i];
                    }
                }
            }
            for (i = 0; i < containsRecords.length; ++i) {
                recordTags = containsRecords[i];
                for (j = 0; j < recordTags.length; ++j) {
                    recordTag = recordTags[j];
                    for (k = 0; k < lines.length; ++k) {
                        if (lines[k].indexOf(recordTag) == -1) continue;
                        return containsFormats[i];
                    }
                }
            }
            if (lines[1] == null || lines[1].trim().length() == 0) {
                return "Jme";
            }
            return null;
        }
    }
}

