/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Model;
import org.jmol.adapter.smarter.ModelReader;

class XyzReader
extends ModelReader {
    final float[] chargeAndOrVector = new float[4];
    final boolean[] isNaN = new boolean[4];

    XyzReader() {
    }

    Model readModel(BufferedReader reader) throws Exception {
        this.model = new Model("xyz");
        try {
            int modelAtomCount;
            int modelNumber = 1;
            while ((modelAtomCount = this.readAtomCount(reader)) > 0) {
                if (modelNumber == 1) {
                    this.model.setModelName(reader.readLine());
                } else {
                    reader.readLine();
                }
                this.readAtoms(reader, modelNumber, modelAtomCount);
                ++modelNumber;
            }
        }
        catch (Exception ex) {
            this.model.errorMessage = "Could not read file:" + ex;
        }
        return this.model;
    }

    int readAtomCount(BufferedReader reader) throws Exception {
        int atomCount;
        String line = reader.readLine();
        if (line != null && (atomCount = this.parseInt(line)) > 0) {
            return atomCount;
        }
        return 0;
    }

    void readAtoms(BufferedReader reader, int modelNumber, int modelAtomCount) throws Exception {
        for (int i = 0; i < modelAtomCount; ++i) {
            String line = reader.readLine();
            Atom atom = this.model.addNewAtom();
            atom.modelNumber = modelNumber;
            atom.elementSymbol = this.parseToken(line);
            atom.x = this.parseFloat(line, this.ichNextParse);
            atom.y = this.parseFloat(line, this.ichNextParse);
            atom.z = this.parseFloat(line, this.ichNextParse);
            for (int j = 0; j < 4; ++j) {
                this.chargeAndOrVector[j] = this.parseFloat(line, this.ichNextParse);
                this.isNaN[j] = Float.isNaN(this.chargeAndOrVector[j]);
            }
            if (this.isNaN[0]) continue;
            if (this.isNaN[1]) {
                atom.formalCharge = (int)this.chargeAndOrVector[0];
                continue;
            }
            if (this.isNaN[3]) {
                atom.vectorX = this.chargeAndOrVector[0];
                atom.vectorY = this.chargeAndOrVector[1];
                atom.vectorZ = this.chargeAndOrVector[2];
                continue;
            }
            atom.formalCharge = (int)this.chargeAndOrVector[0];
            atom.vectorX = this.chargeAndOrVector[1];
            atom.vectorY = this.chargeAndOrVector[2];
            atom.vectorZ = this.chargeAndOrVector[3];
        }
    }
}

