/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;

class Sphere3D {
    Graphics3D g3d;
    byte[] semicircles;
    int[] semicircleIndex;
    static final int numFoo = 512;
    static final int shiftDivFoo = 9;
    short[] heightsFoo;
    static final int maxSphereCache = 128;
    static int[][] sphereShapeCache = new int[128][];
    byte[] intensities = new byte[16384];
    byte[] heights = new byte[16384];

    Sphere3D(Graphics3D g3d) {
        this.g3d = g3d;
    }

    void renderBigUnclipped(int[] shades, int diameter, int x, int y, int z) {
        int radius = diameter / 2;
        x -= radius;
        y -= radius;
        float r = (float)diameter / 2.0f;
        float r2 = r * r;
        float yF = -r + 0.5f;
        int zMin = z - (diameter + 1 >> 1);
        int width = this.g3d.width;
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int y0 = y;
        int offsetPbufBeginLine = width * y + x;
        int i = 0;
        while (i < diameter) {
            float y2 = yF * yF;
            float xF = -r + 0.5f;
            int x0 = x;
            int offsetPbuf = offsetPbufBeginLine;
            int j = 0;
            while (j < diameter) {
                float zF;
                int z0;
                float z2;
                if (zbuf[offsetPbuf] > zMin && (z2 = r2 - y2 - xF * xF) >= 0.0f && zbuf[offsetPbuf] > (z0 = z - (int)((zF = (float)Math.sqrt(z2)) + 0.5f))) {
                    byte intensity = Shade3D.calcDitheredNoisyIntensity(xF, yF, zF);
                    pbuf[offsetPbuf] = shades[intensity];
                    zbuf[offsetPbuf] = (short)z0;
                }
                ++j;
                ++x0;
                xF += 1.0f;
                ++offsetPbuf;
            }
            ++i;
            ++y0;
            yF += 1.0f;
            offsetPbufBeginLine += width;
        }
    }

    void renderBigClipped(int[] shades, int diameter, int x, int y, int z) {
        int radius = diameter / 2;
        x -= radius;
        y -= radius;
        float r = (float)diameter / 2.0f;
        float r2 = r * r;
        float yF = -r + 0.5f;
        int zMin = z - (diameter + 1 >> 1);
        int width = this.g3d.width;
        int height = this.g3d.height;
        int slab = this.g3d.slab;
        int depth = this.g3d.depth;
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int y0 = y;
        int offsetPbufBeginLine = width * y + x;
        int i = 0;
        while (i < diameter) {
            if (y0 >= 0 && y0 < height) {
                float y2 = yF * yF;
                float xF = -r + 0.5f;
                int x0 = x;
                int offsetPbuf = offsetPbufBeginLine;
                int j = 0;
                while (j < diameter) {
                    float zF;
                    int z0;
                    float z2;
                    if (x0 >= 0 && x0 < this.g3d.width && zbuf[offsetPbuf] > zMin && (z2 = r2 - y2 - xF * xF) >= 0.0f && (z0 = z - (int)((zF = (float)Math.sqrt(z2)) + 0.5f)) >= slab && z0 <= depth && z0 < zbuf[offsetPbuf]) {
                        byte intensity = Shade3D.calcDitheredNoisyIntensity(xF, yF, zF);
                        pbuf[offsetPbuf] = shades[intensity];
                        zbuf[offsetPbuf] = (short)z0;
                    }
                    ++j;
                    ++x0;
                    xF += 1.0f;
                    ++offsetPbuf;
                }
            }
            ++i;
            ++y0;
            yF += 1.0f;
            offsetPbufBeginLine += width;
        }
    }

    void render(short colix, int diameter, int x, int y, int z) {
        boolean clipped;
        int[] shades = this.g3d.getShades(colix);
        int radius = diameter + 1 >> 1;
        int minX = x - radius;
        int maxX = x + radius;
        int minY = y - radius;
        int maxY = y + radius;
        int minZ = z - radius;
        if (maxX < 0 || minX >= this.g3d.width || maxY < 0 || minY >= this.g3d.height || z < this.g3d.slab || minZ > this.g3d.depth) {
            return;
        }
        boolean bl = clipped = minX < 0 || maxX >= this.g3d.width || minY < 0 || maxY >= this.g3d.height || minZ < this.g3d.slab || z > this.g3d.depth;
        if (diameter >= 128) {
            if (clipped) {
                this.renderBigClipped(shades, diameter, x, y, z);
            } else {
                this.renderBigUnclipped(shades, diameter, x, y, z);
            }
            return;
        }
        int[] ss = this.getSphereShape(diameter);
        if (clipped) {
            this.renderShapeClipped(shades, ss, diameter, x, y, z);
        } else {
            this.renderShapeUnclipped(shades, ss, diameter, x, y, z);
        }
    }

    void renderShapeUnclipped(int[] shades, int[] sphereShape, int diameter, int x, int y, int z) {
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int offsetSphere = 0;
        int width = this.g3d.width;
        int evenSizeCorrection = 1 - (diameter & 1);
        int offsetSouthCenter = width * y + x;
        int offsetNorthCenter = offsetSouthCenter - evenSizeCorrection * width;
        int nLines = (diameter + 1) / 2;
        do {
            int packed;
            int offsetSE = offsetSouthCenter;
            int offsetSW = offsetSouthCenter - evenSizeCorrection;
            int offsetNE = offsetNorthCenter;
            int offsetNW = offsetNorthCenter - evenSizeCorrection;
            do {
                int zPixel;
                if ((zPixel = z - ((packed = sphereShape[offsetSphere++]) & 0x7F)) <= zbuf[offsetSE]) {
                    if (zPixel < zbuf[offsetSE]) {
                        zbuf[offsetSE] = (short)zPixel;
                        pbuf[offsetSE] = shades[packed >> 7 & 0x3F];
                    } else {
                        this.g3d.averageOffsetArgb(offsetSE, shades[packed >> 7 & 0x3F]);
                    }
                }
                if (zPixel <= zbuf[offsetSW]) {
                    if (zPixel < zbuf[offsetSW]) {
                        zbuf[offsetSW] = (short)zPixel;
                        pbuf[offsetSW] = shades[packed >> 13 & 0x3F];
                    } else {
                        this.g3d.averageOffsetArgb(offsetSW, shades[packed >> 13 & 0x3F]);
                    }
                }
                if (zPixel <= zbuf[offsetNE]) {
                    if (zPixel < zbuf[offsetNE]) {
                        zbuf[offsetNE] = (short)zPixel;
                        pbuf[offsetNE] = shades[packed >> 19 & 0x3F];
                    } else {
                        this.g3d.averageOffsetArgb(offsetNE, shades[packed >> 19 & 0x3F]);
                    }
                }
                if (zPixel < zbuf[offsetNW]) {
                    if (zPixel < zbuf[offsetNW]) {
                        zbuf[offsetNW] = (short)zPixel;
                        pbuf[offsetNW] = shades[packed >> 25 & 0x3F];
                    } else {
                        this.g3d.averageOffsetArgb(offsetNW, shades[packed >> 25 & 0x3F]);
                    }
                }
                ++offsetSE;
                --offsetSW;
                ++offsetNE;
                --offsetNW;
            } while (packed >= 0);
            offsetSouthCenter += width;
            offsetNorthCenter -= width;
        } while (--nLines > 0);
    }

    void renderShapeClipped(int[] shades, int[] sphereShape, int diameter, int x, int y, int z) {
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int offsetSphere = 0;
        int width = this.g3d.width;
        int height = this.g3d.height;
        int slab = this.g3d.slab;
        int depth = this.g3d.depth;
        int evenSizeCorrection = 1 - (diameter & 1);
        int offsetSouthCenter = width * y + x;
        int offsetNorthCenter = offsetSouthCenter - evenSizeCorrection * width;
        int nLines = (diameter + 1) / 2;
        int ySouth = y;
        int yNorth = y - evenSizeCorrection;
        do {
            int packed;
            boolean tSouthVisible = ySouth >= 0 && ySouth < height;
            boolean tNorthVisible = yNorth >= 0 && yNorth < height;
            int offsetSE = offsetSouthCenter;
            int offsetSW = offsetSouthCenter - evenSizeCorrection;
            int offsetNE = offsetNorthCenter;
            int offsetNW = offsetNorthCenter - evenSizeCorrection;
            int xEast = x;
            int xWest = x - evenSizeCorrection;
            do {
                int zPixel;
                boolean tWestVisible = xWest >= 0 && xWest < width;
                boolean tEastVisible = xEast >= 0 && xEast < width;
                if ((zPixel = z - ((packed = sphereShape[offsetSphere++]) & 0x7F)) >= slab && zPixel <= depth) {
                    if (tSouthVisible) {
                        if (tEastVisible && zPixel <= zbuf[offsetSE]) {
                            if (zPixel < zbuf[offsetSE]) {
                                zbuf[offsetSE] = (short)zPixel;
                                pbuf[offsetSE] = shades[packed >> 7 & 0x3F];
                            } else {
                                this.g3d.averageOffsetArgb(offsetSE, shades[packed >> 7 & 0x3F]);
                            }
                        }
                        if (tWestVisible && zPixel <= zbuf[offsetSW]) {
                            if (zPixel < zbuf[offsetSW]) {
                                zbuf[offsetSW] = (short)zPixel;
                                pbuf[offsetSW] = shades[packed >> 13 & 0x3F];
                            } else {
                                this.g3d.averageOffsetArgb(offsetSW, shades[packed >> 13 & 0x3F]);
                            }
                        }
                    }
                    if (tNorthVisible) {
                        if (tEastVisible && zPixel <= zbuf[offsetNE]) {
                            if (zPixel < zbuf[offsetNE]) {
                                zbuf[offsetNE] = (short)zPixel;
                                pbuf[offsetNE] = shades[packed >> 19 & 0x3F];
                            } else {
                                this.g3d.averageOffsetArgb(offsetNE, shades[packed >> 19 & 0x3F]);
                            }
                        }
                        if (tWestVisible && zPixel <= zbuf[offsetNW]) {
                            if (zPixel < zbuf[offsetNW]) {
                                zbuf[offsetNW] = (short)zPixel;
                                pbuf[offsetNW] = shades[packed >> 25 & 0x3F];
                            } else {
                                this.g3d.averageOffsetArgb(offsetNW, shades[packed >> 25 & 0x3F]);
                            }
                        }
                    }
                }
                ++offsetSE;
                --offsetSW;
                ++offsetNE;
                --offsetNW;
                ++xEast;
                --xWest;
            } while (packed >= 0);
            offsetSouthCenter += width;
            offsetNorthCenter -= width;
            ++ySouth;
            --yNorth;
        } while (--nLines > 0);
    }

    int[] getSphereShape(int diameter) {
        int[] ss;
        if (diameter > 128) {
            diameter = 128;
        }
        if ((ss = sphereShapeCache[diameter - 1]) != null) {
            return ss;
        }
        int[] nArray = this.createSphereShape(diameter);
        Sphere3D.sphereShapeCache[diameter - 1] = nArray;
        ss = nArray;
        return ss;
    }

    static void flushImageCache() {
        sphereShapeCache = new int[128][];
    }

    int[] createSphereShape(int diameter) {
        float radiusF = (float)diameter / 2.0f;
        float radiusF2 = radiusF * radiusF;
        int offset = 0;
        boolean visibleCount = false;
        int countSE = 0;
        int radius = diameter / 2;
        float y = -radiusF + 0.5f;
        int i = 0;
        while (i < diameter) {
            float y2 = y * y;
            float x = -radiusF + 0.5f;
            int j = 0;
            while (j < diameter) {
                float z2 = radiusF2 - y2 - x * x;
                if (z2 >= 0.0f) {
                    float z = (float)Math.sqrt(z2);
                    this.intensities[offset] = Shade3D.calcDitheredNoisyIntensity(x, y, z);
                    this.heights[offset] = (byte)(z + 0.5f);
                    if (j >= radius && i >= radius) {
                        ++countSE;
                    }
                } else {
                    this.intensities[offset] = -1;
                    this.heights[offset] = -1;
                }
                ++offset;
                ++j;
                x += 1.0f;
            }
            ++i;
            y += 1.0f;
        }
        int[] sphereShape = new int[countSE];
        int offset2 = 0;
        for (int i2 = radius; i2 < diameter; ++i2) {
            int offsetRowSouth = i2 * diameter;
            int offsetRowNorth = (diameter - i2 - 1) * diameter;
            for (int j = radius; j < diameter && this.heights[offsetRowSouth + j] != -1; ++j) {
                int packed = this.heights[offsetRowSouth + j];
                packed |= this.intensities[offsetRowSouth + j] << 7;
                packed |= this.intensities[offsetRowSouth + diameter - j - 1] << 13;
                packed |= this.intensities[offsetRowNorth + j] << 19;
                sphereShape[offset2++] = packed |= this.intensities[offsetRowNorth + diameter - j - 1] << 25;
            }
            int n = offset2 - 1;
            sphereShape[n] = sphereShape[n] | Integer.MIN_VALUE;
        }
        return sphereShape;
    }
}

