/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomEnumeration;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.LonePair;

public class AtomContainer
extends ChemObject
implements Serializable,
Cloneable {
    protected int atomCount = 0;
    protected int electronContainerCount = 0;
    protected int growArraySize = 10;
    protected Atom[] atoms;
    protected ElectronContainer[] electronContainers;

    public AtomContainer() {
        this(10, 10);
    }

    public AtomContainer(AtomContainer ac) {
        this();
        this.add(ac);
    }

    public AtomContainer(int atomCount, int electronContainerCount) {
        this.atoms = new Atom[atomCount];
        this.electronContainers = new ElectronContainer[electronContainerCount];
    }

    public void setAtoms(Atom[] atoms) {
        this.atoms = atoms;
        this.setAtomCount(atoms.length);
    }

    public void setElectronContainers(Bond[] electronContainers) {
        this.electronContainers = electronContainers;
        this.setElectronContainerCount(electronContainers.length);
    }

    public void setAtomAt(int number, Atom atom) {
        this.atoms[number] = atom;
    }

    public Atom getAtomAt(int number) {
        return this.atoms[number];
    }

    public Bond getBondAt(int number) {
        return this.getBonds()[number];
    }

    public void setElectronContainerAt(int number, ElectronContainer ec) {
        this.electronContainers[number] = ec;
    }

    public void setElectronContainerCount(int electronContainerCount) {
        this.electronContainerCount = electronContainerCount;
    }

    public void setAtomCount(int atomCount) {
        this.atomCount = atomCount;
    }

    public Atom[] getAtoms() {
        Atom[] returnAtoms = new Atom[this.getAtomCount()];
        System.arraycopy(this.atoms, 0, returnAtoms, 0, returnAtoms.length);
        return returnAtoms;
    }

    public Enumeration atoms() {
        return new AtomEnumeration(this);
    }

    public ElectronContainer[] getElectronContainers() {
        ElectronContainer[] returnElectronContainers = new ElectronContainer[this.getElectronContainerCount()];
        System.arraycopy(this.electronContainers, 0, returnElectronContainers, 0, returnElectronContainers.length);
        return returnElectronContainers;
    }

    public Bond[] getBonds() {
        int bondCount = this.getBondCount();
        Bond[] result = new Bond[bondCount];
        int bondCounter = 0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            ElectronContainer ec = this.getElectronContainerAt(i);
            if (!(ec instanceof Bond)) continue;
            result[bondCounter] = (Bond)ec;
            ++bondCounter;
        }
        return result;
    }

    public LonePair[] getLonePairs() {
        int count = this.getLonePairCount();
        LonePair[] result = new LonePair[count];
        int counter = 0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            ElectronContainer ec = this.getElectronContainerAt(i);
            if (!(ec instanceof LonePair)) continue;
            result[counter] = (LonePair)ec;
            ++counter;
        }
        return result;
    }

    public LonePair[] getLonePairs(Atom atom) {
        Vector<ElectronContainer> lps = new Vector<ElectronContainer>();
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            ElectronContainer ec = this.getElectronContainerAt(i);
            if (!(ec instanceof LonePair) || !((LonePair)ec).contains(atom)) continue;
            lps.add(ec);
        }
        Object[] result = new LonePair[lps.size()];
        lps.copyInto(result);
        return result;
    }

    public Atom getFirstAtom() {
        return this.atoms[0];
    }

    public Atom getLastAtom() {
        return this.atoms[this.getAtomCount() - 1];
    }

    public int getAtomNumber(Atom atom) {
        for (int f = 0; f < this.getAtomCount(); ++f) {
            if (this.getAtomAt(f) != atom) continue;
            return f;
        }
        return -1;
    }

    public int getBondNumber(Atom a1, Atom a2) {
        return this.getBondNumber(this.getBond(a1, a2));
    }

    public int getBondNumber(Bond b) {
        for (int f = 0; f < this.getElectronContainerCount(); ++f) {
            if (this.getElectronContainerAt(f) != b) continue;
            return f;
        }
        return -1;
    }

    public ElectronContainer getElectronContainerAt(int number) {
        return this.electronContainers[number];
    }

    public Bond getBond(Atom a1, Atom a2) {
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof Bond) || !((Bond)this.electronContainers[i]).contains(a1) || !(this.electronContainers[i] instanceof Bond) || ((Bond)this.electronContainers[i]).getConnectedAtom(a1) != a2) continue;
            return (Bond)this.electronContainers[i];
        }
        return null;
    }

    public Atom[] getConnectedAtoms(Atom atom) {
        Vector atomsVec = this.getConnectedAtomsVector(atom);
        Object[] conAtoms = new Atom[atomsVec.size()];
        atomsVec.copyInto(conAtoms);
        return conAtoms;
    }

    public Vector getConnectedAtomsVector(Atom atom) {
        Vector<Atom> atomsVec = new Vector<Atom>();
        for (int i = 0; i < this.electronContainerCount; ++i) {
            ElectronContainer ec = this.electronContainers[i];
            if (!(ec instanceof Bond) || !((Bond)ec).contains(atom)) continue;
            atomsVec.addElement(((Bond)ec).getConnectedAtom(atom));
        }
        return atomsVec;
    }

    public Bond[] getConnectedBonds(Atom atom) {
        Vector bondsVec = this.getConnectedBondsVector(atom);
        Object[] conBonds = new Bond[bondsVec.size()];
        bondsVec.copyInto(conBonds);
        return conBonds;
    }

    public Vector getConnectedBondsVector(Atom atom) {
        Vector<ElectronContainer> bondsVec = new Vector<ElectronContainer>();
        for (int i = 0; i < this.electronContainerCount; ++i) {
            if (!(this.electronContainers[i] instanceof Bond) || !((Bond)this.electronContainers[i]).contains(atom)) continue;
            bondsVec.addElement(this.electronContainers[i]);
        }
        return bondsVec;
    }

    public ElectronContainer[] getConnectedElectronContainers(Atom atom) {
        Vector<ElectronContainer> bondsVec = new Vector<ElectronContainer>();
        for (int i = 0; i < this.electronContainerCount; ++i) {
            if (this.electronContainers[i] instanceof Bond && ((Bond)this.electronContainers[i]).contains(atom)) {
                bondsVec.addElement(this.electronContainers[i]);
                continue;
            }
            if (!(this.electronContainers[i] instanceof LonePair) || !((LonePair)this.electronContainers[i]).contains(atom)) continue;
            bondsVec.addElement(this.electronContainers[i]);
        }
        Object[] cons = new ElectronContainer[bondsVec.size()];
        bondsVec.copyInto(cons);
        return cons;
    }

    public int getBondCount(int atomnumber) {
        return this.getBondCount(this.getAtomAt(atomnumber));
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public int getElectronContainerCount() {
        return this.electronContainerCount;
    }

    public int getLonePairCount() {
        int count = 0;
        for (int i = 0; i < this.electronContainerCount; ++i) {
            if (!(this.electronContainers[i] instanceof LonePair)) continue;
            ++count;
        }
        return count;
    }

    public int getBondCount() {
        int bondCount = 0;
        for (int i = 0; i < this.electronContainerCount; ++i) {
            if (!(this.electronContainers[i] instanceof Bond)) continue;
            ++bondCount;
        }
        return bondCount;
    }

    public int getBondCount(Atom atom) {
        int count = 0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof Bond) || !((Bond)this.electronContainers[i]).contains(atom)) continue;
            ++count;
        }
        return count;
    }

    public int getLonePairCount(Atom atom) {
        int count = 0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof LonePair) || !((LonePair)this.electronContainers[i]).contains(atom)) continue;
            ++count;
        }
        return count;
    }

    public double getBondOrderSum(Atom atom) {
        double count = 0.0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof Bond) || !((Bond)this.electronContainers[i]).contains(atom)) continue;
            count += ((Bond)this.electronContainers[i]).getOrder();
        }
        return count;
    }

    public double getHighestCurrentBondOrder(Atom atom) {
        return this.getMaximumBondOrder(atom);
    }

    public double getMaximumBondOrder(Atom atom) {
        double max = 0.0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof Bond) || !((Bond)this.electronContainers[i]).contains(atom) || !(((Bond)this.electronContainers[i]).getOrder() > max)) continue;
            max = ((Bond)this.electronContainers[i]).getOrder();
        }
        return max;
    }

    public double getMinimumBondOrder(Atom atom) {
        double min = 6.0;
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof Bond) || !((Bond)this.electronContainers[i]).contains(atom) || !(((Bond)this.electronContainers[i]).getOrder() < min)) continue;
            min = ((Bond)this.electronContainers[i]).getOrder();
        }
        return min;
    }

    public AtomContainer getIntersection(AtomContainer ac) {
        int i;
        AtomContainer intersection = new AtomContainer();
        for (i = 0; i < this.getAtomCount(); ++i) {
            if (!ac.contains(this.getAtomAt(i))) continue;
            intersection.addAtom(this.getAtomAt(i));
        }
        for (i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!ac.contains(this.getElectronContainerAt(i))) continue;
            intersection.addElectronContainer(this.getElectronContainerAt(i));
        }
        return intersection;
    }

    public Point2d get2DCenter() {
        double centerX = 0.0;
        double centerY = 0.0;
        double counter = 0.0;
        for (int i = 0; i < this.getAtomCount(); ++i) {
            if (this.atoms[i].getPoint2d() == null) continue;
            centerX += this.atoms[i].getPoint2d().x;
            centerY += this.atoms[i].getPoint2d().y;
            counter += 1.0;
        }
        Point2d point = new Point2d(centerX / counter, centerY / counter);
        return point;
    }

    public Point3d get3DCenter() {
        double centerX = 0.0;
        double centerY = 0.0;
        double centerZ = 0.0;
        double counter = 0.0;
        for (int i = 0; i < this.getAtomCount(); ++i) {
            if (this.atoms[i].getPoint3d() == null) continue;
            centerX += this.atoms[i].getPoint3d().x;
            centerY += this.atoms[i].getPoint3d().y;
            centerZ += this.atoms[i].getPoint3d().z;
            counter += 1.0;
        }
        Point3d point = new Point3d(centerX / counter, centerY / counter, centerZ / counter);
        return point;
    }

    public double[][] getConnectionMatrix() {
        ElectronContainer ec = null;
        double[][] conMat = new double[this.getAtomCount()][this.getAtomCount()];
        for (int f = 0; f < this.getElectronContainerCount(); ++f) {
            ec = this.getElectronContainerAt(f);
            if (!(ec instanceof Bond)) continue;
            Bond bond = (Bond)ec;
            int i = this.getAtomNumber(bond.getAtomAt(0));
            int j = this.getAtomNumber(bond.getAtomAt(1));
            conMat[i][j] = bond.getOrder();
            conMat[j][i] = bond.getOrder();
        }
        return conMat;
    }

    public int[][] getAdjacencyMatrix() {
        ElectronContainer ec = null;
        int[][] conMat = new int[this.getAtomCount()][this.getAtomCount()];
        for (int f = 0; f < this.getElectronContainerCount(); ++f) {
            ec = this.getElectronContainerAt(f);
            if (!(ec instanceof Bond)) continue;
            Bond bond = (Bond)ec;
            int i = this.getAtomNumber(bond.getAtomAt(0));
            int j = this.getAtomNumber(bond.getAtomAt(1));
            conMat[i][j] = 1;
            conMat[j][i] = 1;
        }
        return conMat;
    }

    public void addBonds(double maxbondlength) {
        for (int i = 0; i < this.atomCount; ++i) {
            for (int j = i + 1; j < this.atomCount; ++j) {
                if (!(this.atoms[i].getPoint3d().distance(this.atoms[j].getPoint3d()) <= maxbondlength)) continue;
                this.addBond(new Bond(this.atoms[i], this.atoms[j], 1.0));
            }
        }
    }

    public void addElectronContainers(AtomContainer atomContainer) {
        for (int f = 0; f < atomContainer.getElectronContainerCount(); ++f) {
            if (this.contains(atomContainer.getElectronContainerAt(f))) continue;
            this.addElectronContainer(atomContainer.getElectronContainerAt(f));
        }
    }

    public void add(AtomContainer atomContainer) {
        int f;
        for (f = 0; f < atomContainer.getAtomCount(); ++f) {
            if (this.contains(atomContainer.getAtomAt(f))) continue;
            this.addAtom(atomContainer.getAtomAt(f));
        }
        for (f = 0; f < atomContainer.getElectronContainerCount(); ++f) {
            if (this.contains(atomContainer.getElectronContainerAt(f))) continue;
            this.addElectronContainer(atomContainer.getElectronContainerAt(f));
        }
    }

    public void addAtom(Atom atom) {
        if (this.contains(atom)) {
            return;
        }
        if (this.atomCount + 1 >= this.atoms.length) {
            this.growAtomArray();
        }
        this.atoms[this.atomCount] = atom;
        ++this.atomCount;
    }

    public void addBond(Bond bond) {
        this.addElectronContainer(bond);
    }

    public void addElectronContainer(ElectronContainer ec) {
        if (this.electronContainerCount + 1 >= this.electronContainers.length) {
            this.growElectronContainerArray();
        }
        this.electronContainers[this.electronContainerCount] = ec;
        ++this.electronContainerCount;
    }

    public void remove(AtomContainer atomContainer) {
        int f;
        for (f = 0; f < atomContainer.getAtomCount(); ++f) {
            this.removeAtom(atomContainer.getAtomAt(f));
        }
        for (f = 0; f < atomContainer.getElectronContainerCount(); ++f) {
            this.removeElectronContainer(atomContainer.getElectronContainerAt(f));
        }
    }

    public ElectronContainer removeElectronContainer(int position) {
        ElectronContainer ec = this.getElectronContainerAt(position);
        for (int i = position; i < this.electronContainerCount - 1; ++i) {
            this.electronContainers[i] = this.electronContainers[i + 1];
        }
        this.electronContainers[this.electronContainerCount - 1] = null;
        --this.electronContainerCount;
        return ec;
    }

    public ElectronContainer removeElectronContainer(ElectronContainer ec) {
        for (int i = this.getElectronContainerCount() - 1; i >= 0; --i) {
            if (!this.electronContainers[i].equals(ec)) continue;
            return this.removeElectronContainer(i);
        }
        return null;
    }

    public Bond removeBond(Atom a1, Atom a2) {
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (!(this.electronContainers[i] instanceof Bond) || !((Bond)this.electronContainers[i]).contains(a1) || ((Bond)this.electronContainers[i]).getConnectedAtom(a1) != a2) continue;
            return (Bond)this.removeElectronContainer(this.electronContainers[i]);
        }
        return null;
    }

    public void removeAtom(int position) {
        for (int i = position; i < this.atomCount - 1; ++i) {
            this.atoms[i] = this.atoms[i + 1];
        }
        this.atoms[this.atomCount - 1] = null;
        --this.atomCount;
    }

    public void removeAtomAndConnectedElectronContainers(Atom atom) {
        int position = this.getAtomNumber(atom);
        if (position != -1) {
            ElectronContainer[] electronContainers = this.getConnectedElectronContainers(atom);
            for (int f = 0; f < electronContainers.length; ++f) {
                this.removeElectronContainer(electronContainers[f]);
            }
            this.removeAtom(position);
        }
    }

    public void removeAtom(Atom atom) {
        int position = this.getAtomNumber(atom);
        if (position != -1) {
            this.removeAtom(position);
        }
    }

    public void removeAllElements() {
        this.atoms = new Atom[this.growArraySize];
        this.electronContainers = new ElectronContainer[this.growArraySize];
        this.atomCount = 0;
        this.electronContainerCount = 0;
    }

    public void removeAllElectronContainers() {
        this.electronContainers = new ElectronContainer[this.growArraySize];
        this.electronContainerCount = 0;
    }

    public void removeAllBonds() {
        Bond[] bonds = this.getBonds();
        for (int i = 0; i < bonds.length; ++i) {
            this.removeElectronContainer(bonds[i]);
        }
    }

    public void addBond(int atom1, int atom2, double order, int stereo) {
        Bond bond = new Bond(this.getAtomAt(atom1), this.getAtomAt(atom2), order, stereo);
        if (this.contains(bond)) {
            return;
        }
        if (this.electronContainerCount >= this.electronContainers.length) {
            this.growElectronContainerArray();
        }
        this.addBond(bond);
    }

    public void addBond(int atom1, int atom2, double order) {
        Bond bond = new Bond(this.getAtomAt(atom1), this.getAtomAt(atom2), order);
        if (this.electronContainerCount >= this.electronContainers.length) {
            this.growElectronContainerArray();
        }
        this.addBond(bond);
    }

    public void addLonePair(int atomID) {
        this.addElectronContainer(new LonePair(this.atoms[atomID]));
    }

    public boolean contains(ElectronContainer ec) {
        for (int i = 0; i < this.getElectronContainerCount(); ++i) {
            if (ec != this.electronContainers[i]) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Atom atom) {
        for (int i = 0; i < this.getAtomCount(); ++i) {
            if (atom != this.atoms[i]) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append("AtomContainer(");
        s.append(this.hashCode() + ", ");
        s.append("#A:" + this.getAtomCount() + ", ");
        s.append("#EC:" + this.getElectronContainerCount() + ", ");
        for (i = 0; i < this.getAtomCount(); ++i) {
            s.append(this.getAtomAt(i).toString() + ", ");
        }
        for (i = 0; i < this.getElectronContainerCount(); ++i) {
            ElectronContainer ec = this.getElectronContainerAt(i);
            if (ec == null) continue;
            s.append(ec.toString() + ", ");
        }
        s.append(")");
        return s.toString();
    }

    public Object clone() {
        int f;
        AtomContainer o = null;
        ElectronContainer ec = null;
        ElectronContainer newEC = null;
        try {
            o = (AtomContainer)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        o.removeAllElements();
        for (f = 0; f < this.getAtomCount(); ++f) {
            o.addAtom((Atom)this.getAtomAt(f).clone());
        }
        for (f = 0; f < this.getElectronContainerCount(); ++f) {
            ec = this.getElectronContainerAt(f);
            newEC = new ElectronContainer();
            if (ec instanceof Bond) {
                Bond bond = (Bond)ec;
                newEC = new Bond();
                Atom[] natoms = bond.getAtoms();
                Atom[] newAtoms = new Atom[natoms.length];
                for (int g = 0; g < natoms.length; ++g) {
                    try {
                        newAtoms[g] = o.getAtomAt(this.getAtomNumber(natoms[g]));
                        continue;
                    }
                    catch (Exception exc) {
                        System.out.println("natoms[g]: " + natoms[g]);
                        exc.printStackTrace();
                    }
                }
                ((Bond)newEC).setAtoms(newAtoms);
                ((Bond)newEC).setOrder(bond.getOrder());
            } else if (ec instanceof LonePair) {
                Atom a = ((LonePair)ec).getAtom();
                newEC = new LonePair();
                ((LonePair)newEC).setAtom(a);
            } else {
                System.out.println("Expecting EC, got: " + ec.getClass().getName());
                newEC = (ElectronContainer)ec.clone();
            }
            o.addElectronContainer(newEC);
        }
        return o;
    }

    public Object shallowCopy() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return o;
    }

    protected void growElectronContainerArray() {
        this.growArraySize = this.electronContainers.length;
        ElectronContainer[] newelectronContainers = new ElectronContainer[this.electronContainers.length + this.growArraySize];
        System.arraycopy(this.electronContainers, 0, newelectronContainers, 0, this.electronContainers.length);
        this.electronContainers = newelectronContainers;
    }

    protected void growAtomArray() {
        this.growArraySize = this.atoms.length;
        Atom[] newatoms = new Atom[this.atoms.length + this.growArraySize];
        System.arraycopy(this.atoms, 0, newatoms, 0, this.atoms.length);
        this.atoms = newatoms;
    }
}

