/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;

public class Crystal
extends AtomContainer
implements Serializable,
Cloneable {
    private double ax;
    private double ay;
    private double az;
    private double bx;
    private double by;
    private double bz;
    private double cx;
    private double cy;
    private double cz;
    private int Z = 1;
    private String spaceGroup = "P1";

    public Crystal() {
        this.setZeroAxes();
    }

    public Crystal(AtomContainer ac) {
        this();
        this.add(ac);
    }

    public void setA(double x, double y, double z) {
        this.ax = x;
        this.ay = y;
        this.az = z;
    }

    public double[] getA() {
        double[] result = new double[]{this.ax, this.ay, this.az};
        return result;
    }

    public void add(AtomContainer ac) {
        super.add(ac);
    }

    public void addAtom(Atom a) {
        super.addAtom(a);
    }

    public void setB(double x, double y, double z) {
        this.bx = x;
        this.by = y;
        this.bz = z;
    }

    public double[] getB() {
        double[] result = new double[]{this.bx, this.by, this.bz};
        return result;
    }

    public void setC(double x, double y, double z) {
        this.cx = x;
        this.cy = y;
        this.cz = z;
    }

    public double[] getC() {
        double[] result = new double[]{this.cx, this.cy, this.cz};
        return result;
    }

    public String getSpaceGroup() {
        return this.spaceGroup;
    }

    public void setSpaceGroup(String group) {
        this.spaceGroup = group;
    }

    public int getZ() {
        return this.Z;
    }

    public void setZ(int z) {
        this.Z = z;
    }

    public Object clone() {
        Crystal o = null;
        try {
            o = (Crystal)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        o.setSpaceGroup(this.getSpaceGroup());
        o.setA(this.ax, this.ay, this.az);
        o.setB(this.bx, this.by, this.bz);
        o.setC(this.cx, this.cy, this.cz);
        return o;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Crystal{");
        sb.append("SG=" + this.getSpaceGroup() + ", ");
        sb.append("Z=" + this.getZ() + ", ");
        sb.append("a=(" + this.ax + ", " + this.ay + ", " + this.az + "), ");
        sb.append("b=(" + this.bx + ", " + this.by + ", " + this.bz + "), ");
        sb.append("c=(" + this.cx + ", " + this.cy + ", " + this.cz + "), ");
        sb.append("#A=" + this.getAtomCount() + "}");
        return sb.toString();
    }

    private void setZeroAxes() {
        this.ax = 0.0;
        this.ay = 0.0;
        this.az = 0.0;
        this.bx = 0.0;
        this.by = 0.0;
        this.bz = 0.0;
        this.cx = 0.0;
        this.cy = 0.0;
        this.cz = 0.0;
    }
}

