/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;

public class PseudoAtom
extends Atom
implements Serializable,
Cloneable {
    private String label;

    public PseudoAtom() {
        this("");
    }

    public PseudoAtom(String label) {
        super("R");
        this.label = label;
        this.fractionalPoint3d = null;
        this.point3d = null;
        this.point2d = null;
        super.setHydrogenCount(0);
        super.setStereoParity(-1);
        super.setExactMass(0.0);
        super.setFormalCharge(0);
        super.setCharge(0.0);
    }

    public PseudoAtom(Atom atom) {
        super("R");
        super.setProperties(atom.getProperties());
        this.fractionalPoint3d = atom.fractionalPoint3d;
        this.point3d = atom.point3d;
        this.point2d = atom.point2d;
        this.label = atom.getSymbol();
        super.setHydrogenCount(atom.getHydrogenCount());
        super.setStereoParity(atom.getStereoParity());
        super.setExactMass(atom.getExactMass());
        super.setFormalCharge(atom.getFormalCharge());
        super.setCharge(atom.getCharge());
    }

    public PseudoAtom(String label, Point3d point3d) {
        this(label);
        this.point3d = point3d;
    }

    public PseudoAtom(String label, Point2d point2d) {
        this(label);
        this.point2d = point2d;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setExactMass(double mass) {
    }

    public void setHydrogenCount(int hydrogenCount) {
    }

    public void setFormalCharge(int charge) {
    }

    public void setCharge(double charge) {
    }

    public void setStereoParity(int stereoParity) {
    }

    public String toString() {
        StringBuffer description = new StringBuffer();
        description.append("PseudoAtom(");
        description.append(this.hashCode() + ", ");
        description.append(this.getLabel() + ", ");
        description.append(super.toString());
        description.append(")");
        return description.toString();
    }
}

