/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.plugin;

import java.net.URL;
import java.net.URLClassLoader;
import org.openscience.cdk.tools.LoggingTool;

public class PluginClassLoader
extends URLClassLoader {
    private URL url;
    private static LoggingTool logger = null;

    public PluginClassLoader(URL url) {
        super(new URL[]{url});
        this.url = url;
        if (logger == null) {
            logger = new LoggingTool(this);
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        logger.debug("Loading from plugin jar: " + name);
        Class<?> _class = null;
        try {
            _class = super.findClass(name);
            logger.debug("  found: " + _class);
            return _class;
        }
        catch (ClassNotFoundException exc) {
            logger.debug("  not found in plugin jar");
            try {
                _class = super.loadClass(name);
                logger.debug("  found: " + _class);
            }
            catch (ClassNotFoundException exc2) {
                logger.error("  not found in elsewhere");
                logger.debug(exc2);
                throw exc2;
            }
            return _class;
        }
    }
}

